/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.view.View;
import android.widget.ProgressBar;
import com.androidquery.AQuery;
import com.androidquery.util.AQUtility;

public class Progress
implements Runnable {
    private ProgressBar pb;
    private ProgressDialog pd;
    private Activity act;
    private View view;
    private boolean unknown;
    private int bytes;
    private int current;
    private String url;

    public Progress(Object p) {
        if (p instanceof ProgressBar) {
            this.pb = (ProgressBar)p;
        } else if (p instanceof ProgressDialog) {
            this.pd = (ProgressDialog)p;
        } else if (p instanceof Activity) {
            this.act = (Activity)p;
        } else if (p instanceof View) {
            this.view = (View)p;
        }
    }

    public void reset() {
        if (this.pb != null) {
            this.pb.setProgress(0);
            this.pb.setMax(10000);
        }
        if (this.pd != null) {
            this.pd.setProgress(0);
            this.pd.setMax(10000);
        }
        if (this.act != null) {
            this.act.setProgress(0);
        }
        this.unknown = false;
        this.current = 0;
        this.bytes = 10000;
    }

    public void setBytes(int bytes) {
        if (bytes <= 0) {
            this.unknown = true;
            bytes = 10000;
        }
        this.bytes = bytes;
        if (this.pb != null) {
            this.pb.setProgress(0);
            this.pb.setMax(bytes);
        }
        if (this.pd != null) {
            this.pd.setProgress(0);
            this.pd.setMax(bytes);
        }
    }

    public void increment(int delta) {
        if (this.pb != null) {
            this.pb.incrementProgressBy(this.unknown ? 1 : delta);
        }
        if (this.pd != null) {
            this.pd.incrementProgressBy(this.unknown ? 1 : delta);
        }
        if (this.act != null) {
            int p;
            if (this.unknown) {
                p = this.current++;
            } else {
                this.current += delta;
                p = 10000 * this.current / this.bytes;
            }
            if (p > 9999) {
                p = 9999;
            }
            this.act.setProgress(p);
        }
    }

    public void done() {
        if (this.pb != null) {
            this.pb.setProgress(this.pb.getMax());
        }
        if (this.pd != null) {
            this.pd.setProgress(this.pd.getMax());
        }
        if (this.act != null) {
            this.act.setProgress(9999);
        }
    }

    @Override
    public void run() {
        this.dismiss(this.url);
    }

    public void show(String url) {
        this.reset();
        if (this.pd != null) {
            AQuery aq = new AQuery(this.pd.getContext());
            aq.show((Dialog)this.pd);
        }
        if (this.act != null) {
            this.act.setProgressBarIndeterminateVisibility(true);
            this.act.setProgressBarVisibility(true);
        }
        if (this.pb != null) {
            this.pb.setTag(1090453505, (Object)url);
            this.pb.setVisibility(0);
        }
        if (this.view != null) {
            this.view.setTag(1090453505, (Object)url);
            this.view.setVisibility(0);
        }
    }

    public void hide(String url) {
        if (AQUtility.isUIThread()) {
            this.dismiss(url);
        } else {
            this.url = url;
            AQUtility.post(this);
        }
    }

    private void dismiss(String url) {
        Object tag;
        ProgressBar pv;
        if (this.pd != null) {
            AQuery aq = new AQuery(this.pd.getContext());
            aq.dismiss((Dialog)this.pd);
        }
        if (this.act != null) {
            this.act.setProgressBarIndeterminateVisibility(false);
            this.act.setProgressBarVisibility(false);
        }
        if (this.pb != null) {
            this.pb.setTag(1090453505, (Object)url);
            this.pb.setVisibility(0);
        }
        if ((pv = this.pb) == null) {
            pv = this.view;
        }
        if (pv != null && ((tag = pv.getTag(1090453505)) == null || tag.equals(url))) {
            pv.setTag(1090453505, null);
            if (this.pb != null && this.pb.isIndeterminate()) {
                pv.setVisibility(8);
            }
        }
    }

    private void showProgress(Object p, String url, boolean show) {
        if (p != null) {
            if (p instanceof View) {
                View pv = (View)p;
                ProgressBar pbar = null;
                if (p instanceof ProgressBar) {
                    pbar = (ProgressBar)p;
                }
                if (show) {
                    pv.setTag(1090453505, (Object)url);
                    pv.setVisibility(0);
                    if (pbar != null) {
                        pbar.setProgress(0);
                        pbar.setMax(100);
                    }
                } else {
                    Object tag = pv.getTag(1090453505);
                    if (tag == null || tag.equals(url)) {
                        pv.setTag(1090453505, null);
                        if (pbar != null && pbar.isIndeterminate()) {
                            pv.setVisibility(8);
                        }
                    }
                }
            } else if (p instanceof Dialog) {
                Dialog pd = (Dialog)p;
                AQuery aq = new AQuery(pd.getContext());
                if (show) {
                    aq.show(pd);
                } else {
                    aq.dismiss(pd);
                }
            } else if (p instanceof Activity) {
                Activity act = (Activity)p;
                act.setProgressBarIndeterminateVisibility(show);
                act.setProgressBarVisibility(show);
                if (show) {
                    act.setProgress(0);
                }
            }
        }
    }
}

