/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.app.Activity;
import android.app.Dialog;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.Gallery;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import com.androidquery.AQuery;
import com.androidquery.callback.BitmapAjaxCallback;
import com.androidquery.util.AQUtility;
import java.io.File;
import java.util.Comparator;

public class Common
implements Comparator<File>,
Runnable,
View.OnClickListener,
View.OnLongClickListener,
AdapterView.OnItemClickListener,
AbsListView.OnScrollListener,
AdapterView.OnItemSelectedListener,
TextWatcher {
    private Object handler;
    private String method;
    private Object[] params;
    private boolean fallback;
    private Class<?>[] sig;
    private int methodId;
    protected static final int STORE_FILE = 1;
    protected static final int CLEAN_CACHE = 2;
    private int scrollState = 0;
    private AbsListView.OnScrollListener osl;
    private int lastBottom;
    private AdapterView.OnItemSelectedListener galleryListener;
    private boolean galleryListen = false;

    public Common forward(Object handler, String callback, boolean fallback, Class<?>[] sig) {
        this.handler = handler;
        this.method = callback;
        this.fallback = fallback;
        this.sig = sig;
        return this;
    }

    public Common method(int methodId, Object ... params) {
        this.methodId = methodId;
        this.params = params;
        return this;
    }

    private Object invoke(Object ... args) {
        if (this.method != null) {
            Object cbo;
            Object[] input = args;
            if (this.params != null) {
                input = this.params;
            }
            if ((cbo = this.handler) == null) {
                cbo = this;
            }
            Object result = AQUtility.invokeHandler(cbo, this.method, this.fallback, true, this.sig, input);
            return result;
        }
        if (this.methodId != 0) {
            switch (this.methodId) {
                case 2: {
                    AQUtility.cleanCache((File)this.params[0], (Long)this.params[1], (Long)this.params[2]);
                    break;
                }
                case 1: {
                    AQUtility.store((File)this.params[0], (byte[])this.params[1]);
                }
            }
        }
        return null;
    }

    @Override
    public int compare(File f1, File f2) {
        long m1 = f1.lastModified();
        long m2 = f2.lastModified();
        if (m2 > m1) {
            return 1;
        }
        if (m2 == m1) {
            return 0;
        }
        return -1;
    }

    @Override
    public void run() {
        this.invoke(new Object[0]);
    }

    public void onClick(View v) {
        this.invoke(v);
    }

    public boolean onLongClick(View v) {
        Object result = this.invoke(v);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public void onItemClick(AdapterView<?> parent, View v, int pos, long id) {
        this.invoke(parent, v, pos, id);
    }

    public void onScroll(AbsListView view, int first, int visibleItemCount, int totalItemCount) {
        this.checkScrolledBottom(view, this.scrollState);
        if (this.osl != null) {
            this.osl.onScroll(view, first, visibleItemCount, totalItemCount);
        }
    }

    public int getScrollState() {
        return this.scrollState;
    }

    public void forward(AbsListView.OnScrollListener listener) {
        this.osl = listener;
    }

    private void checkScrolledBottom(AbsListView view, int scrollState) {
        int cc = view.getCount();
        int last = view.getLastVisiblePosition();
        if (scrollState == 0 && cc == last + 1) {
            if (last != this.lastBottom) {
                this.lastBottom = last;
                this.invoke(view, scrollState);
            }
        } else {
            this.lastBottom = -1;
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.scrollState = scrollState;
        this.checkScrolledBottom(view, scrollState);
        if (view instanceof ExpandableListView) {
            this.onScrollStateChanged((ExpandableListView)view, scrollState);
        } else {
            this.onScrollStateChanged2(view, scrollState);
        }
        if (this.osl != null) {
            this.osl.onScrollStateChanged(view, scrollState);
        }
    }

    private void onScrollStateChanged(ExpandableListView elv, int scrollState) {
        elv.setTag(0x40FF0004, (Object)scrollState);
        if (scrollState == 0) {
            int first = elv.getFirstVisiblePosition();
            int last = elv.getLastVisiblePosition();
            int count = last - first;
            ExpandableListAdapter ela = elv.getExpandableListAdapter();
            int i = 0;
            while (i <= count) {
                View convertView;
                Long targetPacked;
                long packed = elv.getExpandableListPosition(i + first);
                int group = ExpandableListView.getPackedPositionGroup((long)packed);
                int child = ExpandableListView.getPackedPositionChild((long)packed);
                if (group >= 0 && (targetPacked = (Long)(convertView = elv.getChildAt(i)).getTag(0x40FF0004)) != null && targetPacked == packed) {
                    if (child == -1) {
                        ela.getGroupView(group, elv.isGroupExpanded(group), convertView, (ViewGroup)elv);
                    } else {
                        ela.getChildView(group, child, child == ela.getChildrenCount(group) - 1, convertView, (ViewGroup)elv);
                    }
                    convertView.setTag(0x40FF0004, null);
                }
                ++i;
            }
        }
    }

    private void onScrollStateChanged2(AbsListView lv, int scrollState) {
        lv.setTag(0x40FF0004, (Object)scrollState);
        if (scrollState == 0) {
            int first = lv.getFirstVisiblePosition();
            int last = lv.getLastVisiblePosition();
            int count = last - first;
            ListAdapter la = (ListAdapter)lv.getAdapter();
            int i = 0;
            while (i <= count) {
                long packed = i + first;
                View convertView = lv.getChildAt(i);
                Number targetPacked = (Number)convertView.getTag(0x40FF0004);
                if (targetPacked != null) {
                    la.getView((int)packed, convertView, (ViewGroup)lv);
                    convertView.setTag(0x40FF0004, null);
                }
                ++i;
            }
        }
    }

    public static boolean shouldDelay(int groupPosition, int childPosition, View convertView, ViewGroup parent, String url) {
        Integer scrollState;
        if (url == null || BitmapAjaxCallback.isMemoryCached(url)) {
            return false;
        }
        AbsListView lv = (AbsListView)parent;
        AbsListView.OnScrollListener sl = (AbsListView.OnScrollListener)parent.getTag(1090453506);
        if (sl == null) {
            sl = new Common();
            lv.setOnScrollListener(sl);
            parent.setTag(1090453506, (Object)sl);
        }
        if ((scrollState = (Integer)lv.getTag(0x40FF0004)) == null || scrollState == 0 || scrollState == 1) {
            return false;
        }
        long packed = childPosition;
        if (parent instanceof ExpandableListView) {
            packed = ExpandableListView.getPackedPositionForChild((int)groupPosition, (int)childPosition);
        }
        convertView.setTag(0x40FF0004, (Object)packed);
        return true;
    }

    public static boolean shouldDelay(int position, View convertView, ViewGroup parent, String url) {
        if (parent instanceof Gallery) {
            return Common.shouldDelayGallery(position, convertView, parent, url);
        }
        return Common.shouldDelay(-2, position, convertView, parent, url);
    }

    public static boolean shouldDelay(View convertView, ViewGroup parent, String url, float velocity, boolean fileCheck) {
        return Common.shouldDelay(-1, convertView, parent, url);
    }

    private static boolean shouldDelayGallery(int position, View convertView, ViewGroup parent, String url) {
        if (url == null || BitmapAjaxCallback.isMemoryCached(url)) {
            return false;
        }
        Gallery gallery = (Gallery)parent;
        Integer selected = (Integer)gallery.getTag(0x40FF0004);
        if (selected == null) {
            selected = 0;
            gallery.setTag(0x40FF0004, (Object)0);
            gallery.setCallbackDuringFling(false);
            Common common = new Common();
            common.listen(gallery);
        }
        int first = gallery.getFirstVisiblePosition();
        int last = gallery.getLastVisiblePosition();
        int diff = last - first;
        int delta = diff / 2 + 1;
        int from = selected - delta;
        int to = selected + delta;
        if (from < 0) {
            to -= from;
            from = 0;
        }
        if (position >= from && position <= to) {
            convertView.setTag(0x40FF0004, (Object)position);
            return false;
        }
        convertView.setTag(0x40FF0004, null);
        return true;
    }

    public void afterTextChanged(Editable s) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.invoke(s, start, before, count);
    }

    public void listen(Gallery gallery) {
        this.galleryListener = gallery.getOnItemSelectedListener();
        this.galleryListen = true;
        gallery.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
    }

    public void onItemSelected(AdapterView<?> parent, View v, int pos, long id) {
        Integer selected;
        this.invoke(parent, v, pos, id);
        if (this.galleryListener != null) {
            this.galleryListener.onItemSelected(parent, v, pos, id);
        }
        if (this.galleryListen && (selected = (Integer)parent.getTag(0x40FF0004)) != pos) {
            Adapter adapter = parent.getAdapter();
            parent.setTag(0x40FF0004, (Object)pos);
            int count = parent.getChildCount();
            int first = parent.getFirstVisiblePosition();
            int i = 0;
            while (i < count) {
                View convertView = parent.getChildAt(i);
                int drawPos = first + i;
                Integer lastDrawn = (Integer)convertView.getTag(0x40FF0004);
                if (lastDrawn == null || lastDrawn != drawPos) {
                    adapter.getView(drawPos, convertView, parent);
                }
                ++i;
            }
        }
    }

    public void onNothingSelected(AdapterView<?> arg0) {
        if (this.galleryListener != null) {
            this.galleryListener.onNothingSelected(arg0);
        }
    }

    public static void showProgress(Object p, String url, boolean show) {
        if (p != null) {
            if (p instanceof View) {
                View pv = (View)p;
                ProgressBar pbar = null;
                if (p instanceof ProgressBar) {
                    pbar = (ProgressBar)p;
                }
                if (show) {
                    pv.setTag(1090453505, (Object)url);
                    pv.setVisibility(0);
                    if (pbar != null) {
                        pbar.setProgress(0);
                        pbar.setMax(100);
                    }
                } else {
                    Object tag = pv.getTag(1090453505);
                    if (tag == null || tag.equals(url)) {
                        pv.setTag(1090453505, null);
                        if (pbar == null || pbar.isIndeterminate()) {
                            pv.setVisibility(8);
                        }
                    }
                }
            } else if (p instanceof Dialog) {
                Dialog pd = (Dialog)p;
                AQuery aq = new AQuery(pd.getContext());
                if (show) {
                    aq.show(pd);
                } else {
                    aq.dismiss(pd);
                }
            } else if (p instanceof Activity) {
                Activity act = (Activity)p;
                act.setProgressBarIndeterminateVisibility(show);
                act.setProgressBarVisibility(show);
                if (show) {
                    act.setProgress(0);
                }
            }
        }
    }
}

