/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.callback;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.media.ExifInterface;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.androidquery.auth.AccountHandle;
import com.androidquery.callback.AbstractAjaxCallback;
import com.androidquery.callback.AjaxStatus;
import com.androidquery.callback.ImageOptions;
import com.androidquery.util.AQUtility;
import com.androidquery.util.BitmapCache;
import com.androidquery.util.Common;
import com.androidquery.util.RatioDrawable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.http.HttpHost;

public class BitmapAjaxCallback
extends AbstractAjaxCallback<Bitmap, BitmapAjaxCallback> {
    private static int SMALL_MAX = 20;
    private static int BIG_MAX = 20;
    private static int SMALL_PIXELS = 2500;
    private static int BIG_PIXELS = 160000;
    private static int BIG_TPIXELS = 1000000;
    private static boolean DELAY_WRITE = false;
    private static Map<String, Bitmap> smallCache;
    private static Map<String, Bitmap> bigCache;
    private static Map<String, Bitmap> invalidCache;
    private static HashMap<String, WeakHashMap<ImageView, BitmapAjaxCallback>> queueMap;
    private WeakReference<ImageView> v;
    private int targetWidth;
    private int fallback;
    private File imageFile;
    private Bitmap bm;
    private int animation;
    private Bitmap preset;
    private float ratio;
    private int round;
    private boolean targetDim = true;
    private float anchor = Float.MAX_VALUE;
    private boolean invalid;
    private boolean rotate;
    private static Bitmap empty;
    private static Bitmap dummy;
    private static final int FADE_DUR = 300;

    static {
        queueMap = new HashMap();
        empty = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        dummy = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ALPHA_8);
    }

    public BitmapAjaxCallback() {
        ((BitmapAjaxCallback)((BitmapAjaxCallback)((BitmapAjaxCallback)this.type(Bitmap.class)).memCache(true)).fileCache(true)).url("");
    }

    public BitmapAjaxCallback imageView(ImageView view) {
        this.v = new WeakReference<ImageView>(view);
        return this;
    }

    public BitmapAjaxCallback targetWidth(int targetWidth) {
        this.targetWidth = targetWidth;
        return this;
    }

    public BitmapAjaxCallback file(File imageFile) {
        this.imageFile = imageFile;
        return this;
    }

    public BitmapAjaxCallback preset(Bitmap preset) {
        this.preset = preset;
        return this;
    }

    public BitmapAjaxCallback bitmap(Bitmap bm) {
        this.bm = bm;
        return this;
    }

    public BitmapAjaxCallback fallback(int resId) {
        this.fallback = resId;
        return this;
    }

    public BitmapAjaxCallback animation(int animation) {
        this.animation = animation;
        return this;
    }

    public BitmapAjaxCallback ratio(float ratio) {
        this.ratio = ratio;
        return this;
    }

    public BitmapAjaxCallback rotate(boolean rotate) {
        this.rotate = rotate;
        return this;
    }

    public BitmapAjaxCallback anchor(float anchor) {
        this.anchor = anchor;
        return this;
    }

    public BitmapAjaxCallback round(int radius) {
        this.round = radius;
        return this;
    }

    private static Bitmap decode(String path, byte[] data, BitmapFactory.Options options, boolean rotate) {
        Bitmap result = null;
        if (path != null) {
            result = BitmapAjaxCallback.decodeFile(path, options, rotate);
        } else if (data != null) {
            result = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        }
        if (result == null && options != null && !options.inJustDecodeBounds) {
            AQUtility.debug("decode image failed", path);
        }
        return result;
    }

    private static Bitmap decodeFile(String path, BitmapFactory.Options options, boolean rotate) {
        Bitmap result;
        block7: {
            result = null;
            if (options == null) {
                options = new BitmapFactory.Options();
            }
            options.inInputShareable = true;
            options.inPurgeable = true;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(path);
                    FileDescriptor fd = fis.getFD();
                    result = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
                    if (result != null && rotate) {
                        result = BitmapAjaxCallback.rotate(path, result);
                    }
                }
                catch (IOException e) {
                    AQUtility.report(e);
                    AQUtility.close(fis);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                AQUtility.close(fis);
                throw throwable;
            }
            AQUtility.close(fis);
        }
        return result;
    }

    private static Bitmap rotate(String path, Bitmap bm) {
        if (bm == null) {
            return null;
        }
        Bitmap result = bm;
        int ori = 1;
        try {
            ExifInterface ei = new ExifInterface(path);
            ori = ei.getAttributeInt("Orientation", 1);
        }
        catch (Exception e) {
            AQUtility.debug(e);
        }
        if (ori > 0) {
            Matrix matrix = BitmapAjaxCallback.getRotateMatrix(ori);
            result = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
            AQUtility.debug("before", String.valueOf(bm.getWidth()) + ":" + bm.getHeight());
            AQUtility.debug("after", String.valueOf(result.getWidth()) + ":" + result.getHeight());
            if (bm != result) {
                bm.recycle();
            }
        }
        return result;
    }

    private static Matrix getRotateMatrix(int ori) {
        Matrix matrix = new Matrix();
        switch (ori) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
            }
        }
        return matrix;
    }

    public static Bitmap getResizedImage(String path, byte[] data, int target, boolean width, int round) {
        return BitmapAjaxCallback.getResizedImage(path, data, target, width, round, false);
    }

    public static Bitmap getResizedImage(String path, byte[] data, int target, boolean width, int round, boolean rotate) {
        if (path == null && data == null) {
            return null;
        }
        BitmapFactory.Options options = null;
        if (target > 0) {
            BitmapFactory.Options info = new BitmapFactory.Options();
            info.inJustDecodeBounds = true;
            BitmapAjaxCallback.decode(path, data, info, rotate);
            int dim = info.outWidth;
            if (!width) {
                dim = Math.max(dim, info.outHeight);
            }
            int ssize = BitmapAjaxCallback.sampleSize(dim, target);
            options = new BitmapFactory.Options();
            options.inSampleSize = ssize;
        }
        Bitmap bm = null;
        try {
            bm = BitmapAjaxCallback.decode(path, data, options, rotate);
        }
        catch (OutOfMemoryError e) {
            BitmapAjaxCallback.clearCache();
            AQUtility.report(e);
        }
        if (round > 0) {
            bm = BitmapAjaxCallback.getRoundedCornerBitmap(bm, round);
        }
        return bm;
    }

    private static int sampleSize(int width, int target) {
        int result = 1;
        int i = 0;
        while (i < 10) {
            if (width < target * 2) break;
            width /= 2;
            result *= 2;
            ++i;
        }
        return result;
    }

    private Bitmap bmGet(String path, byte[] data) {
        return BitmapAjaxCallback.getResizedImage(path, data, this.targetWidth, this.targetDim, this.round, this.rotate);
    }

    @Override
    protected File accessFile(File cacheDir, String url) {
        if (this.imageFile != null && this.imageFile.exists()) {
            return this.imageFile;
        }
        return super.accessFile(cacheDir, url);
    }

    @Override
    protected Bitmap fileGet(String url, File file, AjaxStatus status) {
        return this.bmGet(file.getAbsolutePath(), null);
    }

    @Override
    public Bitmap transform(String url, byte[] data, AjaxStatus status) {
        Bitmap bm;
        String path = null;
        File file = status.getFile();
        if (file != null) {
            path = file.getAbsolutePath();
        }
        if ((bm = this.bmGet(path, data)) == null) {
            if (this.fallback > 0) {
                bm = this.getFallback();
            } else if (this.fallback == -2 || this.fallback == -1) {
                bm = dummy;
            } else if (this.fallback == -3) {
                bm = this.preset;
            }
            if (status.getCode() != 200) {
                this.invalid = true;
            }
            if (status.getSource() == 1 && file != null) {
                AQUtility.debug("invalid bm from net");
                file.delete();
            }
        }
        return bm;
    }

    private Bitmap getFallback() {
        String key;
        Bitmap bm = null;
        View view = (View)this.v.get();
        if (view != null && (bm = this.memGet(key = Integer.toString(this.fallback))) == null && (bm = BitmapFactory.decodeResource((Resources)view.getResources(), (int)this.fallback)) != null) {
            this.memPut(key, bm);
        }
        return bm;
    }

    public static Bitmap getMemoryCached(Context context, int resId) {
        String key = Integer.toString(resId);
        Bitmap bm = BitmapAjaxCallback.memGet(key, 0, 0);
        if (bm == null && (bm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId)) != null) {
            BitmapAjaxCallback.memPut(key, 0, 0, bm, false);
        }
        return bm;
    }

    public static Bitmap getEmptyBitmap() {
        return empty;
    }

    @Override
    public final void callback(String url, Bitmap bm, AjaxStatus status) {
        ImageView firstView = (ImageView)this.v.get();
        WeakHashMap<ImageView, BitmapAjaxCallback> ivs = queueMap.remove(url);
        if (ivs == null || !ivs.containsKey(firstView)) {
            this.checkCb(this, url, firstView, bm, status);
        }
        if (ivs != null) {
            Set<ImageView> set = ivs.keySet();
            for (ImageView view : set) {
                BitmapAjaxCallback cb = ivs.get(view);
                cb.status = status;
                this.checkCb(cb, url, view, bm, status);
            }
        }
    }

    @Override
    protected void skip(String url, Bitmap bm, AjaxStatus status) {
        queueMap.remove(url);
    }

    private void checkCb(BitmapAjaxCallback cb, String url, ImageView v, Bitmap bm, AjaxStatus status) {
        if (v == null || cb == null) {
            return;
        }
        if (url.equals(v.getTag(1090453505))) {
            if (v instanceof ImageView) {
                cb.callback(url, v, bm, status);
            } else {
                cb.setBitmap(url, v, bm, false);
            }
        }
        cb.showProgress(false);
    }

    protected void callback(String url, ImageView iv, Bitmap bm, AjaxStatus status) {
        this.setBitmap(url, iv, bm, false);
    }

    public static void setIconCacheLimit(int limit) {
        SMALL_MAX = limit;
        BitmapAjaxCallback.clearCache();
    }

    public static void setCacheLimit(int limit) {
        BIG_MAX = limit;
        BitmapAjaxCallback.clearCache();
    }

    public static void setDelayWrite(boolean delay) {
        DELAY_WRITE = delay;
    }

    public static void setPixelLimit(int pixels) {
        BIG_PIXELS = pixels;
        BitmapAjaxCallback.clearCache();
    }

    public static void setSmallPixel(int pixels) {
        SMALL_PIXELS = pixels;
        BitmapAjaxCallback.clearCache();
    }

    public static void setMaxPixelLimit(int pixels) {
        BIG_TPIXELS = pixels;
        BitmapAjaxCallback.clearCache();
    }

    public static void clearCache() {
        bigCache = null;
        smallCache = null;
        invalidCache = null;
    }

    protected static void clearTasks() {
        queueMap.clear();
    }

    private static Map<String, Bitmap> getBCache() {
        if (bigCache == null) {
            bigCache = Collections.synchronizedMap(new BitmapCache(BIG_MAX, BIG_PIXELS, BIG_TPIXELS));
        }
        return bigCache;
    }

    private static Map<String, Bitmap> getSCache() {
        if (smallCache == null) {
            smallCache = Collections.synchronizedMap(new BitmapCache(SMALL_MAX, SMALL_PIXELS, 250000));
        }
        return smallCache;
    }

    private static Map<String, Bitmap> getICache() {
        if (invalidCache == null) {
            invalidCache = Collections.synchronizedMap(new BitmapCache(100, BIG_PIXELS, 250000));
        }
        return invalidCache;
    }

    @Override
    protected Bitmap memGet(String url) {
        if (this.bm != null) {
            return this.bm;
        }
        if (!this.memCache) {
            return null;
        }
        return BitmapAjaxCallback.memGet(url, this.targetWidth, this.round);
    }

    public static boolean isMemoryCached(String url) {
        return BitmapAjaxCallback.getBCache().containsKey(url) || BitmapAjaxCallback.getSCache().containsKey(url) || BitmapAjaxCallback.getICache().containsKey(url);
    }

    public static Bitmap getMemoryCached(String url, int targetWidth) {
        return BitmapAjaxCallback.memGet(url, targetWidth, 0);
    }

    private static Bitmap memGet(String url, int targetWidth, int round) {
        url = BitmapAjaxCallback.getKey(url, targetWidth, round);
        Map<String, Bitmap> cache = BitmapAjaxCallback.getBCache();
        Bitmap result = cache.get(url);
        if (result == null) {
            cache = BitmapAjaxCallback.getSCache();
            result = cache.get(url);
        }
        if (result == null && (result = (cache = BitmapAjaxCallback.getICache()).get(url)) != null && BitmapAjaxCallback.getLastStatus() == 200) {
            invalidCache = null;
            result = null;
        }
        return result;
    }

    private static String getKey(String url, int targetWidth, int round) {
        if (targetWidth > 0) {
            url = String.valueOf(url) + "#" + targetWidth;
        }
        if (round > 0) {
            url = String.valueOf(url) + "#" + round;
        }
        return url;
    }

    private static void memPut(String url, int targetWidth, int round, Bitmap bm, boolean invalid) {
        if (bm == null) {
            return;
        }
        int pixels = bm.getWidth() * bm.getHeight();
        Map<String, Bitmap> cache = null;
        cache = invalid ? BitmapAjaxCallback.getICache() : (pixels <= SMALL_PIXELS ? BitmapAjaxCallback.getSCache() : BitmapAjaxCallback.getBCache());
        if (targetWidth > 0 || round > 0) {
            String key = BitmapAjaxCallback.getKey(url, targetWidth, round);
            cache.put(key, bm);
            if (!cache.containsKey(url)) {
                cache.put(url, null);
            }
        } else {
            cache.put(url, bm);
        }
    }

    @Override
    protected void memPut(String url, Bitmap bm) {
        BitmapAjaxCallback.memPut(url, this.targetWidth, this.round, bm, this.invalid);
    }

    private static Bitmap filter(View iv, Bitmap bm, int fallback) {
        if (bm != null && bm.getWidth() == 1 && bm.getHeight() == 1 && bm != empty) {
            bm = null;
        }
        if (bm != null) {
            iv.setVisibility(0);
        } else if (fallback == -2) {
            iv.setVisibility(8);
        } else if (fallback == -1) {
            iv.setVisibility(4);
        }
        return bm;
    }

    private void presetBitmap(String url, ImageView v) {
        if (!url.equals(v.getTag(1090453505)) || this.preset != null) {
            v.setTag(1090453505, (Object)url);
            if (this.preset != null && !this.cacheAvailable(v.getContext())) {
                this.setBitmap(url, v, this.preset, true);
            } else {
                this.setBitmap(url, v, null, true);
            }
        }
    }

    private void setBitmap(String url, ImageView iv, Bitmap bm, boolean isPreset) {
        if (bm == null) {
            iv.setImageDrawable(null);
            return;
        }
        if (isPreset) {
            iv.setImageDrawable(BitmapAjaxCallback.makeDrawable(iv, bm, this.ratio, this.anchor));
            return;
        }
        if (this.status != null) {
            BitmapAjaxCallback.setBmAnimate(iv, bm, this.preset, this.fallback, this.animation, this.ratio, this.anchor, this.status.getSource());
        }
    }

    private static Drawable makeDrawable(ImageView iv, Bitmap bm, float ratio, float anchor) {
        BitmapDrawable bd = null;
        bd = ratio > 0.0f ? new RatioDrawable(iv.getResources(), bm, iv, ratio, anchor) : new BitmapDrawable(iv.getResources(), bm);
        return bd;
    }

    private static void setBmAnimate(ImageView iv, Bitmap bm, Bitmap preset, int fallback, int animation, float ratio, float anchor, int source) {
        if ((bm = BitmapAjaxCallback.filter((View)iv, bm, fallback)) == null) {
            iv.setImageBitmap(null);
            return;
        }
        Drawable d = BitmapAjaxCallback.makeDrawable(iv, bm, ratio, anchor);
        Animation anim = null;
        if (BitmapAjaxCallback.fadeIn(animation, source)) {
            if (preset == null) {
                anim = new AlphaAnimation(0.0f, 1.0f);
                anim.setInterpolator((Interpolator)new DecelerateInterpolator());
                anim.setDuration(300L);
            } else {
                Drawable pd = BitmapAjaxCallback.makeDrawable(iv, preset, ratio, anchor);
                Drawable[] ds = new Drawable[]{pd, d};
                TransitionDrawable td = new TransitionDrawable(ds);
                td.setCrossFadeEnabled(true);
                td.startTransition(300);
                d = td;
            }
        } else if (animation > 0) {
            anim = AnimationUtils.loadAnimation((Context)iv.getContext(), (int)animation);
        }
        iv.setImageDrawable(d);
        if (anim != null) {
            anim.setStartTime(AnimationUtils.currentAnimationTimeMillis());
            iv.startAnimation(anim);
        } else {
            iv.setAnimation(null);
        }
    }

    private static boolean fadeIn(int animation, int source) {
        switch (animation) {
            case -1: {
                return true;
            }
            case -3: {
                if (source == 3) {
                    return true;
                }
            }
            case -2: {
                if (source != 1) break;
                return true;
            }
        }
        return false;
    }

    public static void async(Activity act, Context context, ImageView iv, String url, Object progress, AccountHandle ah, ImageOptions options, HttpHost proxy, String networkUrl) {
        BitmapAjaxCallback.async(act, context, iv, url, options.memCache, options.fileCache, options.targetWidth, options.fallback, options.preset, options.animation, options.ratio, options.anchor, progress, ah, options.policy, options.round, proxy, networkUrl);
    }

    public static void async(Activity act, Context context, ImageView iv, String url, boolean memCache, boolean fileCache, int targetWidth, int fallbackId, Bitmap preset, int animation, float ratio, float anchor, Object progress, AccountHandle ah, int policy, int round, HttpHost proxy, String networkUrl) {
        Bitmap bm = null;
        if (memCache) {
            bm = BitmapAjaxCallback.memGet(url, targetWidth, round);
        }
        if (bm != null) {
            iv.setTag(1090453505, (Object)url);
            Common.showProgress(progress, url, false);
            BitmapAjaxCallback.setBmAnimate(iv, bm, preset, fallbackId, animation, ratio, anchor, 4);
        } else {
            BitmapAjaxCallback cb = new BitmapAjaxCallback();
            ((BitmapAjaxCallback)((BitmapAjaxCallback)((BitmapAjaxCallback)((BitmapAjaxCallback)((BitmapAjaxCallback)((BitmapAjaxCallback)cb.url(url)).imageView(iv).memCache(memCache)).fileCache(fileCache)).targetWidth(targetWidth).fallback(fallbackId).preset(preset).animation(animation).ratio(ratio).anchor(anchor).progress(progress)).auth(ah)).policy(policy)).round(round).networkUrl(networkUrl);
            if (proxy != null) {
                cb.proxy(proxy.getHostName(), proxy.getPort());
            }
            if (act != null) {
                cb.async(act);
            } else {
                cb.async(context);
            }
        }
    }

    @Override
    public void async(Context context) {
        String url = this.getUrl();
        ImageView v = (ImageView)this.v.get();
        if (url == null) {
            this.showProgress(false);
            this.setBitmap(url, v, null, false);
            return;
        }
        Bitmap bm = this.memGet(url);
        if (bm != null) {
            v.setTag(1090453505, (Object)url);
            this.status = new AjaxStatus().source(4).done();
            this.callback(url, bm, this.status);
            return;
        }
        this.presetBitmap(url, v);
        if (!queueMap.containsKey(url)) {
            this.addQueue(url, v);
            super.async(v.getContext());
        } else {
            this.showProgress(true);
            this.addQueue(url, v);
        }
    }

    @Override
    protected boolean isStreamingContent() {
        return !DELAY_WRITE;
    }

    private void addQueue(String url, ImageView iv) {
        WeakHashMap<Object, BitmapAjaxCallback> ivs = queueMap.get(url);
        if (ivs == null) {
            if (queueMap.containsKey(url)) {
                ivs = new WeakHashMap();
                ivs.put(iv, this);
                queueMap.put(url, ivs);
            } else {
                queueMap.put(url, null);
            }
        } else {
            ivs.put(iv, this);
        }
    }

    private static Bitmap getRoundedCornerBitmap(Bitmap bitmap, int pixels) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = pixels;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }
}

