/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.callback;

import com.androidquery.util.AQUtility;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public class AjaxStatus {
    public static final int NETWORK = 1;
    public static final int DATASTORE = 2;
    public static final int FILE = 3;
    public static final int MEMORY = 4;
    public static final int DEVICE = 5;
    public static final int NETWORK_ERROR = -101;
    public static final int AUTH_ERROR = -102;
    public static final int TRANSFORM_ERROR = -103;
    private int code = 200;
    private String message = "OK";
    private String redirect;
    private byte[] data;
    private File file;
    private Date time = new Date();
    private boolean refresh;
    private DefaultHttpClient client;
    private long duration;
    private int source = 1;
    private long start = System.currentTimeMillis();
    private boolean done;
    private boolean invalid;
    private boolean reauth;
    private String error;
    private HttpContext context;
    private Header[] headers;
    private Closeable close;

    public AjaxStatus() {
    }

    public AjaxStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    protected AjaxStatus source(int source) {
        this.source = source;
        return this;
    }

    public AjaxStatus code(int code) {
        this.code = code;
        return this;
    }

    protected AjaxStatus error(String error) {
        this.error = error;
        return this;
    }

    public AjaxStatus message(String message) {
        this.message = message;
        return this;
    }

    protected AjaxStatus redirect(String redirect) {
        this.redirect = redirect;
        return this;
    }

    protected AjaxStatus context(HttpContext context) {
        this.context = context;
        return this;
    }

    protected AjaxStatus time(Date time) {
        this.time = time;
        return this;
    }

    protected AjaxStatus refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    protected AjaxStatus reauth(boolean reauth) {
        this.reauth = reauth;
        return this;
    }

    protected AjaxStatus client(DefaultHttpClient client) {
        this.client = client;
        return this;
    }

    protected AjaxStatus headers(Header[] headers) {
        this.headers = headers;
        return this;
    }

    public AjaxStatus done() {
        this.duration = System.currentTimeMillis() - this.start;
        this.done = true;
        this.reauth = false;
        return this;
    }

    protected AjaxStatus reset() {
        this.duration = System.currentTimeMillis() - this.start;
        this.done = false;
        this.close();
        return this;
    }

    protected void closeLater(Closeable c) {
        this.close = c;
    }

    public void close() {
        AQUtility.close(this.close);
        this.close = null;
    }

    protected AjaxStatus data(byte[] data) {
        this.data = data;
        return this;
    }

    protected AjaxStatus file(File file) {
        this.file = file;
        return this;
    }

    public AjaxStatus invalidate() {
        this.invalid = true;
        return this;
    }

    protected boolean getDone() {
        return this.done;
    }

    protected boolean getReauth() {
        return this.reauth;
    }

    protected boolean getInvalid() {
        return this.invalid;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRedirect() {
        return this.redirect;
    }

    protected byte[] getData() {
        return this.data;
    }

    protected File getFile() {
        return this.file;
    }

    public Date getTime() {
        return this.time;
    }

    public boolean getRefresh() {
        return this.refresh;
    }

    public DefaultHttpClient getClient() {
        return this.client;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getSource() {
        return this.source;
    }

    public String getError() {
        return this.error;
    }

    public boolean expired(long expire) {
        long mod = this.time.getTime();
        long now = System.currentTimeMillis();
        long diff = now - mod;
        return diff > expire && this.getSource() != 1;
    }

    public List<Cookie> getCookies() {
        if (this.context == null) {
            return Collections.emptyList();
        }
        CookieStore store = (CookieStore)this.context.getAttribute("http.cookie-store");
        if (store == null) {
            return Collections.emptyList();
        }
        return store.getCookies();
    }

    public List<Header> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.headers);
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        int i = 0;
        while (i < this.headers.length) {
            if (name.equalsIgnoreCase(this.headers[i].getName())) {
                return this.headers[i].getValue();
            }
            ++i;
        }
        return null;
    }
}

