/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.facebooknative;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdError;
import com.facebook.ads.AdIconView;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeBannerAd;
import com.yumi.android.sdk.ads.adapter.facebooknative.R;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerBannerAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;
import java.util.ArrayList;

public class FacebooknativeBannerAdapter
extends YumiCustomerBannerAdapter {
    private static final String TAG = "FacebookNativeBannerAdapter";
    private LinearLayout adView;
    private NativeBannerAd nativeBannerAd;
    private NativeAdListener adListener;

    protected FacebooknativeBannerAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    protected void init() {
        ZplayDebug.d((String)TAG, (String)"facebook native banner init", (boolean)true);
        try {
            this.createBannerListener();
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"Init facebook native banner error", (boolean)false);
        }
    }

    private void createBannerListener() {
        this.adListener = new NativeAdListener(){

            public void onMediaDownloaded(Ad ad) {
                ZplayDebug.d((String)FacebooknativeBannerAdapter.TAG, (String)"facebook native banner onMediaDownloaded", (boolean)true);
            }

            public void onError(Ad ad, AdError adError) {
                ZplayDebug.d((String)FacebooknativeBannerAdapter.TAG, (String)("facebook native banner onError ErrorCode : " + adError.getErrorCode() + "   ErrorMessage : " + adError.getErrorMessage()), (boolean)true);
                FacebooknativeBannerAdapter.this.layerPreparedFailed(FacebooknativeBannerAdapter.this.decodeErrorCode(adError));
            }

            public void onAdLoaded(Ad ad) {
                ZplayDebug.d((String)FacebooknativeBannerAdapter.TAG, (String)"facebook native banner onAdLoaded", (boolean)true);
                if (FacebooknativeBannerAdapter.this.nativeBannerAd == null || FacebooknativeBannerAdapter.this.nativeBannerAd != ad) {
                    return;
                }
                FacebooknativeBannerAdapter.this.inflateAd(FacebooknativeBannerAdapter.this.nativeBannerAd);
            }

            public void onAdClicked(Ad ad) {
                ZplayDebug.d((String)FacebooknativeBannerAdapter.TAG, (String)"facebook native banner clicked", (boolean)true);
                FacebooknativeBannerAdapter.this.layerClicked(-99.0f, -99.0f);
            }

            public void onLoggingImpression(Ad ad) {
                ZplayDebug.d((String)FacebooknativeBannerAdapter.TAG, (String)"facebook native banner onLoggingImpression", (boolean)true);
            }
        };
    }

    private LayerErrorCode decodeErrorCode(AdError arg1) {
        if (arg1.equals(AdError.NETWORK_ERROR)) {
            return LayerErrorCode.ERROR_NETWORK_ERROR;
        }
        if (arg1.equals(AdError.NO_FILL)) {
            return LayerErrorCode.ERROR_NO_FILL;
        }
        return LayerErrorCode.ERROR_INTERNAL;
    }

    private void inflateAd(NativeBannerAd nativeBannerAd) {
        nativeBannerAd.unregisterView();
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        this.adView = (LinearLayout)inflater.inflate(R.layout.ad_banner_layout, null);
        RelativeLayout adChoicesContainer = (RelativeLayout)this.adView.findViewById(R.id.ad_choices_container);
        AdChoicesView adChoicesView = new AdChoicesView((Context)this.getActivity(), (NativeAdBase)nativeBannerAd, true);
        adChoicesContainer.addView((View)adChoicesView, 0);
        TextView nativeAdTitle = (TextView)this.adView.findViewById(R.id.native_ad_title);
        TextView nativeAdSocialContext = (TextView)this.adView.findViewById(R.id.native_ad_social_context);
        TextView sponsoredLabel = (TextView)this.adView.findViewById(R.id.native_ad_sponsored_label);
        AdIconView nativeAdIconView = (AdIconView)this.adView.findViewById(R.id.native_icon_view);
        Button nativeAdCallToAction = (Button)this.adView.findViewById(R.id.native_ad_call_to_action);
        nativeAdCallToAction.setText((CharSequence)nativeBannerAd.getAdCallToAction());
        nativeAdCallToAction.setVisibility(nativeBannerAd.hasCallToAction() ? 0 : 4);
        nativeAdTitle.setText((CharSequence)nativeBannerAd.getAdvertiserName());
        nativeAdSocialContext.setText((CharSequence)nativeBannerAd.getAdSocialContext());
        sponsoredLabel.setText((CharSequence)nativeBannerAd.getSponsoredTranslation());
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdTitle);
        clickableViews.add(nativeAdCallToAction);
        nativeBannerAd.registerViewForInteraction((View)this.adView, nativeAdIconView, clickableViews);
        this.layerPrepared((View)this.adView, true);
    }

    protected void callOnActivityDestroy() {
        if (this.nativeBannerAd != null) {
            this.nativeBannerAd.destroy();
        }
    }

    protected void onPrepareBannerLayer() {
        try {
            this.nativeBannerAd = new NativeBannerAd((Context)this.getActivity(), this.getProvider().getKey1());
            this.nativeBannerAd.loadAd();
            this.nativeBannerAd.setAdListener(this.adListener);
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"facebook native banner onPrepareBannerLayer error : ", (Throwable)e, (boolean)true);
        }
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }
}

