/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.facebook;

import android.app.Activity;
import android.content.Context;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerInterstitialAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class FacebookInterstitialAdapter
extends YumiCustomerInterstitialAdapter {
    private static final String TAG = "FacebookInstertititalAdapter";
    private InterstitialAd interstitial;
    private InterstitialAdListener interstitialListener;

    protected FacebookInterstitialAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    protected final void callOnActivityDestroy() {
        if (this.interstitial != null) {
            this.interstitial.destroy();
        }
    }

    public boolean onActivityBackPressed() {
        return false;
    }

    protected void onPrepareInterstitial() {
        ZplayDebug.d((String)TAG, (String)"facebook request new interstitial", (boolean)true);
        if (this.interstitial == null) {
            this.interstitial = new InterstitialAd((Context)this.getActivity(), this.getProvider().getKey1());
            this.interstitial.setAdListener(this.interstitialListener);
        }
        this.interstitial.loadAd();
    }

    protected void onShowInterstitialLayer(Activity activity) {
        this.interstitial.show();
    }

    protected boolean isInterstitialLayerReady() {
        return this.interstitial != null && this.interstitial.isAdLoaded();
    }

    protected void init() {
        ZplayDebug.i((String)TAG, (String)("placementID : " + this.getProvider().getKey1()), (boolean)true);
        this.createListener();
    }

    private void createListener() {
        if (this.interstitialListener == null) {
            this.interstitialListener = new InterstitialAdListener(){

                public void onError(Ad arg0, AdError arg1) {
                    ZplayDebug.d((String)FacebookInterstitialAdapter.TAG, (String)("facebook interstitial failed " + arg1.getErrorMessage()), (boolean)true);
                    FacebookInterstitialAdapter.this.layerPreparedFailed(FacebookInterstitialAdapter.this.decodeErrorCode(arg1));
                }

                public void onAdLoaded(Ad arg0) {
                    ZplayDebug.d((String)FacebookInterstitialAdapter.TAG, (String)"facebook interstitial prepared", (boolean)true);
                    FacebookInterstitialAdapter.this.layerPrepared();
                }

                public void onAdClicked(Ad arg0) {
                    ZplayDebug.d((String)FacebookInterstitialAdapter.TAG, (String)"facebook interstitial clicked", (boolean)true);
                    FacebookInterstitialAdapter.this.layerClicked(-99.0f, -99.0f);
                }

                public void onLoggingImpression(Ad ad) {
                }

                public void onInterstitialDisplayed(Ad arg0) {
                    ZplayDebug.d((String)FacebookInterstitialAdapter.TAG, (String)"facebook interstitial shown", (boolean)true);
                    FacebookInterstitialAdapter.this.layerExposure();
                }

                public void onInterstitialDismissed(Ad arg0) {
                    ZplayDebug.d((String)FacebookInterstitialAdapter.TAG, (String)"facebook interstitial closed", (boolean)true);
                    FacebookInterstitialAdapter.this.layerClosed();
                }
            };
        }
    }

    protected LayerErrorCode decodeErrorCode(AdError arg1) {
        if (arg1.equals(AdError.NETWORK_ERROR)) {
            return LayerErrorCode.ERROR_NETWORK_ERROR;
        }
        if (arg1.equals(AdError.NO_FILL)) {
            return LayerErrorCode.ERROR_NO_FILL;
        }
        return LayerErrorCode.ERROR_INTERNAL;
    }
}

