/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.facebooknative;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.NativeAd;
import com.yumi.android.sdk.ads.adapter.facebooknative.R;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerBannerAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class FacebooknativeBannerAdapter
extends YumiCustomerBannerAdapter {
    private static final String TAG = "FacebooknativeBannerAdapter";
    private ImageView iconView;
    private TextView titleView;
    private TextView descView;
    private AdListener linstener;
    private NativeAd nativeAd;
    private RelativeLayout nativeAdContainer;
    private AdChoicesView adChoicesView;
    private View bannerView;

    protected FacebooknativeBannerAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
        Log.e((String)"sss", (String)"FacebooknativeBannerAdapter in");
    }

    protected void init() {
        Log.e((String)"sss", (String)"FacebooknativeBannerAdapter init");
        try {
            this.bannerView = this.getActivity().getLayoutInflater().inflate(R.layout.ad_banner_layout, null, false);
            this.nativeAdContainer = (RelativeLayout)this.bannerView.findViewById(R.id.ll_header);
            this.iconView = (ImageView)this.bannerView.findViewById(R.id.native_ad_icon);
            this.titleView = (TextView)this.bannerView.findViewById(R.id.native_ad_title);
            this.descView = (TextView)this.bannerView.findViewById(R.id.sponsored_label);
            this.createBannerListener();
        }
        catch (Exception e) {
            e.printStackTrace();
            ZplayDebug.e((String)TAG, (String)"Init FacebooknativeBanner Faild", (boolean)false);
        }
    }

    private void createBannerListener() {
        Log.e((String)"sss", (String)"init5");
        this.linstener = new AdListener(){

            public void onError(Ad ad, AdError adError) {
                FacebooknativeBannerAdapter.this.layerPreparedFailed(FacebooknativeBannerAdapter.this.decodeErrorCode(adError));
            }

            public void onAdLoaded(Ad ad) {
                Log.e((String)"sss", (String)"init6");
                if (FacebooknativeBannerAdapter.this.nativeAd == null || FacebooknativeBannerAdapter.this.nativeAd != ad) {
                    return;
                }
                FacebooknativeBannerAdapter.this.inflateAd(FacebooknativeBannerAdapter.this.nativeAd, FacebooknativeBannerAdapter.this.nativeAdContainer);
                FacebooknativeBannerAdapter.this.layerPrepared((View)FacebooknativeBannerAdapter.this.nativeAdContainer, true);
            }

            public void onAdClicked(Ad ad) {
                ZplayDebug.d((String)FacebooknativeBannerAdapter.TAG, (String)"facebook banner clicked", (boolean)true);
                FacebooknativeBannerAdapter.this.layerClicked(-99.0f, -99.0f);
            }

            public void onLoggingImpression(Ad ad) {
            }
        };
    }

    private LayerErrorCode decodeErrorCode(AdError arg1) {
        if (arg1.equals(AdError.NETWORK_ERROR)) {
            return LayerErrorCode.ERROR_NETWORK_ERROR;
        }
        if (arg1.equals(AdError.NO_FILL)) {
            return LayerErrorCode.ERROR_NO_FILL;
        }
        return LayerErrorCode.ERROR_INTERNAL;
    }

    private void inflateAd(NativeAd nativeAd, RelativeLayout nativeAdContainer) {
        this.titleView.setText((CharSequence)nativeAd.getAdTitle());
        this.descView.setText((CharSequence)nativeAd.getAdSubtitle());
        NativeAd.Image adIcon = nativeAd.getAdIcon();
        NativeAd.downloadAndDisplayImage((NativeAd.Image)adIcon, (ImageView)this.iconView);
        if (this.adChoicesView == null) {
            RelativeLayout adChoicesContainer = (RelativeLayout)this.bannerView.findViewById(R.id.ad_choices_container);
            this.adChoicesView = new AdChoicesView(this.getContext(), nativeAd, true);
            adChoicesContainer.addView((View)this.adChoicesView);
        }
        nativeAd.registerViewForInteraction((View)nativeAdContainer);
        this.sendChangeViewBeforePrepared((View)nativeAdContainer);
    }

    protected void callOnActivityDestroy() {
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
        }
    }

    protected void onPrepareBannerLayer() {
        this.nativeAd = new NativeAd(this.getContext(), this.getProvider().getKey1());
        this.nativeAd.setAdListener(this.linstener);
        this.nativeAd.loadAd();
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }
}

