/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.facebook;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.facebook.ads.S2SRewardedVideoAdListener;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerMediaAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class FacebookMediaAdapter
extends YumiCustomerMediaAdapter {
    private static final String TAG = "FacebookMediaAdapter";
    private RewardedVideoAd rewardedVideoAd;
    private S2SRewardedVideoAdListener listener;
    private static final int REQUEST_NEXT_MEDIA = 1;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (FacebookMediaAdapter.this.rewardedVideoAd == null || FacebookMediaAdapter.this.listener == null) break;
                    ZplayDebug.d((String)FacebookMediaAdapter.TAG, (String)"Facebook media Video REQUEST_NEXT_MEDIA ", (boolean)true);
                    FacebookMediaAdapter.this.rewardedVideoAd.loadAd(false);
                    break;
                }
            }
        }
    };

    protected FacebookMediaAdapter(Activity activity, YumiProviderBean yumiProviderBean) {
        super(activity, yumiProviderBean);
    }

    protected void onPrepareMedia() {
        try {
            ZplayDebug.i((String)TAG, (String)"facebook media onPrepareMedia", (boolean)true);
            if (this.rewardedVideoAd == null) {
                this.rewardedVideoAd = new RewardedVideoAd((Context)this.getActivity(), this.getProvider().getKey1());
                this.rewardedVideoAd.setAdListener((RewardedVideoAdListener)this.listener);
                if (this.listener == null) {
                    this.createListener();
                }
            }
            this.rewardedVideoAd.loadAd(false);
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"facebook media onPrepareMedia error", (Throwable)e, (boolean)true);
        }
    }

    protected void onShowMedia() {
        try {
            boolean isShow = this.rewardedVideoAd.show();
            ZplayDebug.i((String)TAG, (String)("facebook media onShowMedia " + isShow), (boolean)true);
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"facebook media onShowMedia error ", (Throwable)e, (boolean)true);
        }
    }

    protected boolean isMediaReady() {
        if (this.rewardedVideoAd != null) {
            if (this.rewardedVideoAd.isAdLoaded()) {
                ZplayDebug.i((String)TAG, (String)"facebook media isMediaReady isAdLoaded true", (boolean)true);
                return true;
            }
            ZplayDebug.i((String)TAG, (String)"facebook media isMediaReady isAdLoaded false", (boolean)true);
        }
        ZplayDebug.i((String)TAG, (String)"facebook media isMediaReady false", (boolean)true);
        return false;
    }

    protected void init() {
        ZplayDebug.d((String)TAG, (String)"facebook media init", (boolean)true);
        this.createListener();
    }

    private void createListener() {
        this.listener = new S2SRewardedVideoAdListener(){

            public void onRewardServerFailed() {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)"facebook media onRewardServerFailed", (boolean)true);
            }

            public void onRewardServerSuccess() {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)"facebook media onRewardServerSuccess", (boolean)true);
            }

            public void onRewardedVideoCompleted() {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)"facebook media onRewardedVideoCompleted", (boolean)true);
                FacebookMediaAdapter.this.layerIncentived();
                FacebookMediaAdapter.this.layerMediaEnd();
            }

            public void onLoggingImpression(Ad ad) {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)"facebook media onLoggingImpression", (boolean)true);
                FacebookMediaAdapter.this.layerExposure();
                FacebookMediaAdapter.this.layerMediaStart();
            }

            public void onRewardedVideoClosed() {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)"facebook media onRewardedVideoClosed", (boolean)true);
                FacebookMediaAdapter.this.layerClosed();
                FacebookMediaAdapter.this.requestAD(5);
            }

            public void onError(Ad ad, AdError adError) {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)("facebook media onError ErrorCode : " + adError.getErrorCode() + "  || ErrorMessage : " + adError.getErrorMessage()), (boolean)true);
                if (adError.getErrorCode() == 1001) {
                    FacebookMediaAdapter.this.layerPreparedFailed(LayerErrorCode.ERROR_NO_FILL);
                } else {
                    FacebookMediaAdapter.this.layerPreparedFailed(LayerErrorCode.ERROR_INTERNAL);
                }
                FacebookMediaAdapter.this.requestAD(30);
            }

            public void onAdLoaded(Ad ad) {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)("facebook media onAdLoaded PlacementId:" + ad.getPlacementId()), (boolean)true);
                FacebookMediaAdapter.this.layerPrepared();
            }

            public void onAdClicked(Ad ad) {
                ZplayDebug.i((String)FacebookMediaAdapter.TAG, (String)"facebook media onAdClicked", (boolean)true);
                FacebookMediaAdapter.this.layerClicked();
            }
        };
    }

    private void requestAD(int delaySecond) {
        try {
            ZplayDebug.d((String)TAG, (String)("facebook media Video requestAD delaySecond" + delaySecond), (boolean)true);
            this.mHandler.sendEmptyMessageDelayed(1, (long)(delaySecond * 1000));
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"facebook media requestAD error ", (Throwable)e, (boolean)true);
        }
    }

    protected void callOnActivityDestroy() {
        try {
            if (this.rewardedVideoAd != null) {
                this.rewardedVideoAd.destroy();
                this.rewardedVideoAd = null;
            }
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"facebook media callOnActivityDestroy error ", (Throwable)e, (boolean)true);
        }
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }
}

