/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.facebook;

import android.app.Activity;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerBannerAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class FacebookBannerAdapter
extends YumiCustomerBannerAdapter {
    private static final String TAG = "FacebookBannerAdapter";
    private AdView banner;
    private AdListener bannerListener;

    protected FacebookBannerAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    protected final void callOnActivityDestroy() {
        if (this.banner != null) {
            this.banner.destroy();
        }
    }

    protected void onPrepareBannerLayer() {
        ZplayDebug.d((String)TAG, (String)"facebook request new banner", (boolean)true);
        this.banner = new AdView(this.getContext(), this.getProvider().getKey1(), this.calculateBannerSize());
        this.banner.setAdListener(this.bannerListener);
        this.banner.loadAd();
    }

    protected void init() {
        ZplayDebug.i((String)TAG, (String)("placementID : " + this.getProvider().getKey1()), (boolean)true);
        this.createBannerListener();
    }

    private void createBannerListener() {
        if (this.bannerListener == null) {
            this.bannerListener = new AdListener(){

                public void onError(Ad arg0, AdError arg1) {
                    ZplayDebug.d((String)FacebookBannerAdapter.TAG, (String)("facebook banner failed " + arg1.getErrorMessage()), (boolean)true);
                    FacebookBannerAdapter.this.layerPreparedFailed(FacebookBannerAdapter.this.decodeErrorCode(arg1));
                }

                public void onAdLoaded(Ad arg0) {
                    ZplayDebug.d((String)FacebookBannerAdapter.TAG, (String)"facebook banner prepared", (boolean)true);
                    FacebookBannerAdapter.this.layerPrepared((View)FacebookBannerAdapter.this.banner, true);
                }

                public void onAdClicked(Ad arg0) {
                    ZplayDebug.d((String)FacebookBannerAdapter.TAG, (String)"facebook banner clicked", (boolean)true);
                    FacebookBannerAdapter.this.layerClicked(-99.0f, -99.0f);
                }

                public void onLoggingImpression(Ad ad) {
                }
            };
        }
    }

    protected LayerErrorCode decodeErrorCode(AdError arg1) {
        if (arg1.equals(AdError.NETWORK_ERROR)) {
            return LayerErrorCode.ERROR_NETWORK_ERROR;
        }
        if (arg1.equals(AdError.NO_FILL)) {
            return LayerErrorCode.ERROR_NO_FILL;
        }
        return LayerErrorCode.ERROR_INTERNAL;
    }

    private AdSize calculateBannerSize() {
        if (this.bannerSize == com.yumi.android.sdk.ads.publish.enumbean.AdSize.BANNER_SIZE_320X50) {
            if (this.isMatchWindowWidth) {
                return AdSize.BANNER_HEIGHT_50;
            }
            return AdSize.BANNER_320_50;
        }
        if (this.bannerSize == com.yumi.android.sdk.ads.publish.enumbean.AdSize.BANNER_SIZE_728X90) {
            return AdSize.BANNER_HEIGHT_90;
        }
        return AdSize.BANNER_320_50;
    }
}

