/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdCallback;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yumi.android.sdk.ads.adapter.admob.AdMobUtil;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerMediaAdapter;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobMediaAdapter
extends YumiCustomerMediaAdapter {
    private static final String TAG = "AdmobMediaAdapter";
    private RewardedAd mAd;
    private boolean isReady;
    private boolean isRewarded = false;

    protected AdmobMediaAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    protected void onPrepareMedia() {
        ZplayDebug.d((String)TAG, (String)"load new media");
        this.isReady = false;
        this.mAd = new RewardedAd(this.getContext(), this.getProvider().getKey1());
        this.mAd.loadAd(AdMobUtil.getAdRequest(this.getContext()), new RewardedAdLoadCallback(){

            public void onRewardedAdLoaded() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"onRewardedAdLoaded");
                AdmobMediaAdapter.this.isReady = true;
                AdmobMediaAdapter.this.layerPrepared();
            }

            public void onRewardedAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)("onRewardedAdFailedToLoad errorCode: " + errorCode));
                AdmobMediaAdapter.this.isReady = false;
                AdmobMediaAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(errorCode));
            }
        });
    }

    protected void onShowMedia() {
        if (this.mAd != null && this.isMediaReady()) {
            this.mAd.show(this.getActivity(), new RewardedAdCallback(){

                public void onRewardedAdOpened() {
                    ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"onRewardedAdOpened");
                    AdmobMediaAdapter.this.isRewarded = false;
                    AdmobMediaAdapter.this.isReady = false;
                    AdmobMediaAdapter.this.layerExposure();
                    AdmobMediaAdapter.this.layerStartPlaying();
                }

                public void onRewardedAdClosed() {
                    ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"onRewardedAdClosed");
                    AdmobMediaAdapter.this.isReady = false;
                    AdmobMediaAdapter.this.layerClosed(AdmobMediaAdapter.this.isRewarded);
                }

                public void onUserEarnedReward(RewardItem reward) {
                    ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"onUserEarnedReward");
                    AdmobMediaAdapter.this.isReady = false;
                    AdmobMediaAdapter.this.isRewarded = true;
                    AdmobMediaAdapter.this.layerIncentived();
                }

                public void onRewardedAdFailedToShow(int errorCode) {
                    AdmobMediaAdapter.this.layerExposureFailed(AdMobUtil.recodeError(errorCode));
                }
            });
        }
    }

    protected boolean isMediaReady() {
        try {
            if (this.mAd != null && this.mAd.isLoaded()) {
                ZplayDebug.d((String)TAG, (String)"isMediaReady true");
                return true;
            }
            ZplayDebug.d((String)TAG, (String)"isMediaReady false");
            return false;
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"isMediaReady error : ", (Throwable)e);
            return this.isReady;
        }
    }

    protected void init() {
    }

    public String getProviderVersion() {
        return AdMobUtil.sdkVersion();
    }
}

