/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.yumi.android.sdk.ads.adapter.admob.AdMobUtil;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerInterstitialAdapter;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobInterstitialAdapter
extends YumiCustomerInterstitialAdapter {
    private static final String TAG = "AdmobInterstitialAdapter";
    private InterstitialAd mInterstitialAd;
    private AdListener mAdListener;
    private boolean isReady;

    protected AdmobInterstitialAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    public boolean onActivityBackPressed() {
        return false;
    }

    protected void onPrepareInterstitial() {
        ZplayDebug.d((String)TAG, (String)"admob request new interstitial", (boolean)true);
        if (this.mInterstitialAd == null) {
            this.mInterstitialAd = new InterstitialAd((Context)this.getActivity());
            this.mInterstitialAd.setAdUnitId(this.getProvider().getKey1());
            this.mInterstitialAd.setAdListener(this.mAdListener);
        }
        AdRequest req = AdMobUtil.getAdRequest(this.getContext());
        this.isReady = false;
        this.mInterstitialAd.loadAd(req);
    }

    protected void onShowInterstitialLayer(Activity activity) {
        this.mInterstitialAd.show();
    }

    protected boolean isInterstitialLayerReady() {
        try {
            return this.mInterstitialAd != null && this.mInterstitialAd.isLoaded();
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"admob interstitial isInterstitialLayerReady error : ", (Throwable)e, (boolean)true);
            return this.isReady;
        }
    }

    protected void init() {
        ZplayDebug.i((String)TAG, (String)("unitId : " + this.getProvider().getKey1()), (boolean)true);
        this.createAdListener();
    }

    private void createAdListener() {
        this.mAdListener = new AdListener(){

            public void onAdClosed() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial closed", (boolean)true);
                AdmobInterstitialAdapter.this.layerClosed();
                AdmobInterstitialAdapter.this.isReady = false;
                super.onAdClosed();
            }

            public void onAdOpened() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial shown", (boolean)true);
                AdmobInterstitialAdapter.this.layerExposure();
                AdmobInterstitialAdapter.this.layerStartPlaying();
                AdmobInterstitialAdapter.this.isReady = false;
                super.onAdOpened();
            }

            public void onAdLeftApplication() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial clicked", (boolean)true);
                AdmobInterstitialAdapter.this.layerClicked(-99.0f, -99.0f);
                AdmobInterstitialAdapter.this.isReady = false;
                super.onAdLeftApplication();
            }

            public void onAdLoaded() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial prepared", (boolean)true);
                AdmobInterstitialAdapter.this.layerPrepared();
                AdmobInterstitialAdapter.this.isReady = true;
                super.onAdLoaded();
            }

            public void onAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)("admob interstitial failed " + errorCode), (boolean)true);
                AdmobInterstitialAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(errorCode));
                AdmobInterstitialAdapter.this.isReady = false;
                super.onAdFailedToLoad(errorCode);
            }
        };
    }

    public String getProviderVersion() {
        return AdMobUtil.sdkVersion();
    }
}

