/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.yumi.android.sdk.ads.adapter.admob.AdMobUtil;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerBannerAdapter;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobBannerAdapter
extends YumiCustomerBannerAdapter {
    private static final String TAG = "AdmobBannerAdapter";
    private AdView adView;
    private AdListener adListener;
    private float cx = -99.0f;
    private float cy = -99.0f;
    private boolean isSupportGoogleService;
    private AdSize mAdSize;

    protected AdmobBannerAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
        GoogleApiAvailabilityLight googleApiAvailability = GoogleApiAvailabilityLight.getInstance();
        int resultCode = googleApiAvailability.isGooglePlayServicesAvailable(this.getContext());
        this.isSupportGoogleService = resultCode == 0;
    }

    public void onActivityPause() {
        if (this.adView != null) {
            this.adView.pause();
        }
    }

    public void onActivityResume() {
        if (this.adView != null) {
            this.adView.resume();
        }
    }

    protected final void onDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
        }
    }

    protected void onPrepareBannerLayer() {
        ZplayDebug.d((String)TAG, (String)"admob request new banner", (boolean)true);
        this.mAdSize = this.calculateBannerSize();
        this.adView = new AdView((Context)this.getActivity());
        this.adView.setAdSize(this.mAdSize);
        this.adView.setAdUnitId(this.getProvider().getKey1());
        this.adView.setAdListener(this.adListener);
        this.adView.loadAd(AdMobUtil.getAdRequest(this.getContext()));
    }

    protected void init() {
        ZplayDebug.i((String)TAG, (String)("unitId : " + this.getProvider().getKey1()), (boolean)true);
        this.createAdListener();
    }

    private void createAdListener() {
        this.adListener = new AdListener(){

            public void onAdClosed() {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)"admob banner closed", (boolean)true);
                AdmobBannerAdapter.this.layerClosed();
                super.onAdClosed();
            }

            public void onAdOpened() {
                super.onAdOpened();
            }

            public void onAdLeftApplication() {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)"admob banner clicked", (boolean)true);
                AdmobBannerAdapter.this.layerClicked(AdmobBannerAdapter.this.cx, AdmobBannerAdapter.this.cy);
                super.onAdLeftApplication();
            }

            public void onAdLoaded() {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)"admob banner preapred", (boolean)true);
                AdmobBannerAdapter.this.layerPrepared((View)AdmobBannerAdapter.this.adView, true);
                super.onAdLoaded();
            }

            public void onAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)("admob banner failed " + errorCode), (boolean)true);
                AdmobBannerAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(errorCode));
                super.onAdFailedToLoad(errorCode);
            }
        };
    }

    private AdSize calculateBannerSize() {
        switch (this.bannerSize) {
            case BANNER_SIZE_SMART: {
                if (!this.isSupportGoogleService) {
                    return AdSize.BANNER;
                }
                return AdSize.SMART_BANNER;
            }
            case BANNER_SIZE_728X90: {
                return AdSize.LEADERBOARD;
            }
        }
        return AdSize.BANNER;
    }

    private int getHeightDp() {
        int px = Resources.getSystem().getDisplayMetrics().heightPixels;
        float density = Resources.getSystem().getDisplayMetrics().density;
        return (int)((double)((float)px / density) + 0.5);
    }

    public String getProviderVersion() {
        return AdMobUtil.sdkVersion();
    }
}

