/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.content.Context;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.yumi.android.sdk.ads.publish.AdError;
import com.yumi.android.sdk.ads.publish.YumiSettings;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.publish.enumbean.YumiGDPRStatus;

public class AdMobUtil {
    public static AdError recodeError(int errorCode) {
        LayerErrorCode errCode;
        switch (errorCode) {
            case 0: {
                errCode = LayerErrorCode.ERROR_INTERNAL;
                break;
            }
            case 1: {
                errCode = LayerErrorCode.ERROR_INVALID;
                break;
            }
            case 3: {
                errCode = LayerErrorCode.ERROR_NO_FILL;
                break;
            }
            case 2: {
                errCode = LayerErrorCode.ERROR_NETWORK_ERROR;
                break;
            }
            default: {
                errCode = LayerErrorCode.ERROR_INTERNAL;
            }
        }
        AdError adError = new AdError(errCode);
        adError.setErrorMessage("AdMob errorCode: " + errorCode);
        return adError;
    }

    public static AdRequest getAdRequest(Context context) {
        if (YumiSettings.getGDPRStatus() != YumiGDPRStatus.NON_PERSONALIZED) {
            return new AdRequest.Builder().build();
        }
        Bundle extras = new Bundle();
        extras.putString("npa", "1");
        return new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, extras).build();
    }

    public static String sdkVersion() {
        return "17.2.0";
    }
}

