/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.yumi.android.sdk.ads.adapter.admob.AdMobUtil;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.formats.YumiNativeAdVideoController;
import com.yumi.android.sdk.ads.formats.YumiNativeAdView;
import com.yumi.android.sdk.ads.formats.YumiNativeMappedImage;
import com.yumi.android.sdk.ads.publish.NativeContent;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerNativeAdapter;
import com.yumi.android.sdk.ads.utils.ZplayDebug;
import java.util.ArrayList;
import java.util.List;

public class AdmobNativeAdapter
extends YumiCustomerNativeAdapter {
    private AdLoader adLoader;
    private List<NativeContent> list;
    private int adCount;

    protected AdmobNativeAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void webLayerClickedAndRequestBrowser(String url) {
    }

    protected void onPrepareNative() {
        if (this.adLoader != null) {
            int currentPoolSpace = this.getCurrentPoolSpace();
            this.adCount = currentPoolSpace >= 5 ? 5 : currentPoolSpace;
            ZplayDebug.v((String)this.TAG, (String)("admob native onPrepareNative adCount: " + this.adCount), (boolean)true);
            if (this.adCount <= 0) {
                this.adCount = 1;
            }
            this.adLoader.loadAds(AdMobUtil.getAdRequest(this.getContext()), this.adCount);
        }
    }

    protected void init() {
        this.list = new ArrayList<NativeContent>();
        ZplayDebug.v((String)this.TAG, (String)("admob native init getProvider().getKey1() : " + this.getProvider().getKey1()), (boolean)true);
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).setAdChoicesPlacement(this.getProvider().getNativeAdOptions().getAdChoicesPosition()).setReturnUrlsForImageAssets(!this.getProvider().getNativeAdOptions().getIsDownloadImage()).build();
        AdLoader.Builder builder = new AdLoader.Builder((Context)this.getActivity(), this.getProvider().getKey1());
        this.adLoader = builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)("admob native onUnifiedNativeAdLoaded isLoading" + AdmobNativeAdapter.this.adLoader.isLoading()), (boolean)true);
                try {
                    AdmobNativeAdapter.this.adCount--;
                    NativeAdContent nativeAdContent = new NativeAdContent(unifiedNativeAd);
                    AdmobNativeAdapter.this.list.add(nativeAdContent);
                    if (AdmobNativeAdapter.this.adCount != 0) {
                        return;
                    }
                    if (AdmobNativeAdapter.this.list.size() > 0) {
                        ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)"admob native Adapter onSuccess", (boolean)true);
                        AdmobNativeAdapter.this.layerPrepared(AdmobNativeAdapter.this.list);
                    } else {
                        ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)"admob native Adapter onFailed", (boolean)true);
                        AdmobNativeAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(3));
                    }
                }
                catch (Exception e) {
                    ZplayDebug.e((String)AdmobNativeAdapter.this.TAG, (String)("admob getNativeContentList error : " + e), (boolean)true);
                }
            }
        }).withAdListener(new AdListener(){

            public void onAdClicked() {
                ZplayDebug.d((String)AdmobNativeAdapter.this.TAG, (String)"admob native onClick", (boolean)true);
                super.onAdClicked();
                AdmobNativeAdapter.this.layerClicked(-99.0f, -99.0f);
            }

            public void onAdImpression() {
                super.onAdImpression();
                AdmobNativeAdapter.this.layerExposure();
            }

            public void onAdFailedToLoad(int errorCode) {
                super.onAdFailedToLoad(errorCode);
                AdmobNativeAdapter.this.adCount--;
                ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)("admob native Adapter onAdFailedToLoad isLoading()" + AdmobNativeAdapter.this.adLoader.isLoading() + ", errorCode=" + errorCode), (boolean)true);
                AdmobNativeAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(errorCode));
            }
        }).withNativeAdOptions(adOptions).build();
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    public boolean onActivityBackPressed() {
        return false;
    }

    class NativeAdContent
    extends NativeContent {
        private UnifiedNativeAd unifiedNativeAd;

        NativeAdContent(UnifiedNativeAd unifiedNativeAd) {
            this.unifiedNativeAd = unifiedNativeAd;
            if (unifiedNativeAd.getIcon() != null) {
                this.setIcon((NativeContent.Image)new YumiNativeMappedImage(unifiedNativeAd.getIcon().getDrawable(), unifiedNativeAd.getIcon().getUri().toString(), unifiedNativeAd.getIcon().getScale()));
            } else {
                this.setIcon(null);
            }
            if (unifiedNativeAd.getImages().size() > 0) {
                this.setCoverImage((NativeContent.Image)new YumiNativeMappedImage(((NativeAd.Image)unifiedNativeAd.getImages().get(0)).getDrawable(), ((NativeAd.Image)unifiedNativeAd.getImages().get(0)).getUri().toString(), ((NativeAd.Image)unifiedNativeAd.getImages().get(0)).getScale()));
            } else {
                this.setCoverImage(null);
            }
            this.setTitle(unifiedNativeAd.getHeadline());
            this.setCallToAction(unifiedNativeAd.getCallToAction());
            this.setPrice(unifiedNativeAd.getPrice());
            this.setDesc(unifiedNativeAd.getBody());
            this.setStarRating(unifiedNativeAd.getStarRating());
            this.setHasVideoContent(unifiedNativeAd.getVideoController().hasVideoContent());
            ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)("admob native hasVideoContent() =" + unifiedNativeAd.getVideoController().hasVideoContent()), (boolean)true);
            this.setNativeAdVideoController(new AdmobNativeViewController(unifiedNativeAd.getVideoController()));
            this.setMaterialCreationTime(System.currentTimeMillis());
            this.setMaterialEtime(AdmobNativeAdapter.this.getProvider().getMaterialEtime());
            this.setProviderName(AdmobNativeAdapter.this.getProvider().getProviderName());
            this.setSpecifiedProvider(AdmobNativeAdapter.this.getProvider().getSpecifiedProvider());
            this.setIsExpressAdView(false);
        }

        public void trackView() {
            if (this.getNativeAdView() == null) {
                ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)"admob native trackView getNativeAdView() is null", (boolean)true);
                return;
            }
            YumiNativeAdView yumiNativeAdView = this.getNativeAdView();
            ViewGroup parent = (ViewGroup)yumiNativeAdView.getParent();
            parent.removeView((View)yumiNativeAdView);
            UnifiedNativeAdView unifiedAdView = new UnifiedNativeAdView(yumiNativeAdView.getContext());
            unifiedAdView.setHeadlineView(yumiNativeAdView.getTitleView());
            unifiedAdView.setBodyView(yumiNativeAdView.getDescView());
            unifiedAdView.setIconView(yumiNativeAdView.getIconView());
            unifiedAdView.setImageView(yumiNativeAdView.getCoverImageView());
            unifiedAdView.setCallToActionView(yumiNativeAdView.getCallToActionView());
            unifiedAdView.setPriceView(yumiNativeAdView.getPriceView());
            unifiedAdView.setStarRatingView(yumiNativeAdView.getStarRatingView());
            if (yumiNativeAdView.getMediaLayout() != null) {
                MediaView mediaview = new MediaView(unifiedAdView.getContext());
                ((ViewGroup)yumiNativeAdView.getMediaLayout()).removeAllViews();
                ((ViewGroup)yumiNativeAdView.getMediaLayout()).addView((View)mediaview);
                unifiedAdView.setMediaView(mediaview);
            }
            if (!AdmobNativeAdapter.this.getProvider().getNativeAdOptions().getHideAdAttribution()) {
                TextView adAttribution = new TextView(this.getNativeAdView().getContext());
                adAttribution.setText((CharSequence)AdmobNativeAdapter.this.getProvider().getNativeAdOptions().getAdAttributionText());
                adAttribution.setTextColor(AdmobNativeAdapter.this.getProvider().getNativeAdOptions().getAdAttributionTextColor());
                adAttribution.setBackgroundColor(AdmobNativeAdapter.this.getProvider().getNativeAdOptions().getAdAttributionBackgroundColor());
                adAttribution.setTextSize((float)AdmobNativeAdapter.this.getProvider().getNativeAdOptions().getAdAttributionTextSize());
                adAttribution.setTypeface(Typeface.defaultFromStyle((int)1));
                yumiNativeAdView.addView((View)adAttribution);
                FrameLayout.LayoutParams adAttributionParams = new FrameLayout.LayoutParams(-2, -2);
                AdmobNativeAdapter.this.setViewPosition(adAttributionParams, AdmobNativeAdapter.this.getProvider().getNativeAdOptions().getAdAttributionPosition());
                adAttribution.setLayoutParams((ViewGroup.LayoutParams)adAttributionParams);
                yumiNativeAdView.requestLayout();
            }
            unifiedAdView.removeAllViews();
            unifiedAdView.addView((View)yumiNativeAdView);
            parent.addView((View)unifiedAdView);
            unifiedAdView.setNativeAd(this.unifiedNativeAd);
        }

        public void destroy() {
            ZplayDebug.v((String)AdmobNativeAdapter.this.TAG, (String)"admob native destory", (boolean)true);
            if (this.unifiedNativeAd != null) {
                this.unifiedNativeAd.destroy();
            }
        }

        public class AdmobNativeViewController
        extends YumiNativeAdVideoController {
            private VideoController vc;

            private AdmobNativeViewController(VideoController vc) {
                this.vc = vc;
            }

            public void play() {
                if (this.vc != null) {
                    this.vc.play();
                }
            }

            public void pause() {
                if (this.vc != null) {
                    this.vc.pause();
                }
            }

            public double getAspectRatio() {
                if (this.vc != null) {
                    return this.vc.getAspectRatio();
                }
                return 0.0;
            }

            public void setVideoLifecycleCallbacks(final YumiNativeAdVideoController.YumiVideoLifecycleCallbacks videoLifecycleCallbacks) {
                if (this.vc != null) {
                    this.vc.setVideoLifecycleCallbacks(new VideoController.VideoLifecycleCallbacks(){

                        public void onVideoPlay() {
                            super.onVideoPlay();
                            if (videoLifecycleCallbacks != null) {
                                videoLifecycleCallbacks.onVideoPlay();
                            }
                        }

                        public void onVideoPause() {
                            super.onVideoPause();
                            if (videoLifecycleCallbacks != null) {
                                videoLifecycleCallbacks.onVideoPause();
                            }
                        }

                        public void onVideoEnd() {
                            super.onVideoEnd();
                            if (videoLifecycleCallbacks != null) {
                                videoLifecycleCallbacks.onVideoEnd();
                            }
                        }
                    });
                }
            }
        }
    }
}

