/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.yumi.android.sdk.ads.adapter.admob.AdMobUtil;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerInterstitialAdapter;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobInterstitialAdapter
extends YumiCustomerInterstitialAdapter {
    private static final String TAG = "AdmobInterstitialAdapter";
    private InterstitialAd instertitial;
    private AdListener adListener;

    protected AdmobInterstitialAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    protected final void callOnActivityDestroy() {
    }

    public boolean onActivityBackPressed() {
        return false;
    }

    protected void onPrepareInterstitial() {
        ZplayDebug.d((String)TAG, (String)"admob request new interstitial", (boolean)true);
        if (this.instertitial == null) {
            this.instertitial = new InterstitialAd((Context)this.getActivity());
            this.instertitial.setAdUnitId(this.getProvider().getKey1());
            this.instertitial.setAdListener(this.adListener);
        }
        AdRequest req = new AdRequest.Builder().build();
        this.instertitial.loadAd(req);
    }

    protected void onShowInterstitialLayer(Activity activity) {
        this.instertitial.show();
    }

    protected boolean isInterstitialLayerReady() {
        return this.instertitial != null && this.instertitial.isLoaded();
    }

    protected void init() {
        ZplayDebug.i((String)TAG, (String)("unitId : " + this.getProvider().getKey1()), (boolean)true);
        this.createAdListener();
    }

    private void createAdListener() {
        this.adListener = new AdListener(){

            public void onAdClosed() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial closed", (boolean)true);
                AdmobInterstitialAdapter.this.layerClosed();
                super.onAdClosed();
            }

            public void onAdOpened() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial shown", (boolean)true);
                AdmobInterstitialAdapter.this.layerExposure();
                super.onAdOpened();
            }

            public void onAdLeftApplication() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial clicked", (boolean)true);
                AdmobInterstitialAdapter.this.layerClicked(-99.0f, -99.0f);
                super.onAdLeftApplication();
            }

            public void onAdLoaded() {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)"admob interstitial prepared", (boolean)true);
                AdmobInterstitialAdapter.this.layerPrepared();
                super.onAdLoaded();
            }

            public void onAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobInterstitialAdapter.TAG, (String)("admob interstitial failed " + errorCode), (boolean)true);
                AdmobInterstitialAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(errorCode));
                super.onAdFailedToLoad(errorCode);
            }
        };
    }
}

