/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerMediaAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobMediaAdapter
extends YumiCustomerMediaAdapter {
    private static final String TAG = "AdmobMediaAdapter";
    private RewardedVideoAd mAd;
    private RewardedVideoAdListener mediaListener;
    private static final int REQUEST_NEXT_MEDIA = 1;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AdmobMediaAdapter.this.mAd == null || AdmobMediaAdapter.this.mAd.isLoaded()) break;
                    ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media loadRewardedVideoAd loadAd", (boolean)true);
                    AdmobMediaAdapter.this.mAd.loadAd(AdmobMediaAdapter.this.getProvider().getKey1(), new AdRequest.Builder().build());
                    break;
                }
            }
        }
    };

    protected AdmobMediaAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    protected void onPrepareMedia() {
        this.loadRewardedVideoAd(1);
    }

    protected void onShowMedia() {
        if (this.mAd != null && this.mAd.isLoaded()) {
            this.mAd.show();
        }
    }

    protected boolean isMediaReady() {
        if (this.mAd != null && this.mAd.isLoaded()) {
            ZplayDebug.d((String)TAG, (String)"admob media isMediaReady true", (boolean)true);
            return true;
        }
        ZplayDebug.d((String)TAG, (String)"admob media isMediaReady false", (boolean)true);
        return false;
    }

    protected void init() {
        this.createMediaListener();
        this.mAd = MobileAds.getRewardedVideoAdInstance((Context)this.getActivity());
        this.mAd.setRewardedVideoAdListener(this.mediaListener);
    }

    protected void callOnActivityDestroy() {
        if (this.mHandler != null && this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
    }

    private void createMediaListener() {
        this.mediaListener = new RewardedVideoAdListener(){

            public void onRewardedVideoAdLoaded() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdLoaded", (boolean)true);
                AdmobMediaAdapter.this.layerPrepared();
            }

            public void onRewardedVideoAdOpened() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdOpened  layerClicked", (boolean)true);
                AdmobMediaAdapter.this.layerClicked();
            }

            public void onRewardedVideoStarted() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoStarted", (boolean)true);
                AdmobMediaAdapter.this.layerMediaStart();
            }

            public void onRewardedVideoAdClosed() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdClosed", (boolean)true);
                AdmobMediaAdapter.this.layerMediaEnd();
                AdmobMediaAdapter.this.layerClosed();
                AdmobMediaAdapter.this.loadRewardedVideoAd(1);
            }

            public void onRewarded(RewardItem rewardItem) {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewarded", (boolean)true);
                AdmobMediaAdapter.this.layerIncentived();
            }

            public void onRewardedVideoAdLeftApplication() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdLeftApplication", (boolean)true);
            }

            public void onRewardedVideoAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)("admob media onRewardedVideoAdFailedToLoad errorCode:" + errorCode), (boolean)true);
                if (3 == errorCode) {
                    AdmobMediaAdapter.this.layerPreparedFailed(LayerErrorCode.ERROR_NO_FILL);
                } else {
                    AdmobMediaAdapter.this.layerPreparedFailed(LayerErrorCode.ERROR_INTERNAL);
                }
                AdmobMediaAdapter.this.loadRewardedVideoAd(AdmobMediaAdapter.this.getProvider().getNextRequestInterval());
            }
        };
    }

    private void loadRewardedVideoAd(int delaySecond) {
        try {
            if (!this.mHandler.hasMessages(1)) {
                ZplayDebug.d((String)TAG, (String)("admob media Video requestAD delaySecond" + delaySecond), (boolean)true);
                this.mHandler.sendEmptyMessageDelayed(1, (long)(delaySecond * 1000));
            }
        }
        catch (Exception e) {
            ZplayDebug.e((String)TAG, (String)"admob media requestAD error ", (Throwable)e, (boolean)true);
        }
    }
}

