/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerMediaAdapter;
import com.yumi.android.sdk.ads.publish.enumbean.LayerErrorCode;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobMediaAdapter
extends YumiCustomerMediaAdapter {
    private static final String TAG = "AdmobMediaAdapter";
    private RewardedVideoAd mAd;
    private RewardedVideoAdListener mediaListener;
    private boolean isPreparedFailed = false;

    protected AdmobMediaAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    protected void onPrepareMedia() {
        this.loadRewardedVideoAd();
    }

    protected void onShowMedia() {
        if (this.mAd.isLoaded()) {
            this.mAd.show();
        }
    }

    protected boolean isMediaReady() {
        if (this.mAd.isLoaded()) {
            return true;
        }
        if (this.isPreparedFailed) {
            this.loadRewardedVideoAd();
        }
        return false;
    }

    protected void init() {
        this.createMediaListener();
        this.mAd = MobileAds.getRewardedVideoAdInstance((Context)this.getActivity());
        this.mAd.setRewardedVideoAdListener(this.mediaListener);
    }

    protected void callOnActivityDestroy() {
    }

    private void createMediaListener() {
        this.mediaListener = new RewardedVideoAdListener(){

            public void onRewardedVideoAdLoaded() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdLoaded", (boolean)true);
                AdmobMediaAdapter.this.layerPrepared();
            }

            public void onRewardedVideoAdOpened() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdOpened  layerClicked", (boolean)true);
                AdmobMediaAdapter.this.layerClicked();
            }

            public void onRewardedVideoStarted() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoStarted", (boolean)true);
                AdmobMediaAdapter.this.layerMediaStart();
            }

            public void onRewardedVideoAdClosed() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdClosed", (boolean)true);
                AdmobMediaAdapter.this.layerMediaEnd();
                AdmobMediaAdapter.this.layerClosed();
                AdmobMediaAdapter.this.loadRewardedVideoAd();
            }

            public void onRewarded(RewardItem rewardItem) {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewarded", (boolean)true);
                AdmobMediaAdapter.this.layerIncentived();
            }

            public void onRewardedVideoAdLeftApplication() {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)"admob media onRewardedVideoAdLeftApplication", (boolean)true);
            }

            public void onRewardedVideoAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobMediaAdapter.TAG, (String)("admob media onRewardedVideoAdFailedToLoad errorCode:" + errorCode), (boolean)true);
                if (3 == errorCode) {
                    AdmobMediaAdapter.this.layerPreparedFailed(LayerErrorCode.ERROR_NO_FILL);
                } else {
                    AdmobMediaAdapter.this.layerPreparedFailed(LayerErrorCode.ERROR_INTERNAL);
                }
                AdmobMediaAdapter.this.isPreparedFailed = true;
            }
        };
    }

    private void loadRewardedVideoAd() {
        ZplayDebug.d((String)TAG, (String)"admob media loadRewardedVideoAd", (boolean)true);
        if (this.mAd != null && !this.mAd.isLoaded()) {
            ZplayDebug.d((String)TAG, (String)"admob media loadRewardedVideoAd loadAd", (boolean)true);
            this.isPreparedFailed = false;
            this.mAd.loadAd(this.getProvider().getKey1(), new AdRequest.Builder().build());
        }
    }
}

