/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.util;

import com.yubico.yubikit.core.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;

public class Tlv {
    private final int tag;
    private final int length;
    private final byte[] bytes;
    private final int offset;

    public Tlv(int tag, @Nullable byte[] value) {
        this.tag = tag;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] tagBytes = BigInteger.valueOf(tag).toByteArray();
        int stripLeading = tagBytes[0] == 0 ? 1 : 0;
        stream.write(tagBytes, stripLeading, tagBytes.length - stripLeading);
        int n = this.length = value == null ? 0 : value.length;
        if (this.length < 128) {
            stream.write(this.length);
        } else {
            byte[] lnBytes = BigInteger.valueOf(this.length).toByteArray();
            stripLeading = lnBytes[0] == 0 ? 1 : 0;
            stream.write(0x80 | lnBytes.length - stripLeading);
            stream.write(lnBytes, stripLeading, lnBytes.length - stripLeading);
        }
        this.offset = stream.size();
        if (value != null) {
            stream.write(value, 0, this.length);
        }
        this.bytes = stream.toByteArray();
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getValue() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public String toString() {
        return String.format(Locale.ROOT, "Tlv(0x%x, %d, %s)", this.tag, this.length, StringUtils.bytesToHex(this.getValue()));
    }

    public static Tlv parse(byte[] data, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, length);
        Tlv tlv = Tlv.parseFrom(buffer);
        if (buffer.hasRemaining()) {
            throw new IllegalArgumentException("Extra data remaining");
        }
        return tlv;
    }

    public static Tlv parse(byte[] data) {
        return Tlv.parse(data, 0, data.length);
    }

    static Tlv parseFrom(ByteBuffer buffer) {
        int length;
        int tag = buffer.get() & 0xFF;
        if ((tag & 0x1F) == 31) {
            tag = tag << 8 | buffer.get() & 0xFF;
            while ((tag & 0x80) == 128) {
                tag = tag << 8 | buffer.get() & 0xFF;
            }
        }
        if ((length = buffer.get() & 0xFF) == 128) {
            throw new IllegalArgumentException("Indefinite length not supported");
        }
        if (length > 128) {
            int lengthLn = length - 128;
            length = 0;
            for (int i = 0; i < lengthLn; ++i) {
                length = length << 8 | buffer.get() & 0xFF;
            }
        }
        byte[] value = new byte[length];
        buffer.get(value);
        return new Tlv(tag, value);
    }
}

