/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class NdefUtils {
    private static final byte[] HEADER = new byte[]{-47, 85, 4};
    private static final byte NDEF_RECORD = -47;
    private static final byte TYPE_LENGTH = 1;
    private static final byte URL_TYPE = 85;
    private static final byte HTTPS_PROTOCOL = 4;
    private static final byte[] DOMAIN = "my.yubico.com".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NEO_REMAINDER_PREFIX = "/neo/".getBytes(StandardCharsets.UTF_8);

    public static String getNdefPayload(byte[] ndefData) {
        return new String(NdefUtils.getNdefPayloadBytes(ndefData), StandardCharsets.UTF_8);
    }

    public static byte[] getNdefPayloadBytes(byte[] ndefData) {
        ByteBuffer data = ByteBuffer.wrap(ndefData);
        byte record = data.get();
        byte typeLength = data.get();
        int dataLength = 0xFF & data.get() - typeLength;
        byte recordType = data.get();
        byte protocol = data.get();
        if (record != -47 || typeLength != 1 || recordType != 85 || protocol != 4) {
            throw new IllegalArgumentException("Not a HTTPS URL NDEF record");
        }
        byte[] domain = new byte[DOMAIN.length];
        data.get(domain);
        if (!Arrays.equals(DOMAIN, domain)) {
            throw new IllegalArgumentException("Incorrect URL domain");
        }
        byte[] remaining = new byte[dataLength - DOMAIN.length];
        data.get(remaining);
        if (Arrays.equals(NEO_REMAINDER_PREFIX, Arrays.copyOf(remaining, NEO_REMAINDER_PREFIX.length))) {
            return Arrays.copyOfRange(remaining, NEO_REMAINDER_PREFIX.length, remaining.length);
        }
        for (int i = 0; i < remaining.length; ++i) {
            if (remaining[i] != 35) continue;
            return Arrays.copyOfRange(remaining, i + 1, remaining.length);
        }
        throw new IllegalArgumentException("Incorrect URL format");
    }
}

