/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.smartcard;

import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.Version;
import com.yubico.yubikit.core.application.ApplicationNotAvailableException;
import com.yubico.yubikit.core.smartcard.Apdu;
import com.yubico.yubikit.core.smartcard.ApduException;
import com.yubico.yubikit.core.smartcard.ApduFormat;
import com.yubico.yubikit.core.smartcard.ApduResponse;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SmartCardProtocol
implements Closeable {
    private static final byte INS_SELECT = -92;
    private static final byte P1_SELECT = 4;
    private static final byte P2_SELECT = 0;
    private static final byte INS_SEND_REMAINING = -64;
    private static final byte SW1_HAS_MORE_DATA = 97;
    private static final int SHORT_APDU_MAX_CHUNK = 255;
    private final byte insSendRemaining;
    private final SmartCardConnection connection;
    private ApduFormat apduFormat = ApduFormat.SHORT;
    private boolean useTouchWorkaround = false;
    private long lastLongResponse = 0L;

    public SmartCardProtocol(SmartCardConnection connection) {
        this(connection, -64);
    }

    public SmartCardProtocol(SmartCardConnection connection, byte insSendRemaining) {
        this.connection = connection;
        this.insSendRemaining = insSendRemaining;
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    public void enableWorkarounds(Version firmwareVersion) {
        if (this.connection.getTransport() == Transport.USB && firmwareVersion.isAtLeast(4, 2, 0) && firmwareVersion.isLessThan(4, 2, 7)) {
            this.setEnableTouchWorkaround(true);
        }
    }

    public void setEnableTouchWorkaround(boolean enableTouchWorkaround) {
        this.useTouchWorkaround = enableTouchWorkaround;
    }

    public void setApduFormat(ApduFormat apduFormat) {
        this.apduFormat = apduFormat;
    }

    public SmartCardConnection getConnection() {
        return this.connection;
    }

    public byte[] select(byte[] aid) throws IOException, ApplicationNotAvailableException {
        try {
            return this.sendAndReceive(new Apdu(0, -92, 4, 0, aid));
        }
        catch (ApduException e) {
            if (e.getSw() == 27266 || e.getSw() == 27904) {
                throw new ApplicationNotAvailableException("The application couldn't be selected", e);
            }
            throw new IOException("Unexpected SW", e);
        }
    }

    public byte[] sendAndReceive(Apdu command) throws IOException, ApduException {
        byte[] getData;
        ApduResponse response;
        if (this.useTouchWorkaround && this.lastLongResponse > 0L && System.currentTimeMillis() - this.lastLongResponse < 2000L) {
            this.connection.sendAndReceive(new byte[5]);
            this.lastLongResponse = 0L;
        }
        byte[] data = command.getData();
        switch (this.apduFormat) {
            case SHORT: {
                int offset = 0;
                while (data.length - offset > 255) {
                    response = new ApduResponse(this.connection.sendAndReceive(SmartCardProtocol.encodeShortApdu((byte)(command.getCla() | 0x10), command.getIns(), command.getP1(), command.getP2(), data, offset, 255)));
                    if (response.getSw() != -28672) {
                        throw new ApduException(response.getSw());
                    }
                    offset += 255;
                }
                response = new ApduResponse(this.connection.sendAndReceive(SmartCardProtocol.encodeShortApdu(command.getCla(), command.getIns(), command.getP1(), command.getP2(), data, offset, data.length - offset)));
                getData = new byte[]{0, this.insSendRemaining, 0, 0, 0};
                break;
            }
            case EXTENDED: {
                response = new ApduResponse(this.connection.sendAndReceive(SmartCardProtocol.encodeExtendedApdu(command.getCla(), command.getIns(), command.getP1(), command.getP2(), data)));
                getData = new byte[]{0, this.insSendRemaining, 0, 0, 0, 0, 0};
                break;
            }
            default: {
                throw new IllegalStateException("Invalid APDU format");
            }
        }
        ByteArrayOutputStream readBuffer = new ByteArrayOutputStream();
        while (response.getSw() >> 8 == 97) {
            readBuffer.write(response.getData());
            response = new ApduResponse(this.connection.sendAndReceive(getData));
        }
        if (response.getSw() != -28672) {
            throw new ApduException(response.getSw());
        }
        readBuffer.write(response.getData());
        byte[] responseData = readBuffer.toByteArray();
        this.lastLongResponse = this.useTouchWorkaround && responseData.length > 54 ? System.currentTimeMillis() : 0L;
        return responseData;
    }

    private static byte[] encodeShortApdu(byte cla, byte ins, byte p1, byte p2, byte[] data, int offset, int length) {
        if (length > 255) {
            throw new IllegalArgumentException("Length must be no greater than 255");
        }
        return ByteBuffer.allocate(5 + length).put(cla).put(ins).put(p1).put(p2).put((byte)length).put(data, offset, length).array();
    }

    private static byte[] encodeExtendedApdu(byte cla, byte ins, byte p1, byte p2, byte[] data) {
        return ByteBuffer.allocate(7 + data.length).put(cla).put(ins).put(p1).put(p2).put((byte)0).putShort((short)data.length).put(data).array();
    }
}

