/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.smartcard;

import java.util.Arrays;
import javax.annotation.Nullable;

public class Apdu {
    private final byte cla;
    private final byte ins;
    private final byte p1;
    private final byte p2;
    private final byte[] data;

    private Apdu(byte cla, byte ins, byte p1, byte p2, @Nullable byte[] data) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.data = data == null ? new byte[]{} : data;
    }

    public Apdu(int cla, int ins, int p1, int p2, @Nullable byte[] data) {
        this(Apdu.validateByte(cla, "CLA"), Apdu.validateByte(ins, "INS"), Apdu.validateByte(p1, "P1"), Apdu.validateByte(p2, "P2"), data);
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public byte getCla() {
        return this.cla;
    }

    public byte getIns() {
        return this.ins;
    }

    public byte getP1() {
        return this.p1;
    }

    public byte getP2() {
        return this.p2;
    }

    private static byte validateByte(int byteInt, String name) {
        if (byteInt > 255 || byteInt < -128) {
            throw new IllegalArgumentException("Invalid value for " + name + ", must fit in a byte");
        }
        return (byte)byteInt;
    }
}

