/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.otp;

import com.yubico.yubikit.core.Version;
import com.yubico.yubikit.core.application.CommandException;
import com.yubico.yubikit.core.application.CommandState;
import com.yubico.yubikit.core.application.TimeoutException;
import com.yubico.yubikit.core.otp.ChecksumUtils;
import com.yubico.yubikit.core.otp.CommandRejectedException;
import com.yubico.yubikit.core.otp.OtpConnection;
import com.yubico.yubikit.core.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpProtocol
implements Closeable {
    private static final int FEATURE_RPT_SIZE = 8;
    private static final int FEATURE_RPT_DATA_SIZE = 7;
    private static final int SLOT_DATA_SIZE = 64;
    private static final int FRAME_SIZE = 70;
    private static final int RESP_PENDING_FLAG = 64;
    private static final int SLOT_WRITE_FLAG = 128;
    private static final int RESP_TIMEOUT_WAIT_FLAG = 32;
    private static final int DUMMY_REPORT_WRITE = 143;
    private static final int SEQUENCE_MASK = 31;
    private static final int SEQUENCE_OFFSET = 4;
    private final CommandState defaultState = new CommandState();
    private final OtpConnection connection;
    private final Version version;
    private static final Logger logger = LoggerFactory.getLogger(OtpProtocol.class);

    public OtpProtocol(OtpConnection connection) throws IOException {
        this.connection = connection;
        byte[] featureReport = this.readFeatureReport();
        if (featureReport[4] == 3) {
            byte[] scanMap = new byte[51];
            Arrays.fill(scanMap, (byte)99);
            try {
                this.sendAndReceive((byte)18, scanMap, null);
            }
            catch (CommandException commandException) {
                // empty catch block
            }
        }
        this.version = Version.fromBytes(Arrays.copyOfRange(featureReport, 1, 4));
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    public byte[] sendAndReceive(byte slot, @Nullable byte[] data, @Nullable CommandState state) throws IOException, CommandException {
        byte[] payload;
        if (data == null) {
            payload = new byte[64];
        } else {
            if (data.length > 64) {
                throw new IllegalArgumentException("Payload too large for HID frame!");
            }
            payload = Arrays.copyOf(data, 64);
        }
        return this.readFrame(this.sendFrame(slot, payload), state != null ? state : this.defaultState);
    }

    public byte[] readStatus() throws IOException {
        byte[] featureReport = this.readFeatureReport();
        return Arrays.copyOfRange(featureReport, 1, featureReport.length - 1);
    }

    private byte[] readFeatureReport() throws IOException {
        byte[] bufferRead = new byte[8];
        this.connection.receive(bufferRead);
        com.yubico.yubikit.core.internal.Logger.trace(logger, "READ FEATURE REPORT: {}", (Object)StringUtils.bytesToHex(bufferRead));
        return bufferRead;
    }

    private void writeFeatureReport(byte[] buffer) throws IOException {
        com.yubico.yubikit.core.internal.Logger.trace(logger, "WRITE FEATURE REPORT: {}", (Object)StringUtils.bytesToHex(buffer));
        this.connection.send(buffer);
    }

    private void awaitReadyToWrite() throws IOException {
        for (int i = 0; i < 20; ++i) {
            if ((this.readFeatureReport()[7] & 0x80) == 0) {
                return;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new IOException("Timeout waiting for YubiKey to become ready to receive");
    }

    private static boolean shouldSend(byte[] packet, byte seq) {
        if (seq == 0 || seq == 9) {
            return true;
        }
        for (int i = 0; i < 7; ++i) {
            if (packet[i] == 0) continue;
            return true;
        }
        return false;
    }

    private int sendFrame(byte slot, byte[] payload) throws IOException {
        com.yubico.yubikit.core.internal.Logger.trace(logger, "Sending payload over HID to slot {}: {}", (Object)String.format("0x%02x", 0xFF & slot), (Object)StringUtils.bytesToHex(payload));
        ByteBuffer buf = ByteBuffer.allocate(70).order(ByteOrder.LITTLE_ENDIAN).put(payload).put(slot).putShort(ChecksumUtils.calculateCrc(payload, payload.length)).put(new byte[3]);
        buf.flip();
        byte programmingSequence = this.readFeatureReport()[4];
        byte seq = 0;
        byte[] report = new byte[8];
        while (buf.hasRemaining()) {
            buf.get(report, 0, 7);
            if (OtpProtocol.shouldSend(report, seq)) {
                report[7] = (byte)(0x80 | seq);
                this.awaitReadyToWrite();
                this.writeFeatureReport(report);
            }
            seq = (byte)(seq + 1);
        }
        return programmingSequence;
    }

    private byte[] readFrame(int programmingSequence, CommandState state) throws IOException, CommandException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int seq = 0;
        boolean needsTouch = false;
        while (true) {
            long timeout;
            byte[] report;
            byte statusByte;
            if (((statusByte = (report = this.readFeatureReport())[7]) & 0x40) != 0) {
                if (seq == (statusByte & 0x1F)) {
                    stream.write(report, 0, 7);
                    seq = (byte)(seq + 1);
                    continue;
                }
                if (0 != (statusByte & 0x1F)) continue;
                this.resetState();
                byte[] response = stream.toByteArray();
                com.yubico.yubikit.core.internal.Logger.trace(logger, "{} bytes read over HID: {}", (Object)response.length, (Object)StringUtils.bytesToHex(response));
                return response;
            }
            if (statusByte == 0) {
                byte prgSeq = report[4];
                if (stream.size() > 0) {
                    throw new IOException("Incomplete transfer");
                }
                if (prgSeq == programmingSequence + 1 || programmingSequence > 0 && prgSeq == 0 && report[5] == 0) {
                    byte[] status = Arrays.copyOfRange(report, 1, 7);
                    com.yubico.yubikit.core.internal.Logger.trace(logger, "HID programming sequence updated. New status: {}", (Object)StringUtils.bytesToHex(status));
                    return status;
                }
                if (needsTouch) {
                    throw new TimeoutException("Timed out waiting for touch");
                }
                throw new CommandRejectedException("No data");
            }
            if ((statusByte & 0x20) != 0) {
                state.onKeepAliveStatus((byte)2);
                needsTouch = true;
                timeout = 100L;
            } else {
                state.onKeepAliveStatus((byte)1);
                timeout = 20L;
            }
            if (state.waitForCancel(timeout)) break;
        }
        this.resetState();
        throw new TimeoutException("Command cancelled by CommandState");
    }

    private void resetState() throws IOException {
        byte[] buffer = new byte[8];
        buffer[7] = -113;
        this.writeFeatureReport(buffer);
    }
}

