/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.application;

import com.yubico.yubikit.core.Version;
import com.yubico.yubikit.core.application.ApplicationSession;

public abstract class Feature<T extends ApplicationSession<T>> {
    protected final String featureName;

    protected Feature(String featureName) {
        this.featureName = featureName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public abstract boolean isSupportedBy(Version var1);

    protected String getRequiredMessage() {
        return String.format("%s is not supported by this YubiKey", this.featureName);
    }

    public static class Versioned<T extends ApplicationSession<T>>
    extends Feature<T> {
        private final Version requiredVersion;

        public Versioned(String featureName, int major, int minor, int micro) {
            super(featureName);
            this.requiredVersion = new Version(major, minor, micro);
        }

        @Override
        protected String getRequiredMessage() {
            return String.format("%s requires YubiKey %s or later", this.featureName, this.requiredVersion);
        }

        @Override
        public boolean isSupportedBy(Version version) {
            return version.major == 0 || version.compareTo(this.requiredVersion) >= 0;
        }
    }
}

