/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.util;

import com.yubico.yubikit.core.application.BadResponseException;
import com.yubico.yubikit.core.util.Tlv;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Tlvs {
    public static List<Tlv> decodeList(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        ArrayList<Tlv> tlvs = new ArrayList<Tlv>();
        while (buffer.hasRemaining()) {
            Tlv tlv = Tlv.parseFrom(buffer);
            tlvs.add(tlv);
        }
        return tlvs;
    }

    public static Map<Integer, byte[]> decodeMap(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        LinkedHashMap<Integer, byte[]> tlvs = new LinkedHashMap<Integer, byte[]>();
        while (buffer.hasRemaining()) {
            Tlv tlv = Tlv.parseFrom(buffer);
            tlvs.put(tlv.getTag(), tlv.getValue());
        }
        return tlvs;
    }

    public static byte[] encodeList(Iterable<? extends Tlv> list) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (Tlv tlv : list) {
            byte[] tlvBytes = tlv.getBytes();
            stream.write(tlvBytes, 0, tlvBytes.length);
        }
        return stream.toByteArray();
    }

    public static byte[] encodeMap(Map<Integer, byte[]> map) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (Map.Entry<Integer, byte[]> entry : map.entrySet()) {
            Tlv tlv = new Tlv(entry.getKey(), entry.getValue());
            byte[] tlvBytes = tlv.getBytes();
            stream.write(tlvBytes, 0, tlvBytes.length);
        }
        return stream.toByteArray();
    }

    public static byte[] unpackValue(int expectedTag, byte[] tlvData) throws BadResponseException {
        Tlv tlv = Tlv.parse(tlvData, 0, tlvData.length);
        if (tlv.getTag() != expectedTag) {
            throw new BadResponseException(String.format("Expected tag: %02x, got %02x", expectedTag, tlv.getTag()));
        }
        return tlv.getValue();
    }
}

