/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.util;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class Result<T, E extends Throwable> {
    @Nullable
    private final T value;
    @Nullable
    private final E error;

    private Result(@Nullable T value, @Nullable E error) {
        this.value = value;
        this.error = error;
    }

    public T getValue() throws E {
        if (this.value != null) {
            return this.value;
        }
        assert (this.error != null);
        throw this.error;
    }

    public boolean isSuccess() {
        return this.value != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public static <T, E extends Throwable> Result<T, E> success(T value) {
        return new Result<T, Object>(value, null);
    }

    public static <T, E extends Throwable> Result<T, E> failure(E error) {
        return new Result<Object, E>(null, error);
    }

    public static <T> Result<T, Exception> of(Callable<T> call) {
        try {
            return Result.success(call.call());
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }
}

