/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.smartcard;

import java.util.Arrays;

public class ApduResponse {
    private final byte[] bytes;

    public ApduResponse(byte[] bytes) {
        if (bytes.length < 2) {
            throw new IllegalArgumentException("Invalid APDU response data");
        }
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public short getSw() {
        return (short)((0xFF & this.bytes[this.bytes.length - 2]) << 8 | 0xFF & this.bytes[this.bytes.length - 1]);
    }

    public byte[] getData() {
        return Arrays.copyOfRange(this.bytes, 0, this.bytes.length - 2);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }
}

