/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.otp;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;

public class Modhex {
    private static final char[] ALPHABET = "cbdefghijklnrtuv".toCharArray();
    private static final Map<Character, Integer> table = new HashMap<Character, Integer>();

    public static byte[] decode(String modhex) {
        if (modhex.length() % 2 != 0) {
            throw new IllegalArgumentException("Input string length is not a multiple of 2");
        }
        int byteValue = 0;
        char[] chars = modhex.toLowerCase().toCharArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int i = 0; i < chars.length; ++i) {
            boolean shift;
            Integer code = table.get(Character.valueOf(chars[i]));
            if (code == null) {
                throw new IllegalArgumentException("Input string contains non-modhex character(s).");
            }
            boolean bl = shift = i % 2 == 0;
            if (shift) {
                byteValue = (byte)(code << 4);
                continue;
            }
            byteValue = (byte)(byteValue | code);
            outputStream.write(byteValue);
        }
        return outputStream.toByteArray();
    }

    public static String encode(byte[] bytes) {
        StringBuilder output = new StringBuilder();
        for (byte b : bytes) {
            output.append(ALPHABET[b >> 4 & 0xF]).append(ALPHABET[b & 0xF]);
        }
        return output.toString();
    }

    static {
        for (int i = 0; i < ALPHABET.length; ++i) {
            table.put(Character.valueOf(ALPHABET[i]), i);
        }
    }
}

