/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core.fido;

import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.Version;
import com.yubico.yubikit.core.application.CommandState;
import com.yubico.yubikit.core.fido.FidoConnection;
import com.yubico.yubikit.core.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.Nullable;

public class FidoProtocol
implements Closeable {
    public static final byte TYPE_INIT = -128;
    private static final byte CMD_PING = -127;
    private static final byte CMD_APDU = -125;
    private static final byte CMD_INIT = -122;
    private static final byte CMD_WINK = -120;
    private static final byte CMD_CANCEL = -111;
    private static final byte STATUS_ERROR = -65;
    private static final byte STATUS_KEEPALIVE = -69;
    private final CommandState defaultState = new CommandState();
    private final FidoConnection connection;
    private final Version version;
    private int channelId;

    public FidoProtocol(FidoConnection connection) throws IOException {
        this.connection = connection;
        byte[] nonce = new byte[8];
        new SecureRandom().nextBytes(nonce);
        this.channelId = -1;
        ByteBuffer buffer = ByteBuffer.wrap(this.sendAndReceive((byte)-122, nonce, null));
        byte[] responseNonce = new byte[nonce.length];
        buffer.get(responseNonce);
        if (!MessageDigest.isEqual(nonce, responseNonce)) {
            throw new IOException("Got wrong nonce!");
        }
        this.channelId = buffer.getInt();
        buffer.get();
        byte[] versionBytes = new byte[3];
        buffer.get(versionBytes);
        this.version = Version.fromBytes(versionBytes);
        buffer.get();
        Logger.d(String.format("fido connection set up with channel ID: 0x%08x", this.channelId));
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] sendAndReceive(byte cmd, byte[] payload, @Nullable CommandState state) throws IOException {
        state = state != null ? state : this.defaultState;
        ByteBuffer toSend = ByteBuffer.wrap(payload);
        byte[] buffer = new byte[64];
        ByteBuffer packet = ByteBuffer.wrap(buffer);
        byte seq = 0;
        packet.putInt(this.channelId).put(cmd).putShort((short)toSend.remaining());
        do {
            toSend.get(buffer, packet.position(), Math.min(toSend.remaining(), packet.remaining()));
            this.connection.send(buffer);
            Logger.d(buffer.length + " bytes sent over fido: " + StringUtils.bytesToHex(buffer));
            Arrays.fill(buffer, (byte)0);
            packet.clear();
            byte by = seq;
            seq = (byte)(seq + 1);
            packet.putInt(this.channelId).put((byte)(0x7F & by));
        } while (toSend.hasRemaining());
        seq = 0;
        ByteBuffer response = null;
        do {
            block10: {
                packet.clear();
                if (state.waitForCancel(0L)) {
                    Logger.d("sending CTAP cancel...");
                    Arrays.fill(buffer, (byte)0);
                    packet.putInt(this.channelId).put((byte)-111);
                    this.connection.send(buffer);
                    Logger.d("Sent over fido: " + StringUtils.bytesToHex(buffer));
                    packet.clear();
                }
                this.connection.receive(buffer);
                Logger.d("Received over fido: " + StringUtils.bytesToHex(buffer));
                int responseChannel = packet.getInt();
                if (responseChannel != this.channelId) {
                    throw new IOException(String.format("Wrong Channel ID. Expecting: %d, Got: %d", this.channelId, responseChannel));
                }
                if (response == null) {
                    byte responseCmd = packet.get();
                    if (responseCmd == cmd) {
                        response = ByteBuffer.allocate(packet.getShort());
                        break block10;
                    } else {
                        if (responseCmd == -69) {
                            state.onKeepAliveStatus(packet.get());
                            continue;
                        }
                        if (responseCmd == -65) {
                            throw new IOException(String.format("CTAPHID error: %02x", packet.get()));
                        }
                        throw new IOException(String.format("Wrong response command. Expecting: %x, Got: %x", cmd, responseCmd));
                    }
                }
                byte responseSeq = packet.get();
                byte by = seq;
                seq = (byte)(seq + 1);
                if (responseSeq != by) {
                    throw new IOException(String.format("Wrong sequence number. Expecting %d, Got: %d", seq - 1, responseSeq));
                }
            }
            response.put(buffer, packet.position(), Math.min(packet.remaining(), response.remaining()));
        } while (response == null || response.hasRemaining());
        return response.array();
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
        Logger.d("fido connection closed");
    }
}

