/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.core;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("\\b(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\b");
    public final byte major;
    public final byte minor;
    public final byte micro;

    private static byte checkRange(int value) {
        if (value < 0 || value > 127) {
            throw new IllegalArgumentException("Version component out of supported range (0-127)");
        }
        return (byte)value;
    }

    public Version(int major, int minor, int micro) {
        this(Version.checkRange(major), Version.checkRange(minor), Version.checkRange(micro));
    }

    public Version(byte major, byte minor, byte micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public byte[] getBytes() {
        return new byte[]{this.major, this.minor, this.micro};
    }

    private int compareToVersion(int major, int minor, int micro) {
        return Integer.compare(this.major << 16 | this.minor << 8 | this.micro, major << 16 | minor << 8 | micro);
    }

    @Override
    public int compareTo(Version other) {
        return this.compareToVersion(other.major, other.minor, other.micro);
    }

    public boolean isLessThan(int major, int minor, int micro) {
        return this.compareToVersion(major, minor, micro) < 0;
    }

    public boolean isAtLeast(int major, int minor, int micro) {
        return this.compareToVersion(major, minor, micro) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%d.%d.%d", 0xFF & this.major, 0xFF & this.minor, 0xFF & this.micro);
    }

    public static Version fromBytes(byte[] bytes) {
        if (bytes.length < 3) {
            throw new IllegalArgumentException("Version byte array must contain 3 bytes.");
        }
        return new Version(bytes[0], bytes[1], bytes[2]);
    }

    public static Version parse(String versionString) {
        Matcher match = VERSION_STRING_PATTERN.matcher(versionString);
        if (match.find()) {
            return new Version(Byte.parseByte(match.group(1)), Byte.parseByte(match.group(2)), Byte.parseByte(match.group(3)));
        }
        throw new IllegalArgumentException("Invalid version string");
    }
}

