/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UsbDeviceManager {
    private static final String ACTION_USB_PERMISSION = "com.yubico.yubikey.USB_PERMISSION";
    public static final int YUBICO_VENDOR_ID = 4176;
    @Nullable
    private static UsbDeviceManager instance;
    private static final Logger logger;
    private final DeviceBroadcastReceiver broadcastReceiver = new DeviceBroadcastReceiver();
    private final PermissionBroadcastReceiver permissionReceiver = new PermissionBroadcastReceiver();
    private final Set<UsbDeviceListener> deviceListeners = new HashSet<UsbDeviceListener>();
    private final WeakHashMap<UsbDevice, Set<PermissionResultListener>> contexts = new WeakHashMap();
    private final Set<UsbDevice> awaitingPermissions = new HashSet<UsbDevice>();

    UsbDeviceManager() {
    }

    private static synchronized UsbDeviceManager getInstance() {
        if (instance == null) {
            instance = new UsbDeviceManager();
        }
        return instance;
    }

    static void registerUsbListener(Context context, UsbDeviceListener listener) {
        UsbDeviceManager.getInstance().addUsbListener(context, listener);
    }

    static void unregisterUsbListener(Context context, UsbDeviceListener listener) {
        UsbDeviceManager.getInstance().removeUsbListener(context, listener);
    }

    static void requestPermission(Context context, UsbDevice usbDevice, PermissionResultListener listener) {
        UsbDeviceManager.getInstance().requestDevicePermission(context, usbDevice, listener);
    }

    private synchronized void addUsbListener(Context context, UsbDeviceListener listener) {
        if (this.deviceListeners.isEmpty()) {
            UsbManager usbManager = (UsbManager)context.getSystemService("usb");
            Collection usbDevices = usbManager.getDeviceList().values();
            IntentFilter intentFilter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            context.registerReceiver((BroadcastReceiver)this.broadcastReceiver, intentFilter);
            for (UsbDevice usbDevice : usbDevices) {
                if (usbDevice.getVendorId() != 4176) continue;
                this.onDeviceAttach(usbDevice);
            }
        }
        this.deviceListeners.add(listener);
        for (UsbDevice usbDevice : this.contexts.keySet()) {
            listener.deviceAttached(usbDevice);
        }
    }

    private synchronized void removeUsbListener(Context context, UsbDeviceListener listener) {
        this.deviceListeners.remove(listener);
        for (UsbDevice usbDevice : this.contexts.keySet()) {
            listener.deviceRemoved(usbDevice);
        }
        if (this.deviceListeners.isEmpty()) {
            context.unregisterReceiver((BroadcastReceiver)this.broadcastReceiver);
            this.contexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void requestDevicePermission(Context context, UsbDevice usbDevice, PermissionResultListener listener) {
        Set<PermissionResultListener> permissionListeners;
        Set<PermissionResultListener> set = permissionListeners = Objects.requireNonNull(this.contexts.get(usbDevice));
        synchronized (set) {
            permissionListeners.add(listener);
        }
        set = this.awaitingPermissions;
        synchronized (set) {
            if (!this.awaitingPermissions.contains(usbDevice)) {
                if (this.awaitingPermissions.isEmpty()) {
                    UsbDeviceManager.registerPermissionsReceiver(context, this.permissionReceiver);
                }
                com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Requesting permission for UsbDevice: {}", (Object)usbDevice.getDeviceName());
                int flags = 0;
                if (Build.VERSION.SDK_INT >= 31) {
                    flags |= 0x2000000;
                }
                Intent intent = new Intent(ACTION_USB_PERMISSION);
                intent.setPackage(context.getPackageName());
                PendingIntent pendingUsbPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)flags);
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                usbManager.requestPermission(usbDevice, pendingUsbPermissionIntent);
                this.awaitingPermissions.add(usbDevice);
            }
        }
    }

    private void onDeviceAttach(UsbDevice usbDevice) {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"UsbDevice attached: {}", (Object)usbDevice.getDeviceName());
        this.contexts.put(usbDevice, new HashSet());
        for (UsbDeviceListener listener : this.deviceListeners) {
            listener.deviceAttached(usbDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPermission(Context context, UsbDevice usbDevice, boolean permission) {
        Set<PermissionResultListener> set;
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Permission result for {}, permitted: {}", (Object)usbDevice.getDeviceName(), (Object)permission);
        Set<PermissionResultListener> permissionListeners = this.contexts.get(usbDevice);
        if (permissionListeners != null) {
            set = permissionListeners;
            synchronized (set) {
                for (PermissionResultListener listener : permissionListeners) {
                    listener.onPermissionResult(usbDevice, permission);
                }
                permissionListeners.clear();
            }
        }
        set = this.awaitingPermissions;
        synchronized (set) {
            if (this.awaitingPermissions.remove(usbDevice) && this.awaitingPermissions.isEmpty()) {
                context.unregisterReceiver((BroadcastReceiver)this.permissionReceiver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeviceDetach(Context context, UsbDevice usbDevice) {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"UsbDevice detached: {}", (Object)usbDevice.getDeviceName());
        if (this.contexts.remove(usbDevice) != null) {
            for (UsbDeviceListener listener : this.deviceListeners) {
                listener.deviceRemoved(usbDevice);
            }
        }
        Set<UsbDevice> set = this.awaitingPermissions;
        synchronized (set) {
            if (this.awaitingPermissions.remove(usbDevice) && this.awaitingPermissions.isEmpty()) {
                context.unregisterReceiver((BroadcastReceiver)this.permissionReceiver);
            }
        }
    }

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    private static void registerPermissionsReceiver(Context context, PermissionBroadcastReceiver permissionReceiver) {
        if (Build.VERSION.SDK_INT >= 33) {
            context.registerReceiver((BroadcastReceiver)permissionReceiver, new IntentFilter(ACTION_USB_PERMISSION), 4);
        } else {
            context.registerReceiver((BroadcastReceiver)permissionReceiver, new IntentFilter(ACTION_USB_PERMISSION));
        }
    }

    static {
        logger = LoggerFactory.getLogger(UsbDeviceManager.class);
    }

    private class PermissionBroadcastReceiver
    extends BroadcastReceiver {
        private PermissionBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (UsbDeviceManager.ACTION_USB_PERMISSION.equals(intent.getAction())) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                if (device != null) {
                    UsbDeviceManager.this.onPermission(context, device, usbManager.hasPermission(device));
                }
            }
        }
    }

    static interface PermissionResultListener {
        public void onPermissionResult(UsbDevice var1, boolean var2);
    }

    private class DeviceBroadcastReceiver
    extends BroadcastReceiver {
        private DeviceBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
            if (usbDevice == null || usbDevice.getVendorId() != 4176) {
                return;
            }
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                UsbDeviceManager.this.onDeviceAttach(usbDevice);
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                UsbDeviceManager.this.onDeviceDetach(context, usbDevice);
            }
        }
    }

    static interface UsbDeviceListener {
        public void deviceAttached(UsbDevice var1);

        public void deviceRemoved(UsbDevice var1);
    }
}

