/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb.connection;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import com.yubico.yubikit.android.transport.usb.connection.UsbYubiKeyConnection;
import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;

public class UsbSmartCardConnection
extends UsbYubiKeyConnection
implements SmartCardConnection {
    private static final int TIMEOUT = 1000;
    private static final byte POWER_ON_MESSAGE_TYPE = 98;
    private static final byte REQUEST_MESSAGE_TYPE = 111;
    private static final byte RESPONSE_DATA_BLOCK = -128;
    private static final byte STATUS_TIME_EXTENSION = -128;
    private final UsbDeviceConnection connection;
    private final UsbEndpoint endpointOut;
    private final UsbEndpoint endpointIn;
    private final byte[] atr;
    private byte sequence = 0;

    UsbSmartCardConnection(UsbDeviceConnection connection, UsbInterface ccidInterface, UsbEndpoint endpointIn, UsbEndpoint endpointOut) throws IOException {
        super(connection, ccidInterface);
        this.connection = connection;
        this.endpointIn = endpointIn;
        this.endpointOut = endpointOut;
        this.atr = this.transceive((byte)98, new byte[0]);
    }

    public Transport getTransport() {
        return Transport.USB;
    }

    public boolean isExtendedLengthApduSupported() {
        return true;
    }

    public byte[] sendAndReceive(byte[] apdu) throws IOException {
        return this.transceive((byte)111, apdu);
    }

    private byte[] transceive(byte type, byte[] data) throws IOException {
        int bytesRead;
        byte by = this.sequence;
        this.sequence = (byte)(by + 1);
        MessageHeader prefix = new MessageHeader(type, data.length, by);
        ByteBuffer byteBuffer = ByteBuffer.allocate(prefix.size() + data.length).order(ByteOrder.LITTLE_ENDIAN).put(prefix.array()).put(data);
        byte[] bufferOut = byteBuffer.array();
        int bytesSentPackage = 0;
        for (int bytesSent = 0; bytesSent < bufferOut.length || bytesSentPackage == this.endpointOut.getMaxPacketSize(); bytesSent += bytesSentPackage) {
            bytesSentPackage = this.connection.bulkTransfer(this.endpointOut, bufferOut, bytesSent, bufferOut.length - bytesSent, 1000);
            if (bytesSentPackage > 0) {
                Logger.d((String)(bytesSentPackage + " bytes sent over ccid: " + StringUtils.bytesToHex((byte[])bufferOut, (int)bytesSent, (int)bytesSentPackage)));
                continue;
            }
            if (bytesSentPackage >= 0) break;
            throw new IOException("Failed to send " + (bufferOut.length - bytesSent) + " bytes");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MessageHeader messageHeader = null;
        boolean receivedExpectedPrefix = false;
        byte[] bufferRead = new byte[this.endpointIn.getMaxPacketSize()];
        boolean responseRequiresTimeExtension = false;
        do {
            if ((bytesRead = this.connection.bulkTransfer(this.endpointIn, bufferRead, bufferRead.length, 1000)) > 0) {
                Logger.d((String)(bytesRead + " bytes received: " + StringUtils.bytesToHex((byte[])bufferRead, (int)0, (int)bytesRead)));
                if (receivedExpectedPrefix) {
                    stream.write(bufferRead, 0, bytesRead);
                    continue;
                }
                messageHeader = new MessageHeader(bufferRead);
                boolean bl = responseRequiresTimeExtension = (messageHeader.status & 0xFFFFFF80) == -128;
                if (messageHeader.verify((byte)(this.sequence - 1))) {
                    receivedExpectedPrefix = true;
                    stream.write(bufferRead, 0, bytesRead);
                    continue;
                }
                if (messageHeader.error == 0 || responseRequiresTimeExtension) continue;
                Logger.d((String)String.format(Locale.ROOT, "Invalid response from card reader bStatus=0x%02X and bError=0x%02X", messageHeader.status, messageHeader.error));
                throw new IOException("Invalid response from card reader");
            }
            if (bytesRead >= 0) continue;
            throw new IOException("Failed to read response");
        } while (bytesRead > 0 && bytesRead == bufferRead.length || responseRequiresTimeExtension);
        byte[] output = stream.toByteArray();
        if (messageHeader == null || output.length < messageHeader.size()) {
            throw new IOException("Response is invalid");
        }
        int dataLength = Math.min(output.length - messageHeader.size(), messageHeader.dataLength);
        return Arrays.copyOfRange(output, messageHeader.size(), messageHeader.size() + dataLength);
    }

    private static class MessageHeader {
        private static final int SIZE_OF_CCID_PREFIX = 10;
        private static final byte[] MESSAGE_SPECIFIC_BYTES = new byte[]{0, 0, 0};
        private static final byte SLOT_NUMBER = 0;
        private byte type;
        private int dataLength;
        private byte slot;
        private byte sequence;
        private byte status;
        private byte error;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        private byte messageSpecificByte;

        private MessageHeader(byte[] buffer) {
            if (buffer.length > 10) {
                ByteBuffer responseBuffer = ByteBuffer.wrap(buffer, 0, 10).order(ByteOrder.LITTLE_ENDIAN);
                this.type = responseBuffer.get();
                this.dataLength = responseBuffer.getInt();
                this.slot = responseBuffer.get();
                this.sequence = responseBuffer.get();
                this.status = responseBuffer.get();
                this.error = responseBuffer.get();
                this.messageSpecificByte = responseBuffer.get();
            }
        }

        private MessageHeader(byte type, int length, byte sequence) {
            this.type = type;
            this.dataLength = length;
            this.slot = 0;
            this.sequence = sequence;
        }

        private byte[] array() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN).put(this.type).putInt(this.dataLength).put(this.slot).put(this.sequence).put(MESSAGE_SPECIFIC_BYTES);
            return byteBuffer.array();
        }

        private int size() {
            return 10;
        }

        private boolean verify(byte sequence) {
            if (this.type != -128) {
                return false;
            }
            if (this.slot != 0) {
                return false;
            }
            if (this.sequence != sequence) {
                return false;
            }
            return this.status == 0;
        }
    }
}

