/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import com.yubico.yubikit.core.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

final class UsbDeviceManager {
    private static final String ACTION_USB_PERMISSION = "com.yubico.yubikey.USB_PERMISSION";
    public static final int YUBICO_VENDOR_ID = 4176;
    @Nullable
    private static UsbDeviceManager instance;
    private final DeviceBroadcastReceiver broadcastReceiver = new DeviceBroadcastReceiver();
    private final PermissionBroadcastReceiver permissionReceiver = new PermissionBroadcastReceiver();
    private final Set<UsbDeviceListener> deviceListeners = new HashSet<UsbDeviceListener>();
    private final WeakHashMap<UsbDevice, Set<PermissionResultListener>> contexts = new WeakHashMap();
    private final Set<UsbDevice> awaitingPermissions = new HashSet<UsbDevice>();

    UsbDeviceManager() {
    }

    private static synchronized UsbDeviceManager getInstance() {
        if (instance == null) {
            instance = new UsbDeviceManager();
        }
        return instance;
    }

    static void registerUsbListener(Context context, UsbDeviceListener listener) {
        UsbDeviceManager.getInstance().addUsbListener(context, listener);
    }

    static void unregisterUsbListener(Context context, UsbDeviceListener listener) {
        UsbDeviceManager.getInstance().removeUsbListener(context, listener);
    }

    static void requestPermission(Context context, UsbDevice usbDevice, PermissionResultListener listener) {
        UsbDeviceManager.getInstance().requestDevicePermission(context, usbDevice, listener);
    }

    private synchronized void addUsbListener(Context context, UsbDeviceListener listener) {
        if (this.deviceListeners.isEmpty()) {
            UsbManager usbManager = (UsbManager)context.getSystemService("usb");
            Collection usbDevices = usbManager.getDeviceList().values();
            IntentFilter intentFilter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            context.registerReceiver((BroadcastReceiver)this.broadcastReceiver, intentFilter);
            for (UsbDevice usbDevice : usbDevices) {
                if (usbDevice.getVendorId() != 4176) continue;
                this.onDeviceAttach(usbDevice);
            }
        }
        this.deviceListeners.add(listener);
        for (UsbDevice usbDevice : this.contexts.keySet()) {
            listener.deviceAttached(usbDevice);
        }
    }

    private synchronized void removeUsbListener(Context context, UsbDeviceListener listener) {
        this.deviceListeners.remove(listener);
        for (UsbDevice usbDevice : this.contexts.keySet()) {
            listener.deviceRemoved(usbDevice);
        }
        if (this.deviceListeners.isEmpty()) {
            context.unregisterReceiver((BroadcastReceiver)this.broadcastReceiver);
            this.contexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void requestDevicePermission(Context context, UsbDevice usbDevice, PermissionResultListener listener) {
        Set<PermissionResultListener> permissionListeners;
        Set<PermissionResultListener> set = permissionListeners = Objects.requireNonNull(this.contexts.get(usbDevice));
        synchronized (set) {
            permissionListeners.add(listener);
        }
        set = this.awaitingPermissions;
        synchronized (set) {
            if (!this.awaitingPermissions.contains(usbDevice)) {
                if (this.awaitingPermissions.isEmpty()) {
                    context.registerReceiver((BroadcastReceiver)this.permissionReceiver, new IntentFilter(ACTION_USB_PERMISSION));
                }
                Logger.d((String)("Requesting permission for UsbDevice: " + usbDevice.getDeviceName()));
                int flags = 0;
                if (Build.VERSION.SDK_INT >= 31) {
                    flags |= 0x2000000;
                }
                PendingIntent pendingUsbPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)flags);
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                usbManager.requestPermission(usbDevice, pendingUsbPermissionIntent);
                this.awaitingPermissions.add(usbDevice);
            }
        }
    }

    private void onDeviceAttach(UsbDevice usbDevice) {
        Logger.d((String)("UsbDevice attached: " + usbDevice.getDeviceName()));
        this.contexts.put(usbDevice, new HashSet());
        for (UsbDeviceListener listener : this.deviceListeners) {
            listener.deviceAttached(usbDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPermission(Context context, UsbDevice usbDevice, boolean permission) {
        Set<PermissionResultListener> set;
        Logger.d((String)("Permission result for " + usbDevice.getDeviceName() + ", permitted: " + permission));
        Set<PermissionResultListener> permissionListeners = this.contexts.get(usbDevice);
        if (permissionListeners != null) {
            set = permissionListeners;
            synchronized (set) {
                for (PermissionResultListener listener : permissionListeners) {
                    listener.onPermissionResult(usbDevice, permission);
                }
                permissionListeners.clear();
            }
        }
        set = this.awaitingPermissions;
        synchronized (set) {
            if (this.awaitingPermissions.remove(usbDevice) && this.awaitingPermissions.isEmpty()) {
                context.unregisterReceiver((BroadcastReceiver)this.permissionReceiver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeviceDetach(Context context, UsbDevice usbDevice) {
        Logger.d((String)("UsbDevice detached: " + usbDevice.getDeviceName()));
        if (this.contexts.remove(usbDevice) != null) {
            for (UsbDeviceListener listener : this.deviceListeners) {
                listener.deviceRemoved(usbDevice);
            }
        }
        Set<UsbDevice> set = this.awaitingPermissions;
        synchronized (set) {
            if (this.awaitingPermissions.remove(usbDevice) && this.awaitingPermissions.isEmpty()) {
                context.unregisterReceiver((BroadcastReceiver)this.permissionReceiver);
            }
        }
    }

    private class PermissionBroadcastReceiver
    extends BroadcastReceiver {
        private PermissionBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (UsbDeviceManager.ACTION_USB_PERMISSION.equals(intent.getAction())) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                if (device != null) {
                    UsbDeviceManager.this.onPermission(context, device, usbManager.hasPermission(device));
                }
            }
        }
    }

    static interface PermissionResultListener {
        public void onPermissionResult(UsbDevice var1, boolean var2);
    }

    private class DeviceBroadcastReceiver
    extends BroadcastReceiver {
        private DeviceBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
            if (usbDevice == null || usbDevice.getVendorId() != 4176) {
                return;
            }
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                UsbDeviceManager.this.onDeviceAttach(usbDevice);
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                UsbDeviceManager.this.onDeviceDetach(context, usbDevice);
            }
        }
    }

    static interface UsbDeviceListener {
        public void deviceAttached(UsbDevice var1);

        public void deviceRemoved(UsbDevice var1);
    }
}

