/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2;

import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.Version;
import com.yubico.client.v2.exceptions.YubicoValidationFailure;
import com.yubico.client.v2.exceptions.YubicoVerificationException;
import com.yubico.client.v2.impl.YubicoClientImpl;
import org.apache.commons.codec.binary.Base64;

public abstract class YubicoClient {
    protected Integer clientId;
    protected byte[] key;
    protected Integer sync;
    protected String[] wsapi_urls = new String[]{"https://api.yubico.com/wsapi/2.0/verify", "https://api2.yubico.com/wsapi/2.0/verify", "https://api3.yubico.com/wsapi/2.0/verify", "https://api4.yubico.com/wsapi/2.0/verify", "https://api5.yubico.com/wsapi/2.0/verify"};
    protected String userAgent = "yubico-java-client/" + Version.version + " (" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + ")";
    private static final Integer OTP_MIN_LEN = 32;
    private static final Integer OTP_MAX_LEN = 48;

    public abstract VerificationResponse verify(String var1) throws YubicoVerificationException, YubicoValidationFailure;

    public Integer getClientId() {
        return this.clientId;
    }

    public void setClientId(Integer clientId) {
        this.clientId = clientId;
    }

    public void setKey(String key) {
        this.key = Base64.decodeBase64((byte[])key.getBytes());
    }

    public String getKey() {
        return new String(Base64.encodeBase64((byte[])this.key));
    }

    public void setSync(Integer sync) {
        this.sync = sync;
    }

    public String[] getWsapiUrls() {
        return this.wsapi_urls;
    }

    public void setWsapiUrls(String[] wsapi) {
        this.wsapi_urls = wsapi;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public static YubicoClient getClient(Integer clientId, String key) {
        return new YubicoClientImpl(clientId, key);
    }

    public static String getPublicId(String otp) {
        if (otp == null || otp.length() < OTP_MIN_LEN) {
            throw new IllegalArgumentException("The OTP is too short to be valid");
        }
        Integer len = otp.length();
        return otp.substring(0, len - 32).toLowerCase();
    }

    public static boolean isValidOTPFormat(String otp) {
        if (otp == null) {
            return false;
        }
        int len = otp.length();
        for (char c : otp.toCharArray()) {
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return OTP_MIN_LEN <= len && len <= OTP_MAX_LEN;
    }
}

