/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialEntity;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class UserIdentity
implements PublicKeyCredentialEntity {
    @NonNull
    private final String name;
    @NonNull
    private final String displayName;
    @NonNull
    private final ByteArray id;
    private final URL icon;

    @JsonCreator
    private UserIdentity(@JsonProperty(value="name") @NonNull String name, @JsonProperty(value="displayName") @NonNull String displayName, @JsonProperty(value="id") @NonNull ByteArray id, @JsonProperty(value="icon") URL icon) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.name = name;
        this.displayName = displayName;
        this.id = id;
        this.icon = icon;
    }

    public static UserIdentityBuilder.MandatoryStages builder() {
        return new UserIdentityBuilder.MandatoryStages();
    }

    @Override
    public Optional<URL> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    @Generated
    public UserIdentityBuilder toBuilder() {
        return new UserIdentityBuilder().name(this.name).displayName(this.displayName).id(this.id).icon(this.icon);
    }

    @NonNull
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @NonNull
    @Generated
    public ByteArray getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ByteArray this$id = this.getId();
        ByteArray other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Optional<URL> this$icon = this.getIcon();
        Optional<URL> other$icon = other.getIcon();
        return !(this$icon == null ? other$icon != null : !((Object)this$icon).equals(other$icon));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ByteArray $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Optional<URL> $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : ((Object)$icon).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserIdentity(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", id=" + this.getId() + ", icon=" + this.getIcon() + ")";
    }

    @Override
    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    public static class UserIdentityBuilder {
        @Generated
        private String name;
        @Generated
        private String displayName;
        @Generated
        private ByteArray id;
        private URL icon = null;

        public UserIdentityBuilder icon(@NonNull Optional<URL> icon) {
            if (icon == null) {
                throw new NullPointerException("icon is marked non-null but is null");
            }
            return this.icon((URL)icon.orElse(null));
        }

        public UserIdentityBuilder icon(URL icon) {
            this.icon = icon;
            return this;
        }

        @Generated
        UserIdentityBuilder() {
        }

        @Generated
        public UserIdentityBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public UserIdentityBuilder displayName(@NonNull String displayName) {
            if (displayName == null) {
                throw new NullPointerException("displayName is marked non-null but is null");
            }
            this.displayName = displayName;
            return this;
        }

        @Generated
        public UserIdentityBuilder id(@NonNull ByteArray id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public UserIdentity build() {
            return new UserIdentity(this.name, this.displayName, this.id, this.icon);
        }

        @Generated
        public String toString() {
            return "UserIdentity.UserIdentityBuilder(name=" + this.name + ", displayName=" + this.displayName + ", id=" + this.id + ", icon=" + this.icon + ")";
        }

        public static class MandatoryStages {
            private UserIdentityBuilder builder = new UserIdentityBuilder();

            public Step2 name(String name) {
                this.builder.name(name);
                return new Step2();
            }

            public class Step3 {
                public UserIdentityBuilder id(ByteArray id) {
                    return MandatoryStages.this.builder.id(id);
                }
            }

            public class Step2 {
                public Step3 displayName(String displayName) {
                    MandatoryStages.this.builder.displayName(displayName);
                    return new Step3();
                }
            }
        }
    }
}

