/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.Utf8;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.util.Iso639;
import com.mp4parser.iso14496.part30.XMLSubtitleSampleEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMPTETTTrackImpl
extends AbstractTrack {
    public static final String SMPTE_TT_NAMESPACE = "http://www.smpte-ra.org/schemas/2052-1/2010/smpte-tt";
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox sampleDescriptionBox = new SampleDescriptionBox();
    XMLSubtitleSampleEntry XMLSubtitleSampleEntry = new XMLSubtitleSampleEntry();
    List<Sample> samples = new ArrayList<Sample>();
    SubSampleInformationBox subSampleInformationBox = new SubSampleInformationBox();
    boolean containsImages;
    private long[] sampleDurations;

    static long toTime(String expr) {
        Pattern p = Pattern.compile("([0-9][0-9]):([0-9][0-9]):([0-9][0-9])([\\.:][0-9][0-9]?[0-9]?)?");
        Matcher m = p.matcher(expr);
        if (m.matches()) {
            String hours = m.group(1);
            String minutes = m.group(2);
            String seconds = m.group(3);
            String fraction = m.group(4);
            if (fraction == null) {
                fraction = ".000";
            }
            fraction = fraction.replace(":", ".");
            long ms = Long.parseLong(hours) * 60L * 60L * 1000L;
            ms += Long.parseLong(minutes) * 60L * 1000L;
            ms += Long.parseLong(seconds) * 1000L;
            ms = (long)((double)ms + Double.parseDouble("0" + fraction) * 1000.0);
            return ms;
        }
        throw new RuntimeException("Cannot match " + expr + " to time expression");
    }

    public static String getLanguage(Document document) {
        return document.getDocumentElement().getAttribute("xml:lang");
    }

    public static long earliestTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        TextTrackNamespaceContext ctx = new TextTrackNamespaceContext();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(ctx);
        try {
            XPathExpression timedNodesXpath = xpath.compile("//*[@begin]");
            NodeList timedNodes = (NodeList)timedNodesXpath.evaluate(document, XPathConstants.NODESET);
            long earliestTimestamp = 0L;
            int i = 0;
            while (i < timedNodes.getLength()) {
                Node n = timedNodes.item(i);
                String begin = n.getAttributes().getNamedItem("begin").getNodeValue();
                earliestTimestamp = Math.min(SMPTETTTrackImpl.toTime(begin), earliestTimestamp);
                ++i;
            }
            return earliestTimestamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static long latestTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        TextTrackNamespaceContext ctx = new TextTrackNamespaceContext();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(ctx);
        try {
            XPathExpression timedNodesXpath = xpath.compile("//*[@begin]");
            NodeList timedNodes = (NodeList)timedNodesXpath.evaluate(document, XPathConstants.NODESET);
            long lastTimeStamp = 0L;
            int i = 0;
            while (i < timedNodes.getLength()) {
                long end;
                Node n = timedNodes.item(i);
                String begin = n.getAttributes().getNamedItem("begin").getNodeValue();
                if (n.getAttributes().getNamedItem("dur") != null) {
                    end = SMPTETTTrackImpl.toTime(begin) + SMPTETTTrackImpl.toTime(n.getAttributes().getNamedItem("dur").getNodeValue());
                } else if (n.getAttributes().getNamedItem("end") != null) {
                    end = SMPTETTTrackImpl.toTime(n.getAttributes().getNamedItem("end").getNodeValue());
                } else {
                    throw new RuntimeException("neither end nor dur attribute is present");
                }
                lastTimeStamp = Math.max(end, lastTimeStamp);
                ++i;
            }
            return lastTimeStamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public SMPTETTTrackImpl(File ... files) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        super(files[0].getName());
        this.sampleDurations = new long[files.length];
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        long startTime = 0L;
        String firstLang = null;
        int sampleNo = 0;
        while (sampleNo < files.length) {
            final File file = files[sampleNo];
            SubSampleInformationBox.SubSampleEntry subSampleEntry = new SubSampleInformationBox.SubSampleEntry();
            this.subSampleInformationBox.getEntries().add(subSampleEntry);
            subSampleEntry.setSampleDelta(1L);
            Document doc = dBuilder.parse(file);
            String lang = SMPTETTTrackImpl.getLanguage(doc);
            if (firstLang == null) {
                firstLang = lang;
            } else if (!firstLang.equals(lang)) {
                throw new RuntimeException("Within one Track all sample documents need to have the same language");
            }
            XPathFactory xPathfactory = XPathFactory.newInstance();
            TextTrackNamespaceContext ctx = new TextTrackNamespaceContext();
            XPath xpath = xPathfactory.newXPath();
            xpath.setNamespaceContext(ctx);
            long lastTimeStamp = SMPTETTTrackImpl.latestTimestamp(doc);
            this.sampleDurations[sampleNo] = lastTimeStamp - startTime;
            startTime = lastTimeStamp;
            XPathExpression expr = xpath.compile("/ttml:tt/ttml:body/ttml:div/@smpte:backgroundImage");
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            HashMap<String, String> internalName2Original = new HashMap<String, String>();
            AbstractCollection originalNames = new HashSet<String>();
            int i = 0;
            while (i < nl.getLength()) {
                originalNames.add(nl.item(i).getNodeValue());
                ++i;
            }
            originalNames = new ArrayList(originalNames);
            Collections.sort((List)((Object)originalNames));
            int p = 1;
            for (String originalName : originalNames) {
                String ext = originalName.substring(originalName.lastIndexOf("."));
                internalName2Original.put(originalName, "urn:dece:container:subtitleimageindex:" + p++ + (String)ext);
            }
            if (!originalNames.isEmpty()) {
                String xml = new String(this.streamToByteArray(new FileInputStream(file)));
                for (Map.Entry entry : internalName2Original.entrySet()) {
                    xml = xml.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                final String string = xml;
                final ArrayList<File> pix = new ArrayList<File>();
                this.samples.add(new Sample(){

                    public void writeTo(WritableByteChannel channel) throws IOException {
                        channel.write(ByteBuffer.wrap(Utf8.convert(string)));
                        for (File file1 : pix) {
                            FileInputStream fis = new FileInputStream(file1);
                            byte[] buffer = new byte[8096];
                            int n = 0;
                            while (-1 != (n = fis.read(buffer))) {
                                channel.write(ByteBuffer.wrap(buffer, 0, n));
                            }
                        }
                    }

                    public long getSize() {
                        long l = Utf8.convert(string).length;
                        for (File file1 : pix) {
                            l += file1.length();
                        }
                        return l;
                    }

                    public ByteBuffer asByteBuffer() {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            this.writeTo(Channels.newChannel(baos));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return ByteBuffer.wrap(baos.toByteArray());
                    }
                });
                SubSampleInformationBox.SubSampleEntry.SubsampleEntry xmlEntry = new SubSampleInformationBox.SubSampleEntry.SubsampleEntry();
                xmlEntry.setSubsampleSize(Utf8.utf8StringLengthInBytes(string));
                subSampleEntry.getSubsampleEntries().add(xmlEntry);
                for (String originalName : originalNames) {
                    File pic = new File(file.getParentFile(), originalName);
                    pix.add(pic);
                    SubSampleInformationBox.SubSampleEntry.SubsampleEntry sse = new SubSampleInformationBox.SubSampleEntry.SubsampleEntry();
                    sse.setSubsampleSize(pic.length());
                    subSampleEntry.getSubsampleEntries().add(sse);
                }
            } else {
                this.samples.add(new Sample(){

                    public void writeTo(WritableByteChannel channel) throws IOException {
                        Channels.newOutputStream(channel).write(SMPTETTTrackImpl.this.streamToByteArray(new FileInputStream(file)));
                    }

                    public long getSize() {
                        return file.length();
                    }

                    public ByteBuffer asByteBuffer() {
                        try {
                            return ByteBuffer.wrap(SMPTETTTrackImpl.this.streamToByteArray(new FileInputStream(file)));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            ++sampleNo;
        }
        this.trackMetaData.setLanguage(Iso639.convert2to3(firstLang));
        this.XMLSubtitleSampleEntry.setNamespace(SMPTE_TT_NAMESPACE);
        this.XMLSubtitleSampleEntry.setSchemaLocation(SMPTE_TT_NAMESPACE);
        if (this.containsImages) {
            this.XMLSubtitleSampleEntry.setAuxiliaryMimeTypes("image/png");
        } else {
            this.XMLSubtitleSampleEntry.setAuxiliaryMimeTypes("");
        }
        this.sampleDescriptionBox.addBox(this.XMLSubtitleSampleEntry);
        this.trackMetaData.setTimescale(30000L);
        this.trackMetaData.setLayer(65535);
    }

    private byte[] streamToByteArray(InputStream input) throws IOException {
        byte[] buffer = new byte[8096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public long[] getSampleDurations() {
        long[] adoptedSampleDuration = new long[this.sampleDurations.length];
        int i = 0;
        while (i < adoptedSampleDuration.length) {
            adoptedSampleDuration[i] = this.sampleDurations[i] * this.trackMetaData.getTimescale() / 1000L;
            ++i;
        }
        return adoptedSampleDuration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "subt";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.subSampleInformationBox;
    }

    @Override
    public void close() throws IOException {
    }

    private static class TextTrackNamespaceContext
    implements NamespaceContext {
        private TextTrackNamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            if (prefix.equals("ttml")) {
                return "http://www.w3.org/ns/ttml";
            }
            if (prefix.equals("smpte")) {
                return SMPTETTTrackImpl.SMPTE_TT_NAMESPACE;
            }
            return null;
        }

        public Iterator getPrefixes(String val) {
            return Arrays.asList("ttml", "smpte").iterator();
        }

        public String getPrefix(String uri) {
            if (uri.equals("http://www.w3.org/ns/ttml")) {
                return "ttml";
            }
            if (uri.equals(SMPTETTTrackImpl.SMPTE_TT_NAMESPACE)) {
                return "smpte";
            }
            return null;
        }
    }
}

