/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.samples;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentedMp4SampleList
extends AbstractList<Sample> {
    Container topLevel;
    IsoFile[] fragments;
    TrackBox trackBox = null;
    TrackExtendsBox trex = null;
    private SoftReference<Sample>[] sampleCache;
    private List<TrackFragmentBox> allTrafs;
    private Map<TrackRunBox, SoftReference<ByteBuffer>> trunDataCache = new HashMap<TrackRunBox, SoftReference<ByteBuffer>>();
    private int[] firstSamples;
    private int size_ = -1;

    public FragmentedMp4SampleList(long track, Container topLevel, IsoFile ... fragments) {
        this.topLevel = topLevel;
        this.fragments = fragments;
        List<TrackBox> tbs = Path.getPaths(topLevel, "moov[0]/trak");
        for (TrackBox tb : tbs) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
        List<TrackExtendsBox> trexs = Path.getPaths(topLevel, "moov[0]/mvex[0]/trex");
        for (TrackExtendsBox box : trexs) {
            if (box.getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
            this.trex = box;
        }
        this.sampleCache = (SoftReference[])Array.newInstance(SoftReference.class, this.size());
        this.initAllFragments();
    }

    private List<TrackFragmentBox> initAllFragments() {
        if (this.allTrafs != null) {
            return this.allTrafs;
        }
        ArrayList<TrackFragmentBox> trafs = new ArrayList<TrackFragmentBox>();
        for (MovieFragmentBox moof : this.topLevel.getBoxes(MovieFragmentBox.class)) {
            for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                trafs.add(trackFragmentBox);
            }
        }
        if (this.fragments != null) {
            IsoFile[] isoFileArray = this.fragments;
            int n = this.fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Object fragment = isoFileArray[n2];
                for (MovieFragmentBox moof : ((BasicContainer)fragment).getBoxes(MovieFragmentBox.class)) {
                    for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                        if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                        trafs.add(trackFragmentBox);
                    }
                }
                ++n2;
            }
        }
        this.allTrafs = trafs;
        int firstSample = 1;
        this.firstSamples = new int[this.allTrafs.size()];
        int i = 0;
        while (i < this.allTrafs.size()) {
            this.firstSamples[i] = firstSample;
            firstSample += this.getTrafSize(this.allTrafs.get(i));
            ++i;
        }
        return trafs;
    }

    private int getTrafSize(TrackFragmentBox traf) {
        List<Box> boxes = traf.getBoxes();
        int size = 0;
        int i = 0;
        while (i < boxes.size()) {
            Box b = boxes.get(i);
            if (b instanceof TrackRunBox) {
                size += CastUtils.l2i(((TrackRunBox)b).getSampleCount());
            }
            ++i;
        }
        return size;
    }

    @Override
    public Sample get(int index) {
        Sample cachedSample;
        if (this.sampleCache[index] != null && (cachedSample = this.sampleCache[index].get()) != null) {
            return cachedSample;
        }
        int targetIndex = index + 1;
        int j = this.firstSamples.length - 1;
        while (targetIndex - this.firstSamples[j] < 0) {
            --j;
        }
        TrackFragmentBox trackFragmentBox = this.allTrafs.get(j);
        int sampleIndexWithInTraf = targetIndex - this.firstSamples[j];
        int previousTrunsSize = 0;
        MovieFragmentBox moof = (MovieFragmentBox)trackFragmentBox.getParent();
        for (Box box : trackFragmentBox.getBoxes()) {
            SoftReference<ByteBuffer> trunDataRef;
            ByteBuffer trunData;
            if (!(box instanceof TrackRunBox)) continue;
            TrackRunBox trun = (TrackRunBox)box;
            if (trun.getEntries().size() < sampleIndexWithInTraf - previousTrunsSize) {
                previousTrunsSize += trun.getEntries().size();
                continue;
            }
            List<TrackRunBox.Entry> trackRunEntries = trun.getEntries();
            TrackFragmentHeaderBox tfhd = trackFragmentBox.getTrackFragmentHeaderBox();
            boolean sampleSizePresent = trun.isSampleSizePresent();
            boolean hasDefaultSampleSize = tfhd.hasDefaultSampleSize();
            long defaultSampleSize = 0L;
            if (!sampleSizePresent) {
                if (hasDefaultSampleSize) {
                    defaultSampleSize = tfhd.getDefaultSampleSize();
                } else {
                    if (this.trex == null) {
                        throw new RuntimeException("File doesn't contain trex box but track fragments aren't fully self contained. Cannot determine sample size.");
                    }
                    defaultSampleSize = this.trex.getDefaultSampleSize();
                }
            }
            ByteBuffer byteBuffer = trunData = (trunDataRef = this.trunDataCache.get(trun)) != null ? trunDataRef.get() : null;
            if (trunData == null) {
                Container base;
                long offset = 0L;
                if (tfhd.hasBaseDataOffset()) {
                    offset += tfhd.getBaseDataOffset();
                    base = moof.getParent();
                } else {
                    base = moof;
                }
                if (trun.isDataOffsetPresent()) {
                    offset += (long)trun.getDataOffset();
                }
                int size = 0;
                for (TrackRunBox.Entry e : trackRunEntries) {
                    size = sampleSizePresent ? (int)((long)size + e.getSampleSize()) : (int)((long)size + defaultSampleSize);
                }
                try {
                    trunData = base.getByteBuffer(offset, size);
                    this.trunDataCache.put(trun, new SoftReference<ByteBuffer>(trunData));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            int offset = 0;
            int i = 0;
            while (i < sampleIndexWithInTraf - previousTrunsSize) {
                offset = sampleSizePresent ? (int)((long)offset + trackRunEntries.get(i).getSampleSize()) : (int)((long)offset + defaultSampleSize);
                ++i;
            }
            final long sampleSize = sampleSizePresent ? trackRunEntries.get(sampleIndexWithInTraf - previousTrunsSize).getSampleSize() : defaultSampleSize;
            final ByteBuffer finalTrunData = trunData;
            final int finalOffset = offset;
            Sample sample = new Sample(){

                public void writeTo(WritableByteChannel channel) throws IOException {
                    channel.write(this.asByteBuffer());
                }

                public long getSize() {
                    return sampleSize;
                }

                public ByteBuffer asByteBuffer() {
                    return (ByteBuffer)((ByteBuffer)finalTrunData.position(finalOffset)).slice().limit(CastUtils.l2i(sampleSize));
                }
            };
            this.sampleCache[index] = new SoftReference<1>(sample);
            return sample;
        }
        throw new RuntimeException("Couldn't find sample in the traf I was looking");
    }

    @Override
    public int size() {
        if (this.size_ != -1) {
            return this.size_;
        }
        int i = 0;
        for (MovieFragmentBox moof : this.topLevel.getBoxes(MovieFragmentBox.class)) {
            for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                i = (int)((long)i + trackFragmentBox.getBoxes(TrackRunBox.class).get(0).getSampleCount());
            }
        }
        IsoFile[] isoFileArray = this.fragments;
        int n = this.fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Object fragment = isoFileArray[n2];
            for (MovieFragmentBox moof : ((BasicContainer)fragment).getBoxes(MovieFragmentBox.class)) {
                for (TrackFragmentBox trackFragmentBox : moof.getBoxes(TrackFragmentBox.class)) {
                    if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != this.trackBox.getTrackHeaderBox().getTrackId()) continue;
                    i = (int)((long)i + trackFragmentBox.getBoxes(TrackRunBox.class).get(0).getSampleCount());
                }
            }
            ++n2;
        }
        this.size_ = i;
        return i;
    }
}

