/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.webkit.WebView;
import androidx.annotation.RequiresApi;

public class SnakeWebView
extends WebView {
    private GestureDetector mGestureDetector;
    private DragMode mDragMode = DragMode.BOTH;
    private OnDragListener onDragListener;
    private float mMinVelocity = 2000.0f;
    private boolean isPause;

    public SnakeWebView(Context context) {
        super(context);
        this.init(context);
    }

    public SnakeWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SnakeWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @RequiresApi(api=21)
    public SnakeWebView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public SnakeWebView(Context context, AttributeSet attrs, int defStyleAttr, boolean privateBrowsing) {
        super(context, attrs, defStyleAttr, privateBrowsing);
        this.init(context);
    }

    private void init(Context context) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (SnakeWebView.this.needIntercept(velocityX, velocityY)) {
                    if (null != SnakeWebView.this.onDragListener) {
                        SnakeWebView.this.onDragListener.onFling(velocityX, SnakeWebView.this.mDragMode);
                    }
                    if (velocityX > 0.0f) {
                        if (SnakeWebView.this.canGoBack()) {
                            SnakeWebView.this.goBack();
                        }
                    } else if (SnakeWebView.this.canGoForward()) {
                        SnakeWebView.this.goForward();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private boolean needIntercept(float velocityX, float velocityY) {
        if (Math.abs(velocityX) > Math.abs(velocityY) && Math.abs(velocityX) > this.mMinVelocity && !this.isPause) {
            if (DragMode.BOTH == this.mDragMode) {
                return true;
            }
            if (DragMode.LEFT == this.mDragMode && velocityX < 0.0f) {
                return true;
            }
            if (DragMode.RIGHT == this.mDragMode && velocityX > 0.0f) {
                return true;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mGestureDetector.onTouchEvent(event)) {
            return super.onTouchEvent(event);
        }
        return true;
    }

    public void setMinVelocity(float minVelocity) {
    }

    public void setDragMode(DragMode mode) {
        this.mDragMode = mode;
    }

    public void setOnDragListener(OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
    }

    public void pauseDragging() {
        this.isPause = true;
    }

    public void resumeDragging() {
        this.isPause = false;
    }

    public static interface OnDragListener {
        public void onFling(float var1, DragMode var2);
    }

    public static enum DragMode {
        LEFT,
        RIGHT,
        BOTH,
        NONE;

    }
}

