/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.youngfeng.snake.Snake;
import com.youngfeng.snake.config.SnakeConfigException;
import com.youngfeng.snake.util.Logger;
import com.youngfeng.snake.util.SwipeUpGestureDispatcher;
import com.youngfeng.snake.util.Utils;
import com.youngfeng.snake.view.SnakeTouchInterceptor;
import com.youngfeng.snake.view.SnakeUIConfig;
import java.util.ArrayList;
import java.util.List;

public class SnakeHackLayout
extends FrameLayout {
    private ViewDragHelper mViewDragHelper;
    private OnEdgeDragListener onEdgeDragListener;
    private List<Snake.OnDragListener> onDragListeners = new ArrayList<Snake.OnDragListener>();
    private final int DEFALT_RELEASE_FACTOR = 3;
    private int mReleaseFactor = 3;
    private int mXRange;
    private PointF mOriginPoint = new PointF(0.0f, 0.0f);
    private OnReleaseStateListener onReleaseStateListener;
    private boolean mAllowDragChildView = true;
    private GradientDrawable mShadowDrawable;
    public static final int DEFAULT_SHADOW_START_COLOR = Color.parseColor((String)"#00000000");
    public static final int DEFAULT_SHADOW_END_COLOR = Color.parseColor((String)"#50000000");
    private int mShadowStartColor = DEFAULT_SHADOW_START_COLOR;
    private int mShadowEndColor = DEFAULT_SHADOW_END_COLOR;
    private int mShadowWidth = (int)Utils.dp2px(this.getContext(), 15.0f);
    private boolean isSettling = false;
    private boolean ignoreDragEvent = false;
    private boolean onlyListenToFastSwipe = false;
    private boolean hideShadowOfEdge = false;
    private SnakeTouchInterceptor mCustomTouchInterceptor;
    private int mContentViewLeft;
    private int mContentViewTop;
    private boolean isInLayout = false;
    private float fractionX = 0.0f;
    private boolean mSwipeUpToHomeEnabled = false;
    private ViewTreeObserver.OnPreDrawListener mPreDrawListener = null;
    private SwipeUpGestureDispatcher mSwipeUpGestureDispatcher;
    private DragInterceptor mDragInterceptor;
    private int mInterceptScene = -1;
    private SnakeUIConfig mUIConfig = SnakeUIConfig.get();

    public SnakeHackLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SnakeHackLayout(@NonNull Context context) {
        this(context, null);
    }

    private void init(Context context) {
        this.mViewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)new ViewDragHelper.Callback(){

            public boolean tryCaptureView(View child, int pointerId) {
                if (null != SnakeHackLayout.this.mDragInterceptor) {
                    SnakeHackLayout.this.mInterceptScene = SnakeHackLayout.this.mDragInterceptor.intercept(SnakeHackLayout.this, child, pointerId);
                }
                return !SnakeHackLayout.this.ignoreDragEvent && SnakeHackLayout.this.mViewDragHelper.getViewDragState() == 0;
            }

            public void onEdgeTouched(int edgeFlags, int pointerId) {
                if (SnakeHackLayout.this.ignoreDragEvent) {
                    return;
                }
                if (null != SnakeHackLayout.this.onEdgeDragListener) {
                    SnakeHackLayout.this.onEdgeDragListener.onDragStart(SnakeHackLayout.this);
                }
                for (Snake.OnDragListener onDragListener : SnakeHackLayout.this.onDragListeners) {
                    View childView = null;
                    if (SnakeHackLayout.this.getChildCount() > 0) {
                        childView = SnakeHackLayout.this.getChildAt(0);
                    }
                    onDragListener.onDragStart(childView);
                }
            }

            public int getViewHorizontalDragRange(View child) {
                return SnakeHackLayout.this.mXRange;
            }

            public int getViewVerticalDragRange(View child) {
                return 0;
            }

            public int clampViewPositionHorizontal(View child, int left, int dx) {
                if (null != SnakeHackLayout.this.mDragInterceptor) {
                    SnakeHackLayout.this.mInterceptScene = SnakeHackLayout.this.mDragInterceptor.intercept(SnakeHackLayout.this, child, 0);
                }
                if ((float)left < ((SnakeHackLayout)SnakeHackLayout.this).mOriginPoint.x) {
                    left = (int)((SnakeHackLayout)SnakeHackLayout.this).mOriginPoint.x;
                }
                left = SnakeHackLayout.this.mViewDragHelper.isEdgeTouched(1) ? left : (int)child.getX();
                left = !SnakeHackLayout.this.onlyListenToFastSwipe ? left : (int)((SnakeHackLayout)SnakeHackLayout.this).mOriginPoint.x + 1;
                left = SnakeHackLayout.this.mInterceptScene < 0 ? left : (int)((SnakeHackLayout)SnakeHackLayout.this).mOriginPoint.x + 1;
                left = SnakeHackLayout.this.ignoreDragEvent ? 0 : left;
                return left;
            }

            public int clampViewPositionVertical(View child, int top, int dy) {
                return (int)((SnakeHackLayout)SnakeHackLayout.this).mOriginPoint.y;
            }

            public void onViewDragStateChanged(int state) {
                SnakeHackLayout.this.isSettling = 2 == state;
            }

            public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
                if (Build.VERSION.SDK_INT >= 16 && !SnakeHackLayout.this.hideShadowOfEdge) {
                    int shadowStartColor = Utils.changeAlpha(SnakeHackLayout.this.mShadowStartColor, (int)((float)Color.alpha((int)SnakeHackLayout.this.mShadowStartColor) * (1.0f - (float)left / (float)SnakeHackLayout.this.mXRange)));
                    int shadowEndColor = Utils.changeAlpha(SnakeHackLayout.this.mShadowEndColor, (int)((float)Color.alpha((int)SnakeHackLayout.this.mShadowEndColor) * (1.0f - (float)left / (float)SnakeHackLayout.this.mXRange)));
                    SnakeHackLayout.this.mShadowDrawable.mutate();
                    SnakeHackLayout.this.mShadowDrawable.setColors(new int[]{shadowStartColor, shadowEndColor});
                    SnakeHackLayout.this.invalidate();
                }
                if (SnakeHackLayout.this.needListenForDraging(SnakeHackLayout.this.mViewDragHelper, changedView)) {
                    if (null != SnakeHackLayout.this.onEdgeDragListener) {
                        SnakeHackLayout.this.onEdgeDragListener.onDrag(SnakeHackLayout.this, changedView, left);
                    }
                    for (Snake.OnDragListener onDragListener : SnakeHackLayout.this.onDragListeners) {
                        onDragListener.onDrag(changedView, left, SnakeHackLayout.this.isSettling);
                    }
                }
                if ((left <= 0 || left >= SnakeHackLayout.this.mXRange) && null != SnakeHackLayout.this.onReleaseStateListener && SnakeHackLayout.this.isSettling) {
                    SnakeHackLayout.this.onReleaseStateListener.onReleaseCompleted(SnakeHackLayout.this, changedView);
                }
                if (left <= 0 && SnakeHackLayout.this.isSettling) {
                    for (Snake.OnDragListener onDragListener : SnakeHackLayout.this.onDragListeners) {
                        onDragListener.onBackToStartCompleted(changedView);
                    }
                }
                SnakeHackLayout.this.mContentViewLeft = left;
                SnakeHackLayout.this.mContentViewTop = top;
            }

            public void onViewReleased(View releasedChild, float xvel, float yvel) {
                if (SnakeHackLayout.this.mViewDragHelper.isEdgeTouched(1) || SnakeHackLayout.this.onlyListenToFastSwipe) {
                    boolean shouldClose;
                    boolean bl = shouldClose = xvel > SnakeHackLayout.this.mViewDragHelper.getMinVelocity();
                    if (!shouldClose) {
                        boolean bl2 = shouldClose = releasedChild.getLeft() > SnakeHackLayout.this.mXRange / SnakeHackLayout.this.mReleaseFactor;
                    }
                    if (null != SnakeHackLayout.this.onEdgeDragListener) {
                        SnakeHackLayout.this.onEdgeDragListener.onRelease(SnakeHackLayout.this, releasedChild, releasedChild.getLeft(), shouldClose, SnakeHackLayout.this.mInterceptScene);
                    }
                    for (Snake.OnDragListener onDragListener : SnakeHackLayout.this.onDragListeners) {
                        onDragListener.onRelease(releasedChild, xvel);
                    }
                }
            }
        });
        this.mViewDragHelper.setEdgeTrackingEnabled(1);
        this.mShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.mShadowStartColor, this.mShadowEndColor});
        this.mSwipeUpGestureDispatcher = SwipeUpGestureDispatcher.create((View)this, (int)this.mViewDragHelper.getMinVelocity(), this.mViewDragHelper.getEdgeSize(), new SwipeUpGestureDispatcher.OnSwipeUpListener(){

            @Override
            public void onSwipeUp(float velocityY, boolean isEdgeBottomTouched) {
                Logger.d("onSwipeUp: velocityY = " + velocityY + ", isEdgeBottomTouched = " + isEdgeBottomTouched);
                if (isEdgeBottomTouched) {
                    Utils.backToHome(SnakeHackLayout.this.getContext());
                }
            }
        });
    }

    private boolean needListenForDraging(ViewDragHelper viewDragHelper, View childView) {
        return viewDragHelper.isEdgeTouched(1) || viewDragHelper.getViewDragState() == 2 && childView.getLeft() > 0;
    }

    public static SnakeHackLayout getLayout(Context context, View contentView, boolean allowDragChildView) {
        SnakeHackLayout snakeHackLayout = new SnakeHackLayout(context);
        snakeHackLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        snakeHackLayout.setAllowDragChildView(allowDragChildView);
        if (null != contentView) {
            snakeHackLayout.addView(contentView);
        }
        return snakeHackLayout;
    }

    public static SnakeHackLayout getLayout(Context context) {
        return SnakeHackLayout.getLayout(context, null, true);
    }

    public void addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("SnakeHackLayout can host only one direct child. ");
        }
        super.addView(child);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mXRange = right - left;
        this.isInLayout = true;
        if (this.getChildCount() > 0) {
            View contentView = this.getChildAt(0);
            contentView.layout(this.mContentViewLeft, this.mContentViewTop, this.mContentViewLeft + contentView.getMeasuredWidth(), this.mContentViewTop + contentView.getMeasuredHeight());
        }
        this.isInLayout = false;
    }

    public void requestLayout() {
        if (!this.isInLayout) {
            super.requestLayout();
        }
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.contentLeft = this.mContentViewLeft;
        ss.contentTop = this.mContentViewTop;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        this.mContentViewLeft = savedState.contentLeft;
        this.mContentViewTop = savedState.contentTop;
        this.requestLayout();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (null != this.mCustomTouchInterceptor && this.mCustomTouchInterceptor.onTouchEvent(event)) {
            return true;
        }
        this.requestParentDisallowInterceptTouchEvent(true);
        this.mViewDragHelper.processTouchEvent(event);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (null != this.mCustomTouchInterceptor && this.mCustomTouchInterceptor.onInterceptTouchEvent(ev)) {
            return true;
        }
        return this.mViewDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.requestParentDisallowInterceptTouchEvent(true);
        if (this.mSwipeUpToHomeEnabled) {
            this.mSwipeUpGestureDispatcher.dispatch(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    private void requestParentDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (null != parent) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public void computeScroll() {
        if (this.mViewDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setFractionX(final float fractionX) {
        this.fractionX = fractionX;
        if (null == this.mPreDrawListener) {
            this.mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    SnakeHackLayout.this.getViewTreeObserver().removeOnPreDrawListener(SnakeHackLayout.this.mPreDrawListener);
                    SnakeHackLayout.this.setTranslateX(fractionX);
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
        }
        this.setTranslateX(fractionX);
    }

    private void setTranslateX(float fractionX) {
        int width = this.getWidth();
        if ((float)width <= 0.0f) {
            return;
        }
        this.setTranslationX((float)width * fractionX);
    }

    public float getFractionX() {
        return this.fractionX;
    }

    @Deprecated
    public void setAllowDragChildView(boolean allowDragChildView) {
        this.mAllowDragChildView = allowDragChildView;
    }

    public void ignoreDragEvent(boolean ignore) {
        this.ignoreDragEvent = ignore;
        if (this.getChildCount() > 0) {
            this.smoothScrollToStart(this.getChildAt(0), null);
        }
    }

    public boolean ignoredDragEvent() {
        return this.ignoreDragEvent;
    }

    public SnakeUIConfig getUIConfig() {
        return this.mUIConfig;
    }

    public void setAllowPageLinkageOfUIConfig(boolean allow) {
        this.mUIConfig.allowPageLinkage = allow;
    }

    public void setOnEdgeDragListener(OnEdgeDragListener onEdgeDragListener) {
        if (null != this.onEdgeDragListener) {
            throw new SnakeConfigException("Don't assign values for onEdgeDragListener");
        }
        this.onEdgeDragListener = onEdgeDragListener;
    }

    public void addOnDragListener(Snake.OnDragListener onDragListener) {
        this.onDragListeners.add(onDragListener);
    }

    public void setDragInterceptor(DragInterceptor dragInterceptor) {
        this.mDragInterceptor = dragInterceptor;
    }

    public void setMinVelocity(int minVelocity) {
        this.mViewDragHelper.setMinVelocity((float)minVelocity);
        this.mSwipeUpGestureDispatcher.setMinVelocity(minVelocity);
    }

    public void setShadowStartColor(@ColorInt int shadowStartColor) {
        this.mShadowStartColor = shadowStartColor;
    }

    public void setShadowEndColor(@ColorInt int shadowEndColor) {
        this.mShadowEndColor = shadowEndColor;
    }

    public void setOnlyListenToFastSwipe(boolean onlyListenToFastSwipe) {
        this.onlyListenToFastSwipe = onlyListenToFastSwipe;
    }

    public void setCustomTouchInterceptor(SnakeTouchInterceptor interceptor) {
        this.mCustomTouchInterceptor = interceptor;
    }

    public void enableSwipeUpToHome(boolean enable) {
        this.mSwipeUpToHomeEnabled = enable;
    }

    public boolean swipeUpToHomeEnabled() {
        return this.mSwipeUpToHomeEnabled;
    }

    public boolean onlyListenToFastSwipe() {
        return this.onlyListenToFastSwipe;
    }

    public void hideShadowOfEdge(boolean hideShadowOfEdge) {
        this.hideShadowOfEdge = hideShadowOfEdge;
    }

    public void resetUI() {
        this.mViewDragHelper.abort();
    }

    public void smoothScrollTo(View view, int x, int y, OnReleaseStateListener onReleaseStateListener) {
        if (null != view) {
            this.mViewDragHelper.smoothSlideViewTo(view, x, y);
            this.invalidate();
            this.onReleaseStateListener = onReleaseStateListener;
        }
    }

    public void smoothScrollToStart(View view, OnReleaseStateListener onReleaseStateListener) {
        this.smoothScrollTo(view, (int)this.mOriginPoint.x, (int)this.mOriginPoint.y, onReleaseStateListener);
    }

    public void smoothScrollToStart(View view) {
        this.smoothScrollToStart(view, null);
    }

    public void smoothScrollToLeave(View view, OnReleaseStateListener onReleaseStateListener) {
        this.smoothScrollTo(view, this.mXRange, (int)this.mOriginPoint.y, onReleaseStateListener);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getChildCount() <= 0) {
            return;
        }
        if (this.hideShadowOfEdge) {
            return;
        }
        canvas.save();
        int left = this.getChildAt(0).getLeft() - this.mShadowWidth;
        int top = 0;
        int right = left + this.mShadowWidth;
        int bottom = this.getHeight();
        this.mShadowDrawable.setBounds(left, top, right, bottom);
        this.mShadowDrawable.draw(canvas);
        canvas.restore();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getChildCount() > 0) {
            View childView = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)childView.getLayoutParams();
            float x = childView.getX() + (float)lp.leftMargin;
            float y = childView.getY() + (float)lp.topMargin;
            this.mOriginPoint = new PointF(x, y);
        }
    }

    public View getContentView() {
        if (this.getChildCount() > 0) {
            return this.getChildAt(0);
        }
        return null;
    }

    public static class SavedState
    extends View.BaseSavedState {
        private int contentLeft;
        private int contentTop;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.contentLeft = in.readInt();
            this.contentTop = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.contentLeft);
            out.writeInt(this.contentTop);
        }
    }

    public static abstract class DragInterceptor {
        public int intercept(SnakeHackLayout parent, View view, int pointerId) {
            return -1;
        }
    }

    public static abstract class OnEdgeDragListener {
        public void onDragStart(SnakeHackLayout parent) {
        }

        public void onDrag(SnakeHackLayout parent, View view, int left) {
        }

        public void onRelease(SnakeHackLayout parent, View view, int left, boolean shouldClose, int interceptScene) {
        }
    }

    public static interface OnReleaseStateListener {
        public void onReleaseCompleted(SnakeHackLayout var1, View var2);
    }
}

