/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import com.youngfeng.snake.util.Utils;

public class SwipeUpGestureDispatcher {
    private static final int EDGE_SIZE = 20;
    private int mEdgeSize;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mMaximumFlingVelocity;
    private int mMinimumFlingVelocity;
    private boolean isEdgeBottomTouched;
    private int mTouchSlop;
    private View mTargetView;
    private VelocityTracker mVelocityTracker;
    private OnSwipeUpListener onSwipeUpListener;

    private SwipeUpGestureDispatcher(View view, OnSwipeUpListener onSwipeUpListener, int minVelocity, int edgeSize) {
        this.mTargetView = view;
        this.onSwipeUpListener = onSwipeUpListener;
        this.mEdgeSize = edgeSize;
        ViewConfiguration configuration = ViewConfiguration.get((Context)view.getContext());
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mMinimumFlingVelocity = minVelocity;
        this.mTouchSlop = configuration.getScaledTouchSlop();
    }

    public static SwipeUpGestureDispatcher create(@NonNull View view, @NonNull OnSwipeUpListener onGestureListener) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)view.getContext());
        int minVelocity = configuration.getScaledMinimumFlingVelocity();
        int edgeSize = (int)(20.0f * view.getContext().getResources().getDisplayMetrics().density + 0.5f);
        return SwipeUpGestureDispatcher.create(view, minVelocity, edgeSize, onGestureListener);
    }

    public static SwipeUpGestureDispatcher create(@NonNull View view, int minVelocity, @NonNull OnSwipeUpListener onGestureListener) {
        int edgeSize = (int)(20.0f * view.getContext().getResources().getDisplayMetrics().density + 0.5f);
        return SwipeUpGestureDispatcher.create(view, minVelocity, edgeSize, onGestureListener);
    }

    public static SwipeUpGestureDispatcher create(@NonNull View view, int minVelocity, int edgSize, @NonNull OnSwipeUpListener onGestureListener) {
        return new SwipeUpGestureDispatcher(view, onGestureListener, minVelocity, edgSize);
    }

    public void dispatch(MotionEvent event) {
        if (null == this.mVelocityTracker) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.mInitialMotionX = event.getX();
                this.mInitialMotionY = event.getY();
                if (!this.isEdgeBottomTouched(this.mInitialMotionY)) break;
                this.isEdgeBottomTouched = true;
                break;
            }
            case 1: {
                float dx = event.getX() - this.mInitialMotionX;
                float dy = event.getY() - this.mInitialMotionY;
                if (dx * dx + dy * dy > (float)(this.mTouchSlop * this.mTouchSlop)) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                    float velocityX = this.mVelocityTracker.getXVelocity();
                    float velocityY = this.mVelocityTracker.getYVelocity();
                    if (Math.abs(velocityY) > Math.abs(velocityX) && Math.abs(velocityY) > (float)this.mMinimumFlingVelocity && velocityY < 0.0f && null != this.onSwipeUpListener) {
                        this.onSwipeUpListener.onSwipeUp(velocityY, this.isEdgeBottomTouched);
                    }
                }
                this.cancel();
                break;
            }
        }
    }

    private boolean isEdgeBottomTouched(float y) {
        Context context = this.mTargetView.getContext();
        int navigationBarHeight = 0;
        if (Utils.navigationBarVisible(context)) {
            navigationBarHeight = Utils.getNavigationHeight(context);
        }
        return y > (float)(this.mTargetView.getBottom() - this.mEdgeSize - navigationBarHeight);
    }

    public void setMinVelocity(int minVelocity) {
        this.mMinimumFlingVelocity = minVelocity;
    }

    public void cancel() {
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.isEdgeBottomTouched = false;
    }

    public static abstract class OnSwipeUpListener {
        public void onSwipeUp(float velocityY, boolean isEdgeBottomTouched) {
        }
    }
}

