/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.youngfeng.snake.util.ActivityHelper;
import com.youngfeng.snake.util.ActivityInstance;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ActivityManager {
    private static ActivityManager instance;
    private List<ActivityInstance> mActivityStack = new LinkedList<ActivityInstance>();

    private ActivityManager() {
    }

    public static synchronized ActivityManager get() {
        if (null == instance) {
            instance = new ActivityManager();
        }
        return instance;
    }

    public void put(Activity activity) {
        ActivityInstance instance = new ActivityInstance();
        instance.activity = activity;
        instance.originBackgroundResourceId = ActivityHelper.getWindowBackgroundResourceId(activity);
        if (!this.mActivityStack.contains(instance)) {
            this.mActivityStack.add(0, instance);
        }
    }

    public void remove(Activity activity) {
        Iterator<ActivityInstance> it = this.mActivityStack.iterator();
        while (it.hasNext()) {
            if (it.next().activity != activity) continue;
            it.remove();
            break;
        }
    }

    public Activity getLastActivity(@NonNull Activity activity) {
        int index = this.indexOf(activity);
        if (index >= 0 && this.mActivityStack.size() > index + 1) {
            return this.mActivityStack.get((int)(index + 1)).activity;
        }
        return null;
    }

    public int indexOf(@NonNull Activity activity) {
        for (int i = 0; i < this.mActivityStack.size(); ++i) {
            if (this.mActivityStack.get((int)i).activity != activity) continue;
            return i;
        }
        return -1;
    }

    public boolean isRootActivity(@NonNull Activity activity) {
        return this.mActivityStack.size() > 0 && this.indexOf(activity) >= this.mActivityStack.size() - 1;
    }

    public View getViewOfLastActivity(@NonNull Activity activity) {
        Activity lastActivity = this.getLastActivity(activity);
        if (null == lastActivity) {
            return null;
        }
        return ((ViewGroup)lastActivity.getWindow().getDecorView()).getChildAt(0);
    }
}

