/*
 * Decompiled with CFR 0.152.
 */
package com.yotadevices.viscera.di;

import com.yotadevices.viscera.di.Module;
import java.util.HashMap;

public class Container {
    private HashMap<String, Module> mModules = new HashMap();

    private Container() {
    }

    public static Container getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Container put(Module module) {
        String moduleName = module.getClass().getSimpleName();
        if (this.mModules.containsKey(moduleName)) {
            this.mModules.remove(moduleName);
        }
        this.mModules.put(moduleName, module);
        return this;
    }

    public Module get(Class clazz) {
        if (!this.mModules.containsKey(clazz.getSimpleName())) {
            throw new IllegalAccessError("Module " + clazz.getSimpleName() + " wasn't injected or You are trying to get the nonexistent module!");
        }
        return this.mModules.get(clazz.getSimpleName());
    }

    public int getCount() {
        return this.mModules.size();
    }

    private static class InstanceHolder {
        private static final Container INSTANCE = new Container();

        private InstanceHolder() {
        }
    }
}

