/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.dispatcher.utils;

import android.util.Log;
import com.yoogor.abc.log.LogUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpSerializer {
    private static final String LOG_TAG = HttpSerializer.class.getSimpleName();

    public static void serializeObject2Map(Object object, Map<String, Object> map) {
        if (object == null || map == null) {
            return;
        }
        ArrayList classes = new ArrayList();
        Class<?> curClass = object.getClass();
        do {
            classes.add(0, curClass);
        } while ((curClass = curClass.getSuperclass()) != null);
        for (Class clazz : classes) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                HttpSerializer.readValue(field, object, map);
            }
        }
    }

    public static void setByteToCollector(byte[] des, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            des[i] = bytes[i];
        }
    }

    public static void deserializeJSONObject(Object object, JSONObject json) {
        if (object == null || json == null) {
            return;
        }
        ArrayList classes = new ArrayList();
        Class<?> curClass = object.getClass();
        do {
            classes.add(0, curClass);
        } while ((curClass = curClass.getSuperclass()) != null);
        for (Class clazz : classes) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                HttpSerializer.writeValue(field, object, json);
            }
        }
    }

    public static <T> List<T> deserializeJSONArray(Class<T> elementClassType, JSONArray array) {
        ArrayList<T> list = new ArrayList<T>();
        if (elementClassType == null || array == null || array == null || array.length() == 0) {
            return list;
        }
        for (int i = 0; i < array.length(); ++i) {
            try {
                T object = elementClassType.newInstance();
                HttpSerializer.deserializeJSONObject(object, array.getJSONObject(i));
                list.add(object);
                continue;
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)("deserializeJSONArray.JSONException: " + e.getMessage()));
                continue;
            }
            catch (IllegalAccessException e) {
                Log.e((String)LOG_TAG, (String)("deserializeJSONArray.IllegalAccessException: " + e.getMessage()));
                break;
            }
            catch (InstantiationException e) {
                Log.e((String)LOG_TAG, (String)("deserializeJSONArray.InstantiationException: " + e.getMessage()));
                break;
            }
        }
        return list;
    }

    private static void writeValue(Field field, Object object, byte[] bytes) {
        byte[] value = null;
        try {
            value = new byte[0x200000];
            Class<?> actualClass = field.getType();
            field.setAccessible(true);
            if (actualClass == byte[].class) {
                value = bytes;
            }
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            LogUtil.LogThrowable((String)"HttpSearualizer", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LogUtil.LogThrowable((String)"HttpSearualizer", (Throwable)e);
        }
    }

    private static void writeValue(Field field, Object object, JSONObject json) {
        Object value = null;
        try {
            Class<?> actualClass = field.getType();
            String name = field.getName();
            if (json.isNull(name)) {
                return;
            }
            field.setAccessible(true);
            if (actualClass == Integer.TYPE || actualClass == Integer.class) {
                value = json.optInt(name);
            } else if (actualClass == String.class) {
                value = json.optString(name);
            } else if (actualClass == Boolean.TYPE || actualClass == Boolean.class) {
                value = json.optBoolean(name);
            } else if (actualClass == Double.TYPE || actualClass == Double.class) {
                value = json.optDouble(name);
            } else if (actualClass == Float.TYPE || actualClass == Float.class) {
                value = Float.valueOf((float)json.optDouble(name));
            } else if (actualClass == Long.TYPE || actualClass == Long.class) {
                value = json.optLong(name);
            } else if (List.class.isAssignableFrom(actualClass)) {
                JSONSerializeAnnotation attr = field.getAnnotation(JSONSerializeAnnotation.class);
                if (attr != null) {
                    Class<?> subClass = attr.actualClass();
                    value = HttpSerializer.deserializeJSONArray(subClass, json.getJSONArray(name));
                }
            } else if (actualClass == JSONObject.class) {
                value = json.getJSONObject(name);
            } else if (actualClass == JSONArray.class) {
                value = json.getJSONArray(name);
            } else if (actualClass == Object.class) {
                value = field.get(object);
                if (value != null) {
                    if (value instanceof String) {
                        value = json.getJSONObject(name).toString();
                    } else {
                        HttpSerializer.deserializeJSONObject(value, json.getJSONObject(name));
                    }
                } else {
                    value = json.opt(name);
                }
            } else {
                value = field.get(object);
                if (value == null) {
                    value = actualClass.newInstance();
                }
                HttpSerializer.deserializeJSONObject(value, json.getJSONObject(name));
            }
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            Log.w((String)LOG_TAG, (String)("writeValue.IllegalAccessException: " + e.getMessage()));
        }
        catch (InstantiationException e) {
            Log.w((String)LOG_TAG, (String)("writeValue.InstantiationException: " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)("writeValue.JSONException: " + e.getMessage()));
        }
    }

    private static void readValue(Field field, Object object, Map<String, Object> map) {
        try {
            List list;
            Class<?> actualClass = field.getType();
            String name = field.getName();
            field.setAccessible(true);
            if (actualClass == Integer.TYPE) {
                int value = field.getInt(object);
                map.put(name, String.valueOf(value));
            } else if (actualClass == Integer.class) {
                Object value = field.get(object);
                if (value != null) {
                    map.put(name, String.valueOf(value));
                }
            } else if (actualClass == String.class) {
                Object value = field.get(object);
                if (value != null) {
                    map.put(name, String.valueOf(value));
                }
            } else if (actualClass == Boolean.TYPE) {
                boolean value = field.getBoolean(object);
                map.put(name, String.valueOf(value));
            } else if (actualClass == Boolean.class) {
                Object value = field.get(object);
                if (value != null) {
                    map.put(name, String.valueOf(value));
                }
            } else if (actualClass == Double.TYPE) {
                double value = field.getDouble(object);
                map.put(name, String.valueOf(value));
            } else if (actualClass == Double.class) {
                Object value = field.get(object);
                if (value != null) {
                    map.put(name, String.valueOf(value));
                }
            } else if (actualClass == Float.TYPE) {
                float value = field.getFloat(object);
                map.put(name, String.valueOf(value));
            } else if (actualClass == Float.class) {
                Object value = field.get(object);
                if (value != null) {
                    map.put(name, String.valueOf(value));
                }
            } else if (actualClass == Long.TYPE) {
                long value = field.getLong(object);
                map.put(name, String.valueOf(value));
            } else if (actualClass == Long.class) {
                Object value = field.get(object);
                if (value != null) {
                    map.put(name, String.valueOf(value));
                }
            } else if (List.class.isAssignableFrom(actualClass) && (list = (List)field.get(object)) != null && !list.isEmpty()) {
                Object[] array = new Object[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    HashMap<String, Object> subMap = new HashMap<String, Object>();
                    HttpSerializer.serializeObject2Map(list.get(i), subMap);
                    if (subMap.isEmpty()) continue;
                    array[i] = subMap;
                }
                map.put(name, array);
            }
        }
        catch (IllegalAccessException e) {
            LogUtil.LogThrowable((String)"HttpSearualizer", (Throwable)e);
        }
    }

    public static void serializeObject2JSONObject(Object object, JSONObject json) {
        if (object == null || json == null) {
            return;
        }
        ArrayList classes = new ArrayList();
        Class<?> curClass = object.getClass();
        do {
            classes.add(0, curClass);
        } while ((curClass = curClass.getSuperclass()) != null);
        for (Class clazz : classes) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object obj = HttpSerializer.readValue(field, object);
                if (obj == null) continue;
                String name = field.getName();
                try {
                    json.put(name, obj);
                }
                catch (JSONException e) {
                    LogUtil.LogThrowable((String)"HttpSearualizer", (Throwable)e);
                }
            }
        }
    }

    private static Object readValue(Field field, Object object) {
        block5: {
            try {
                Class<?> actualClass = field.getType();
                field.setAccessible(true);
                if (List.class.isAssignableFrom(actualClass)) {
                    List list = (List)field.get(object);
                    if (list != null && !list.isEmpty()) {
                        JSONArray array = new JSONArray();
                        for (int i = 0; i < list.size(); ++i) {
                            JSONObject json = new JSONObject();
                            HttpSerializer.serializeObject2JSONObject(list.get(i), json);
                            array.put((Object)json);
                        }
                        return array;
                    }
                    break block5;
                }
                return field.get(object);
            }
            catch (IllegalAccessException e) {
                Log.w((String)LOG_TAG, (String)("writeValue.IllegalAccessException: " + e.getMessage()));
            }
        }
        return null;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface JSONSerializeAnnotation {
        public Class<?> actualClass();
    }
}

