/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.dispatcher;

import com.yoogor.abc.dispatcher.AppNotifier;
import com.yoogor.abc.dispatcher.IHttpExcuter;
import com.yoogor.abc.dispatcher.entity.BaseParam;
import com.yoogor.abc.dispatcher.entity.BaseResponse;
import com.yoogor.abc.dispatcher.entity.RequestEntity;
import com.yoogor.abc.dispatcher.interf.IResponseDispatcher;
import com.yoogor.abc.dispatcher.utils.ExecutorServiceHelper;
import com.yoogor.abc.log.LogUtil;
import java.net.ConnectException;
import java.util.UUID;

public class IRequestDispatcherImpl
implements IResponseDispatcher {
    private static final String TAG = IRequestDispatcherImpl.class.getSimpleName();
    private static IHttpExcuter httpExcuter = null;

    @Override
    public void onFailed(RequestEntity requestEntity, Exception e) {
        if (e instanceof ConnectException) {
            if (e.getMessage().contains("ENETUNREACH")) {
                this.showNetUnAvailable();
            } else {
                this.showRequestError();
            }
        } else {
            this.showRequestError();
        }
        AppNotifier.instance().notify(requestEntity);
    }

    @Override
    public void onData(final RequestEntity requestEntity, final String data) {
        ExecutorServiceHelper.getInstance().execRun(new Runnable(){

            @Override
            public void run() {
                if (requestEntity == null) {
                    throw new RuntimeException("requestEntity must not be NULL");
                }
                String data1 = httpExcuter.preParseResponse(data);
                String extra = "";
                if (requestEntity.getExtra() != null && requestEntity.getExtra().containsKey("analysisState")) {
                    extra = requestEntity.getExtra().get("analysisState").toString();
                }
                LogUtil.LogE((String)TAG, (String)(requestEntity.getBaseParam().getDesc() + extra + "\t" + data1));
                httpExcuter.parseJson(data1, requestEntity);
                AppNotifier.instance().notify(requestEntity);
            }
        });
    }

    private IRequestDispatcherImpl() {
    }

    public static IResponseDispatcher instance() {
        return Instance.instance;
    }

    public static void setHttpExcuter(IHttpExcuter excuter) {
        httpExcuter = excuter;
    }

    private void showRequestError() {
    }

    private void showNetUnAvailable() {
    }

    @Override
    public <T extends BaseResponse> void sendRequest(BaseParam param, T response, UUID uuid) {
        if (httpExcuter == null) {
            throw new RuntimeException("IRequestDispatcherImpl.httpExcuter must not be NULL,please call IRequestDispatcherImpl.setHttpExcuter(IHttpExcuter excuter) first !!!");
        }
        RequestEntity requestEntity = new RequestEntity(param, response);
        requestEntity.setUuid(uuid);
        httpExcuter.sendHttpRequest(requestEntity, this);
    }

    private static class Instance {
        static IRequestDispatcherImpl instance = new IRequestDispatcherImpl();

        private Instance() {
        }
    }
}

