/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.demo.orm.utils;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.yoogor.demo.orm.annotation.TableName;
import com.yoogor.demo.orm.extra.TableColumn;
import com.yoogor.demo.orm.extra.TableInfo;
import com.yoogor.demo.orm.utils.Logger;
import com.yoogor.demo.orm.utils.SqlUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class TableInfoUtils {
    public static final String TAG = "SqliteUtility";
    private static final HashMap<String, TableInfo> tableInfoMap = new HashMap();

    public static <T> TableInfo exist(String dbName, Class<T> clazz) {
        return tableInfoMap.get(dbName + "-" + TableInfoUtils.getTableName(clazz));
    }

    public static String getTableName(Class<?> clazz) {
        TableName table = clazz.getAnnotation(TableName.class);
        if (table == null || table.table().trim().length() == 0) {
            return clazz.getName().replace('.', '_');
        }
        return table.table();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> TableInfo newTable(String dbName, SQLiteDatabase db, Class<T> clazz) {
        Cursor cursor = null;
        TableInfo tableInfo = new TableInfo(clazz);
        tableInfoMap.put(dbName + "-" + TableInfoUtils.getTableName(clazz), tableInfo);
        try {
            int count;
            String sql = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + tableInfo.getTableName() + "' ";
            cursor = db.rawQuery(sql, null);
            if (cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                cursor.close();
                Logger.d(TAG, "\u8868 %s \u5df2\u5b58\u5728", tableInfo.getTableName());
                cursor = db.rawQuery("PRAGMA table_info(" + tableInfo.getTableName() + ")", null);
                ArrayList<String> tableColumns = new ArrayList<String>();
                if (cursor != null && cursor.moveToNext()) {
                    do {
                        tableColumns.add(cursor.getString(cursor.getColumnIndex("name")));
                    } while (cursor.moveToNext());
                }
                cursor.close();
                ArrayList<String> properList = new ArrayList<String>();
                for (TableColumn column : tableInfo.getColumns()) {
                    properList.add(column.getColumn());
                }
                ArrayList<String> newFieldList = new ArrayList<String>();
                for (String field : properList) {
                    if (tableInfo.getPrimaryKey().equals(field)) continue;
                    boolean isNew = true;
                    for (String tableColumn : tableColumns) {
                        if (!tableColumn.equals(field)) continue;
                        isNew = false;
                        break;
                    }
                    if (!isNew) continue;
                    newFieldList.add(field);
                }
                for (String newField : newFieldList) {
                    db.execSQL(String.format("ALTER TABLE %s ADD %s TEXT", tableInfo.getTableName(), newField));
                    Logger.d(TAG, "\u8868 %s \u65b0\u589e\u5b57\u6bb5 %s", tableInfo.getTableName(), newField);
                }
                TableInfo tableInfo2 = tableInfo;
                return tableInfo2;
            }
            String createSql = SqlUtils.getTableSql(tableInfo);
            db.execSQL(createSql);
            Logger.d(TAG, "\u521b\u5efa\u4e00\u5f20\u65b0\u8868 %s", tableInfo.getTableName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.d(TAG, e.getMessage() + "");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return tableInfo;
    }
}

