/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.demo.orm.extra;

import com.yoogor.demo.orm.annotation.AutoIncrementPrimaryKey;
import com.yoogor.demo.orm.annotation.PrimaryKey;
import com.yoogor.demo.orm.extra.AutoIncrementTableColumn;
import com.yoogor.demo.orm.extra.TableColumn;
import com.yoogor.demo.orm.utils.Logger;
import com.yoogor.demo.orm.utils.TableInfoUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class TableInfo {
    private Class<?> clazz;
    private TableColumn primaryKey;
    private String tableName;
    private List<TableColumn> columns;

    public TableInfo(Class<?> clazz) {
        this.clazz = clazz;
        this.setInit();
    }

    private <T> void setInit() {
        this.columns = new ArrayList<TableColumn>();
        this.setTableName();
        this.setColumns(this.clazz);
        if (this.primaryKey == null) {
            throw new RuntimeException("\u7c7b " + this.clazz.getSimpleName() + " \u6ca1\u6709\u8bbe\u7f6e\u4e3b\u952e\uff0c\u8bf7\u4f7f\u7528\u6807\u6ce8\u4e3b\u952e");
        }
        if (Logger.DEBUG) {
            Logger.v("SqliteUtility", String.format("\u7c7b %s \u7684\u4e3b\u952e\u662f %s", this.clazz.getSimpleName(), this.primaryKey.getColumn()), new Object[0]);
            for (TableColumn column : this.columns) {
                Logger.v("SqliteUtility", String.format("[column = %s, datatype = %s]", column.getColumn(), column.getDataType()), new Object[0]);
            }
        }
    }

    private void setTableName() {
        this.tableName = TableInfoUtils.getTableName(this.clazz);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public TableColumn getPrimaryKey() {
        return this.primaryKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Class<?> c) {
        Field[] fields;
        if (c == null || "Object".equalsIgnoreCase(c.getSimpleName())) {
            return;
        }
        for (Field field : fields = c.getDeclaredFields()) {
            if (this.primaryKey == null) {
                PrimaryKey annotationField = field.getAnnotation(PrimaryKey.class);
                if (annotationField != null) {
                    this.primaryKey = new TableColumn();
                    this.primaryKey.setColumn(annotationField.column());
                    this.setColumn(field, this.primaryKey);
                    continue;
                }
                AutoIncrementPrimaryKey autoIncrementPrimaryKey = field.getAnnotation(AutoIncrementPrimaryKey.class);
                if (autoIncrementPrimaryKey != null) {
                    this.primaryKey = new AutoIncrementTableColumn();
                    this.primaryKey.setColumn(autoIncrementPrimaryKey.column());
                    this.setColumn(field, this.primaryKey);
                    continue;
                }
            }
            if ("serialVersionUID".equals(field.getName()) || "$change".equals(field.getName())) continue;
            TableColumn column = new TableColumn();
            column.setColumn(field.getName());
            this.setColumn(field, column);
            this.columns.add(column);
        }
        this.setColumns(c.getSuperclass());
    }

    private void setColumn(Field field, TableColumn column) {
        column.setField(field);
        if (field.getType().getName().equals("int") || field.getType().getName().equals("java.lang.Integer")) {
            column.setDataType("int");
            column.setColumnType("INTEGER");
        } else if (field.getType().getName().equals("long") || field.getType().getName().equals("java.lang.Long")) {
            column.setDataType("long");
            column.setColumnType("INTEGER");
        } else if (field.getType().getName().equals("float") || field.getType().getName().equals("java.lang.Float")) {
            column.setDataType("float");
            column.setColumnType("REAL");
        } else if (field.getType().getName().equals("double") || field.getType().getName().equals("java.lang.Double")) {
            column.setDataType("double");
            column.setColumnType("REAL");
        } else if (field.getType().getName().equals("boolean") || field.getType().getName().equals("java.lang.Boolean")) {
            column.setDataType("boolean");
            column.setColumnType("TEXT");
        } else if (field.getType().getName().equals("char") || field.getType().getName().equals("java.lang.Character")) {
            column.setDataType("char");
            column.setColumnType("TEXT");
        } else if (field.getType().getName().equals("byte") || field.getType().getName().equals("java.lang.Byte")) {
            column.setDataType("byte");
            column.setColumnType("INTEGER");
        } else if (field.getType().getName().equals("short") || field.getType().getName().equals("java.lang.Short")) {
            column.setDataType("short");
            column.setColumnType("TEXT");
        } else if (field.getType().getName().equals("java.lang.String")) {
            column.setDataType("string");
            column.setColumnType("TEXT");
        } else if (field.getType().getName().equals("[B")) {
            column.setDataType("blob");
            column.setColumnType("BLOB");
        } else {
            column.setDataType("object");
            column.setColumnType("TEXT");
        }
    }
}

