/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.demo.orm;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.yoogor.demo.orm.extra.AutoIncrementTableColumn;
import com.yoogor.demo.orm.extra.Extra;
import com.yoogor.demo.orm.extra.TableColumn;
import com.yoogor.demo.orm.extra.TableInfo;
import com.yoogor.demo.orm.utils.Logger;
import com.yoogor.demo.orm.utils.SqlUtils;
import com.yoogor.demo.orm.utils.TableInfoUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class SqliteUtility {
    public static final String TAG = "SqliteUtility";
    private static Hashtable<String, SqliteUtility> dbCache = new Hashtable();
    private String dbName;
    private SQLiteDatabase db;

    SqliteUtility(String dbName, SQLiteDatabase db) {
        this.db = db;
        this.dbName = dbName;
        dbCache.put(dbName, this);
        Logger.d(TAG, "\u5c06\u5e93 %s \u653e\u5230\u7f13\u5b58\u4e2d", dbName);
    }

    public static SqliteUtility getInstance() {
        return SqliteUtility.getInstance("com_m_default_db");
    }

    public static SqliteUtility getInstance(String dbName) {
        return dbCache.get(dbName);
    }

    public <T> T selectById(Extra extra, Class<T> clazz, Object id) {
        try {
            String[] selectionArgs;
            List<T> list;
            TableInfo tableInfo = this.checkTable(clazz);
            String selection = String.format(" %s = ? ", tableInfo.getPrimaryKey().getColumn());
            String extraSelection = SqlUtils.appendExtraWhereClause(extra);
            if (!TextUtils.isEmpty((CharSequence)extraSelection)) {
                selection = String.format("%s and %s", selection, extraSelection);
            }
            ArrayList<String> selectionArgList = new ArrayList<String>();
            selectionArgList.add(String.valueOf(id));
            String[] extraSelectionArgs = SqlUtils.appendExtraWhereArgs(extra);
            if (extraSelectionArgs != null && extraSelectionArgs.length > 0) {
                selectionArgList.addAll(Arrays.asList(extraSelectionArgs));
            }
            if ((list = this.select(clazz, selection, selectionArgs = selectionArgList.toArray(new String[0]), null, null, null, null)).size() > 0) {
                return list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> List<T> select(Extra extra, Class<T> clazz) {
        String selection = SqlUtils.appendExtraWhereClause(extra);
        String[] selectionArgs = SqlUtils.appendExtraWhereArgs(extra);
        return this.select(clazz, selection, selectionArgs, null, null, null, null);
    }

    public <T> List<T> select(Class<T> clazz, String selection, String[] selectionArgs) {
        return this.select(clazz, selection, selectionArgs, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(Class<T> clazz, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        TableInfo tableInfo = this.checkTable(clazz);
        ArrayList<T> list = new ArrayList<T>();
        if (Logger.DEBUG) {
            Logger.d(TAG, " method[select], table[%s], selection[%s], selectionArgs%s, groupBy[%s], having[%s], orderBy[%s], limit[%s] ", tableInfo.getTableName(), selection, String.valueOf(Arrays.asList(selectionArgs)), String.valueOf(groupBy), String.valueOf(having), String.valueOf(orderBy), String.valueOf(limit));
        }
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add(tableInfo.getPrimaryKey().getColumn());
        for (TableColumn tableColumn : tableInfo.getColumns()) {
            columnList.add(tableColumn.getColumn());
        }
        long start = System.currentTimeMillis();
        Cursor cursor = this.db.query(tableInfo.getTableName(), columnList.toArray(new String[0]), selection, selectionArgs, groupBy, having, orderBy, limit);
        Logger.d(TAG, "table[%s] \u67e5\u8be2\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6 %s ms", tableInfo.getTableName(), String.valueOf(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        try {
            if (cursor.moveToFirst()) {
                do {
                    try {
                        T entity = clazz.newInstance();
                        this.bindSelectValue(entity, cursor, tableInfo.getPrimaryKey());
                        for (TableColumn column : tableInfo.getColumns()) {
                            this.bindSelectValue(entity, cursor, column);
                        }
                        list.add(entity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
        }
        finally {
            cursor.close();
        }
        Logger.d(TAG, "table[%s], \u8bbe\u7f6e\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6 %s ms", tableInfo.getTableName(), String.valueOf(System.currentTimeMillis() - start));
        Logger.d(TAG, "\u67e5\u8be2\u5230\u6570\u636e %d \u6761", list.size());
        return list;
    }

    public <T> void insert(Extra extra, T ... entities) {
        try {
            if (entities != null && entities.length > 0) {
                this.insert(extra, Arrays.asList(entities));
            } else {
                Logger.d(TAG, "method[insert(Extra extra, T... entities)], entities is empty");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void insertOrReplace(Extra extra, T ... entities) {
        try {
            if (entities != null && entities.length > 0) {
                this.insert(extra, Arrays.asList(entities), "INSERT OR REPLACE INTO ");
            } else {
                Logger.d(TAG, "method[insertOrReplace(Extra extra, T... entities)], entities is empty");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void insert(Extra extra, List<T> entityList) {
        try {
            this.insert(extra, entityList, "INSERT OR IGNORE INTO ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void insertOrReplace(Extra extra, List<T> entityList) {
        try {
            this.insert(extra, entityList, "INSERT OR REPLACE INTO ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void insert(Extra extra, List<T> entityList, String insertInto) {
        TableInfo tableInfo;
        if (entityList == null || entityList.size() == 0) {
            Logger.d(TAG, "method[insert(Extra extra, List<T> entityList)], entityList is empty");
            return;
        }
        TableInfo tableInfo2 = tableInfo = this.checkTable(entityList.get(0).getClass());
        synchronized (tableInfo2) {
            long start = System.currentTimeMillis();
            this.db.beginTransaction();
            try {
                String sql = SqlUtils.createSqlInsert(insertInto, tableInfo);
                Logger.v(TAG, insertInto + " sql = %s", sql);
                SQLiteStatement insertStatement = this.db.compileStatement(sql);
                long bindTime = 0L;
                long startTime = System.currentTimeMillis();
                for (T entity : entityList) {
                    this.bindInsertValues(extra, insertStatement, tableInfo, entity);
                    bindTime += System.currentTimeMillis() - startTime;
                    startTime = System.currentTimeMillis();
                    insertStatement.execute();
                }
                Logger.d(TAG, "bindvalues \u8017\u65f6 %s ms", bindTime + "");
                this.db.setTransactionSuccessful();
            }
            finally {
                this.db.endTransaction();
            }
            Logger.d(TAG, "\u8868 %s %s \u6570\u636e %d \u6761\uff0c \u6267\u884c\u65f6\u95f4 %s ms", tableInfo.getTableName(), insertInto, entityList.size(), String.valueOf(System.currentTimeMillis() - start));
            if (entityList.size() == 1 && tableInfo.getPrimaryKey() instanceof AutoIncrementTableColumn) {
                try (Cursor cursor = null;){
                    cursor = this.db.rawQuery("select last_insert_rowid() from " + tableInfo.getTableName(), null);
                    if (cursor.moveToFirst()) {
                        int newId = cursor.getInt(0);
                        Logger.d(TAG, "\u8868%s\u81ea\u589e\u4e3b\u952e[%d]", tableInfo.getTableName(), newId);
                        T bean = entityList.get(0);
                        try {
                            tableInfo.getPrimaryKey().getField().setAccessible(true);
                            tableInfo.getPrimaryKey().getField().set(bean, newId);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public <T> void update(Extra extra, T ... entities) {
        this.innerUpdate(extra, Arrays.asList(entities));
    }

    public <T> void update(Extra extra, List<T> entityList) {
        this.innerUpdate(extra, entityList);
    }

    private <T> void innerUpdate(Extra extra, List<T> entityList) {
        try {
            if (entityList != null && entityList.size() > 0) {
                TableInfo tableInfo = this.checkTable(entityList.get(0).getClass());
                for (int i = 0; i < entityList.size(); ++i) {
                    T t = entityList.get(i);
                    tableInfo.getPrimaryKey().getField().setAccessible(true);
                    Object id = tableInfo.getPrimaryKey().getField().get(t);
                    String whereClause = String.format(" %s = ? ", tableInfo.getPrimaryKey().getColumn());
                    String extraSelection = SqlUtils.appendExtraWhereClause(extra);
                    if (!TextUtils.isEmpty((CharSequence)extraSelection)) {
                        whereClause = String.format("%s and %s", whereClause, extraSelection);
                    }
                    ArrayList<String> selectionArgList = new ArrayList<String>();
                    selectionArgList.add(String.valueOf(id));
                    String[] extraSelectionArgs = SqlUtils.appendExtraWhereArgs(extra);
                    if (extraSelectionArgs != null && extraSelectionArgs.length > 0) {
                        selectionArgList.addAll(Arrays.asList(extraSelectionArgs));
                    }
                    String[] whereArgs = selectionArgList.toArray(new String[0]);
                    ContentValues values = new ContentValues();
                    for (TableColumn colunm : tableInfo.getColumns()) {
                        this.bindValue(values, colunm, t);
                    }
                    int rowId = this.db.update(tableInfo.getTableName(), values, whereClause, whereArgs);
                    if (!Logger.DEBUG) continue;
                    Logger.d(TAG, " method[update], table[%s], whereClause[%s], whereArgs[%s], rowId[%d]", tableInfo.getTableName(), whereClause, String.valueOf(Arrays.asList(whereArgs)), rowId);
                }
            } else {
                Logger.d(TAG, "method[update(Extra extra, T... entities)], entities is empty");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> int update(Class<?> clazz, ContentValues values, String whereClause, String[] whereArgs) {
        try {
            TableInfo tableInfo = this.checkTable(clazz);
            return this.db.update(tableInfo.getTableName(), values, whereClause, whereArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public <T> void deleteAll(Extra extra, Class<T> clazz) {
        try {
            TableInfo tableInfo = this.checkTable(clazz);
            String where = SqlUtils.appendExtraWhereClauseSql(extra);
            if (!TextUtils.isEmpty((CharSequence)where)) {
                where = " where " + where;
            }
            String sql = "DELETE FROM '" + tableInfo.getTableName() + "' " + where;
            Logger.d(TAG, "method[delete] table[%s], sql[%s]", tableInfo.getTableName(), sql);
            long start = System.currentTimeMillis();
            this.db.execSQL(sql);
            Logger.d(TAG, "\u8868 %s \u6e05\u7a7a\u6570\u636e, \u8017\u65f6 %s ms", tableInfo.getTableName(), String.valueOf(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void deleteById(Extra extra, Class<T> clazz, Object id) {
        try {
            TableInfo tableInfo = this.checkTable(clazz);
            String whereClause = String.format(" %s = ? ", tableInfo.getPrimaryKey().getColumn());
            String extraWhereClause = SqlUtils.appendExtraWhereClause(extra);
            if (!TextUtils.isEmpty((CharSequence)extraWhereClause)) {
                whereClause = String.format("%s and %s", whereClause, extraWhereClause);
            }
            ArrayList<String> whereArgList = new ArrayList<String>();
            whereArgList.add(String.valueOf(id));
            String[] extraWhereArgs = SqlUtils.appendExtraWhereArgs(extra);
            if (extraWhereArgs != null && extraWhereArgs.length > 0) {
                whereArgList.addAll(Arrays.asList(extraWhereArgs));
            }
            String[] whereArgs = whereArgList.toArray(new String[0]);
            if (Logger.DEBUG) {
                Logger.d(TAG, " method[deleteById], table[%s], id[%s], whereClause[%s], whereArgs%s ", tableInfo.getTableName(), String.valueOf(id), whereClause, String.valueOf(Arrays.asList(whereArgs)));
            }
            long start = System.currentTimeMillis();
            int rowCount = this.db.delete(tableInfo.getTableName(), whereClause, whereArgs);
            Logger.d(TAG, "\u8868 %s \u5220\u9664\u6570\u636e %d \u6761, \u8017\u65f6 %s ms", tableInfo.getTableName(), rowCount, String.valueOf(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> void delete(Class<T> clazz, String whereClause, String[] whereArgs) {
        try {
            TableInfo tableInfo = this.checkTable(clazz);
            long start = System.currentTimeMillis();
            int rowCount = this.db.delete(tableInfo.getTableName(), whereClause, whereArgs);
            if (Logger.DEBUG) {
                Logger.d(TAG, "method[delete], table[%s], whereClause[%s], whereArgs%s ", tableInfo.getTableName(), whereClause, String.valueOf(Arrays.asList(whereArgs)));
            }
            Logger.d(TAG, "\u8868 %s \u5220\u9664\u6570\u636e %d \u6761\uff0c\u8017\u65f6 %s ms", tableInfo.getTableName(), rowCount, String.valueOf(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long sum(Class<?> clazz, String column, String whereClause, String[] whereArgs) {
        TableInfo tableInfo = this.checkTable(clazz);
        if (TextUtils.isEmpty((CharSequence)column)) {
            return 0L;
        }
        String sql = null;
        if (TextUtils.isEmpty((CharSequence)whereClause)) {
            whereArgs = null;
            sql = String.format(" select sum(%s) as _sum_ from %s ", column, tableInfo.getTableName());
        } else {
            sql = String.format(" select sum(%s) as _sum_ from %s where %s ", column, tableInfo.getTableName(), whereClause);
        }
        Logger.d(TAG, "sum() --- > " + sql);
        Logger.d(TAG, whereArgs);
        try {
            long time = System.currentTimeMillis();
            Cursor cursor = this.db.rawQuery(sql, whereArgs);
            if (cursor.moveToFirst()) {
                long sum = cursor.getLong(cursor.getColumnIndex("_sum_"));
                Logger.d(TAG, "sum = %s \u8017\u65f6%sms", String.valueOf(sum), String.valueOf(System.currentTimeMillis() - time));
                cursor.close();
                return sum;
            }
        }
        catch (Exception e) {
            Logger.printExc(SqliteUtility.class, e);
        }
        return 0L;
    }

    public long count(Class<?> clazz, String whereClause, String[] whereArgs) {
        TableInfo tableInfo = this.checkTable(clazz);
        String sql = null;
        if (TextUtils.isEmpty((CharSequence)whereClause)) {
            whereArgs = null;
            sql = String.format(" select count(*) as _count_ from %s ", tableInfo.getTableName());
        } else {
            sql = String.format(" select count(*) as _count_ from %s where %s ", tableInfo.getTableName(), whereClause);
        }
        Logger.d(TAG, "count --- > " + sql);
        Logger.d(TAG, whereArgs);
        try {
            long time = System.currentTimeMillis();
            Cursor cursor = this.db.rawQuery(sql, whereArgs);
            if (cursor.moveToFirst()) {
                long count = cursor.getLong(cursor.getColumnIndex("_count_"));
                Logger.d(TAG, "count = %s \u8017\u65f6%sms", String.valueOf(count), String.valueOf(System.currentTimeMillis() - time));
                cursor.close();
                return count;
            }
        }
        catch (Exception e) {
            Logger.printExc(SqliteUtility.class, e);
        }
        return 0L;
    }

    private <T> void bindUpdateValues(ContentValues values, TableInfo tableInfo, T entity) {
        for (int i = 0; i < tableInfo.getColumns().size(); ++i) {
            TableColumn column = tableInfo.getColumns().get(i);
            this.bindValue(values, column, entity);
        }
        long createAt = System.currentTimeMillis();
        values.put("com_m_common_createat", Long.valueOf(createAt));
    }

    private <T> void bindInsertValues(Extra extra, SQLiteStatement insertStatement, TableInfo tableInfo, T entity) {
        int index = 1;
        if (!(tableInfo.getPrimaryKey() instanceof AutoIncrementTableColumn)) {
            this.bindValue(insertStatement, index++, tableInfo.getPrimaryKey(), entity);
        }
        for (int i = 0; i < tableInfo.getColumns().size(); ++i) {
            TableColumn column = tableInfo.getColumns().get(i);
            this.bindValue(insertStatement, index++, column, entity);
        }
        String owner = extra == null || TextUtils.isEmpty((CharSequence)extra.getOwner()) ? "" : extra.getOwner();
        insertStatement.bindString(index++, owner);
        String key = extra == null || TextUtils.isEmpty((CharSequence)extra.getKey()) ? "" : extra.getKey();
        insertStatement.bindString(index++, key);
        long createAt = System.currentTimeMillis();
        insertStatement.bindLong(index, createAt);
    }

    private <T> void bindValue(ContentValues values, TableColumn column, T entity) {
        try {
            column.getField().setAccessible(true);
            Object value = column.getField().get(entity);
            if (value == null) {
                return;
            }
            if (Logger.DEBUG) {
                Logger.v(TAG, " method[bindValue_ContentValues], key[%s], value[%s]", column.getColumn(), value + "");
            }
            if ("object".equalsIgnoreCase(column.getDataType())) {
                values.put(column.getColumn(), String.valueOf(value));
            } else if ("INTEGER".equalsIgnoreCase(column.getColumnType())) {
                values.put(column.getColumn(), Long.valueOf(Long.parseLong(value.toString())));
            } else if ("REAL".equalsIgnoreCase(column.getColumnType())) {
                values.put(column.getColumn(), Double.valueOf(Double.parseDouble(value.toString())));
            } else if ("BLOB".equalsIgnoreCase(column.getColumnType())) {
                values.put(column.getColumn(), (byte[])value);
            } else if ("TEXT".equalsIgnoreCase(column.getColumnType())) {
                values.put(column.getColumn(), value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.w(TAG, "\u5c5e\u6027 %s bindvalue \u5f02\u5e38", column.getField().getName());
        }
    }

    private <T> void bindValue(SQLiteStatement insertStatement, int index, TableColumn column, T entity) {
        try {
            column.getField().setAccessible(true);
            Object value = column.getField().get(entity);
            if (value == null) {
                insertStatement.bindNull(index);
                return;
            }
            if (Logger.DEBUG) {
                Logger.v(TAG, " method[bindValue_SQLiteStatement], key[%s], value[%s]", column.getColumn(), value + "");
            }
            if ("object".equalsIgnoreCase(column.getDataType())) {
                insertStatement.bindString(index, String.valueOf(value));
            } else if ("INTEGER".equalsIgnoreCase(column.getColumnType())) {
                insertStatement.bindLong(index, Long.parseLong(value.toString()));
            } else if ("REAL".equalsIgnoreCase(column.getColumnType())) {
                insertStatement.bindDouble(index, Double.parseDouble(value.toString()));
            } else if ("BLOB".equalsIgnoreCase(column.getColumnType())) {
                insertStatement.bindBlob(index, (byte[])value);
            } else if ("TEXT".equalsIgnoreCase(column.getColumnType())) {
                insertStatement.bindString(index, value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.w(TAG, "\u5c5e\u6027 %s bindvalue \u5f02\u5e38", column.getField().getName());
        }
    }

    private <T> void bindSelectValue(T entity, Cursor cursor, TableColumn column) {
        Field field = column.getField();
        field.setAccessible(true);
        try {
            if (field.getType().getName().equals("int") || field.getType().getName().equals("java.lang.Integer")) {
                field.set(entity, cursor.getInt(cursor.getColumnIndex(column.getColumn())));
            } else if (field.getType().getName().equals("long") || field.getType().getName().equals("java.lang.Long")) {
                field.set(entity, cursor.getLong(cursor.getColumnIndex(column.getColumn())));
            } else if (field.getType().getName().equals("float") || field.getType().getName().equals("java.lang.Float")) {
                field.set(entity, Float.valueOf(cursor.getFloat(cursor.getColumnIndex(column.getColumn()))));
            } else if (field.getType().getName().equals("double") || field.getType().getName().equals("java.lang.Double")) {
                field.set(entity, cursor.getDouble(cursor.getColumnIndex(column.getColumn())));
            } else if (field.getType().getName().equals("boolean") || field.getType().getName().equals("java.lang.Boolean")) {
                field.set(entity, Boolean.parseBoolean(cursor.getString(cursor.getColumnIndex(column.getColumn()))));
            } else if (field.getType().getName().equals("char") || field.getType().getName().equals("java.lang.Character")) {
                field.set(entity, Character.valueOf(cursor.getString(cursor.getColumnIndex(column.getColumn())).toCharArray()[0]));
            } else if (field.getType().getName().equals("byte") || field.getType().getName().equals("java.lang.Byte")) {
                field.set(entity, (byte)cursor.getInt(cursor.getColumnIndex(column.getColumn())));
            } else if (field.getType().getName().equals("short") || field.getType().getName().equals("java.lang.Short")) {
                field.set(entity, cursor.getShort(cursor.getColumnIndex(column.getColumn())));
            } else if (field.getType().getName().equals("java.lang.String")) {
                field.set(entity, cursor.getString(cursor.getColumnIndex(column.getColumn())));
            } else if (field.getType().getName().equals("[B")) {
                field.set(entity, cursor.getBlob(cursor.getColumnIndex(column.getColumn())));
            } else {
                String text = cursor.getString(cursor.getColumnIndex(column.getColumn()));
                field.set(entity, text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T> TableInfo checkTable(Class<T> clazz) {
        TableInfo tableInfo = TableInfoUtils.exist(this.dbName, clazz);
        if (tableInfo == null) {
            tableInfo = TableInfoUtils.newTable(this.dbName, this.db, clazz);
        }
        return tableInfo;
    }
}

