/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.http;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.tencent.bugly.crashreport.CrashReport;
import com.yoogor.abc.network.http.AnalysisState;
import com.yoogor.abc.network.http.HttpException;
import com.yoogor.abc.network.http.OKProgressHelper;
import com.yoogor.abc.network.http.OkAnalysHelper;
import com.yoogor.abc.network.http.interf.CacheCallback;
import com.yoogor.abc.network.http.interf.DownloadCallback;
import com.yoogor.abc.network.http.interf.HttpCallback;
import com.yoogor.abc.network.http.interf.RequestProcessor;
import com.yoogor.abc.network.http.interf.StatusCode;
import com.yoogor.abc.network.http.interf.UploadCallback;
import com.yoogor.abc.network.utils.CookieStore;
import com.yoogor.abc.network.utils.DnsUtil;
import com.yoogor.abc.network.utils.IMEIUtil;
import com.yoogor.abc.network.utils.MD5;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.json.JSONException;
import org.json.JSONObject;

public class OkRequestHelper {
    private static final String TAG = OkRequestHelper.class.getSimpleName();
    private static X509TrustManager trustAllManager;
    private static OkHttpClient client;
    private static OkHttpClient uploadClient;
    private static Application mApplication;
    private static List<Pair<Call, Callback>> networkRequests;
    private static RequestProcessor requestProcessor;
    private static int TimeOutUnit;
    static Interceptor interceptor;
    static Interceptor cacheIntecepter;
    private static final Interceptor REWRITE_CACHE_CONTROL_INTERCEPTOR;
    private static final Interceptor LoggingInterceptor;
    private static ConnectionChangeReceiver myReceiver;
    private static NetState mNetState;
    private static final String CHARSET_NAME = "UTF-8";
    public static final MediaType FORM_URLENCODED;
    private String desc = "";
    private Map<String, String> params = new HashMap<String, String>();
    private String host = "";
    private String path = "";
    private String url = "";
    private int tag;
    private HttpCallback httpCallback;
    private DownloadCallback downloadCallback = null;
    private UploadCallback uploadCallback = null;
    private Call call;
    private boolean needLog = false;
    private boolean saveCache = false;
    private CacheCallback cacheCallback;
    private static Cache cache;
    private String destPath;
    private boolean overWrite = false;
    private List<String> files = new ArrayList<String>();
    private List<Pair<String, String>> filesList = new ArrayList<Pair<String, String>>();
    private Map<String, Pair<String, String>> filesMap = new HashMap<String, Pair<String, String>>();
    private Map<String, String> header = new HashMap<String, String>();
    private Map<String, String> defaultHeader = new HashMap<String, String>(){
        {
            this.put("charset", OkRequestHelper.CHARSET_NAME);
            this.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        }
    };
    AnalysisState analysisState = new AnalysisState();
    private static Map<String, String> dnsFilter;

    private static void dispatchNetworkRequest() {
        if (client.dispatcher().queuedCallsCount() < 1) {
            OkRequestHelper.enqueueNetworkRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void enqueueNetworkRequest() {
        List<Pair<Call, Callback>> list = networkRequests;
        synchronized (list) {
            if (networkRequests.size() > 0) {
                Pair<Call, Callback> pair = networkRequests.remove(0);
                ((Call)pair.first).enqueue((Callback)pair.second);
            }
        }
    }

    public static void clearCookie() {
        CookieStore.getInstance().removeAll();
    }

    public static String getCookieForUrl(String url) {
        String ret = "";
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        List<Cookie> cookies = CookieStore.getInstance().loadForRequest(httpUrl);
        StringBuilder stringBuilder = new StringBuilder("");
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                if (!cookie.name().equals("session_key")) continue;
                stringBuilder.append(cookie.name() + "=" + cookie.value());
            }
        }
        return stringBuilder.toString();
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{trustAllManager}, new SecureRandom());
            sSLSocketFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sSLSocketFactory;
    }

    public static void initRequestHelper(Application application) {
        mApplication = application;
        cache = new Cache(application.getCacheDir(), 0x500000L);
        OkRequestHelper.resetConfig();
    }

    public String getAnalysisState() {
        return this.analysisState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        List<Pair<Call, Callback>> list = networkRequests;
        synchronized (list) {
            Iterator<Pair<Call, Callback>> iterator = networkRequests.iterator();
            while (iterator.hasNext()) {
                Pair<Call, Callback> pair = iterator.next();
                if (pair.first != this.call) continue;
                iterator.remove();
                break;
            }
            if (this.call != null) {
                this.call.cancel();
            }
        }
    }

    public void url(String url) {
        if (url != null) {
            this.url = url;
        }
    }

    public String getDesc() {
        return this.desc;
    }

    public void hostAndPath(String host, String path) {
        if (host != null) {
            this.host = host;
        }
        if (path != null) {
            this.path = path;
        }
    }

    public void setParams(Map<String, String> params) {
        if (params != null) {
            this.params = params;
        }
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void tag(int tag) {
        this.tag = tag;
    }

    public void setRequestHeader(Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> h : headers.entrySet()) {
                this.header.put(h.getKey(), h.getValue());
            }
        }
    }

    public void setFileDestPath(boolean overWrite, String destPath) {
        this.overWrite = overWrite;
        if (destPath != null) {
            this.destPath = destPath;
        }
    }

    public void setHttpCallback(HttpCallback httpCallback) {
        this.httpCallback = httpCallback;
    }

    public void setUploadProgressCallback(UploadCallback downloadCallback) {
        this.uploadCallback = downloadCallback;
    }

    public void setDownloadProgressCallback(DownloadCallback downloadCallback) {
        this.downloadCallback = downloadCallback;
    }

    public void setSaveCache(CacheCallback cacheCallback) {
        this.saveCache = true;
        this.cacheCallback = cacheCallback;
    }

    public void getEnqueue() {
        StringBuilder urlBuilder;
        this.needLog = true;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "\u7f51\u7edc\u8bf7\u6c42";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.httpCallback != null) {
                this.httpCallback.onFail(this.tag, StatusCode.ERROR_PARAM, new HttpException(StatusCode.ERROR_PARAM, "HttpGet must set url!"));
            }
            return;
        }
        String params = this.getFormateParams();
        if (!TextUtils.isEmpty((CharSequence)params)) {
            if (!urlBuilder.toString().contains("?")) {
                urlBuilder.append("?");
            }
            if (!urlBuilder.toString().endsWith("?") && !urlBuilder.toString().endsWith("&")) {
                urlBuilder.append("&");
            }
            urlBuilder.append(params);
        }
        String urlStr = urlBuilder.toString();
        Request.Builder builder = new Request.Builder().url(urlStr);
        for (Map.Entry<String, String> entry : this.defaultHeader.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        Callback okCallback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onFail(OkRequestHelper.this.tag, OkRequestHelper.this.parseStatusCode(e), new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                Log.e((String)"code", (String)(String.valueOf(response.code()) + response));
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onData(OkRequestHelper.this.tag, 200 == response.code(), response.code(), OkRequestHelper.this.replaceJson(response.body().string()));
                }
            }
        };
        this.enqueue(builder, okCallback, client);
    }

    public void postEnqueue() {
        StringBuilder urlBuilder;
        this.needLog = true;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "post\u7f51\u7edc\u8bf7\u6c42";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.httpCallback != null) {
                this.httpCallback.onFail(this.tag, StatusCode.ERROR_PARAM, new HttpException(StatusCode.ERROR_PARAM, "HttpPost must set url!"));
            }
            return;
        }
        String urlStr = urlBuilder.toString();
        Request.Builder builder = new Request.Builder().url(urlStr);
        for (Map.Entry<String, String> entry : this.defaultHeader.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        builder.post(RequestBody.create((MediaType)FORM_URLENCODED, (String)this.getFormateParams()));
        Callback okCallback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onFail(OkRequestHelper.this.tag, OkRequestHelper.this.parseStatusCode(e), new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onData(OkRequestHelper.this.tag, 200 == response.code(), response.code(), OkRequestHelper.this.replaceJson(response.body().string()));
                }
            }
        };
        this.enqueue(builder, okCallback, client);
    }

    public void postDataByte(final String json) {
        StringBuilder urlBuilder;
        this.needLog = true;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "post\u6570\u636e\u6d41\u7f51\u7edc\u8bf7\u6c42";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.httpCallback != null) {
                this.httpCallback.onFail(this.tag, StatusCode.ERROR_PARAM, new HttpException(StatusCode.ERROR_PARAM, "HttpPost must set url!"));
            }
            return;
        }
        if (json == null || "".equals(json)) {
            if (this.httpCallback != null) {
                this.httpCallback.onFail(this.tag, StatusCode.ERROR_PARAM, new HttpException(StatusCode.ERROR_PARAM, "Post data must be json"));
            }
            return;
        }
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            if (this.httpCallback != null) {
                this.httpCallback.onFail(this.tag, StatusCode.ERROR_PARAM, new HttpException(StatusCode.ERROR_PARAM, "data must be json:" + json));
            }
            return;
        }
        String urlStr = urlBuilder.toString();
        Request.Builder builder = new Request.Builder().url(urlStr);
        for (Map.Entry<String, String> entry : this.defaultHeader.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        RequestBody body = new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/json; charset=utf-8");
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(json.getBytes());
            }
        };
        builder.post(body);
        Callback okCallback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onFail(OkRequestHelper.this.tag, OkRequestHelper.this.parseStatusCode(e), new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onData(OkRequestHelper.this.tag, 200 == response.code(), response.code(), OkRequestHelper.this.replaceJson(response.body().string()));
                }
            }
        };
        this.enqueue(builder, okCallback, client);
    }

    public void postEnQueueGzip() {
        StringBuilder urlBuilder;
        this.needLog = true;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "post\u4e0a\u4f20\u538b\u7f29\u6587\u4ef6\u7f51\u7edc\u8bf7\u6c42";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.httpCallback != null) {
                this.httpCallback.onFail(this.tag, StatusCode.ERROR_PARAM, new HttpException("PostEnQueueGzip must set url!"));
            }
            return;
        }
        String urlStr = urlBuilder.toString();
        Request.Builder builder = new Request.Builder().url(urlStr);
        for (Map.Entry<String, String> entry : this.defaultHeader.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        builder.addHeader("Content-Encoding", "gzip");
        String formatParams = this.formatParamsCommon();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        byte[] data = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(formatParams.getBytes(CHARSET_NAME));
            gzip.flush();
            gzip.finish();
            gzip.close();
            data = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        builder.post(RequestBody.create((MediaType)FORM_URLENCODED, data));
        Callback okCallback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onFail(OkRequestHelper.this.tag, OkRequestHelper.this.parseStatusCode(e), new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (OkRequestHelper.this.httpCallback != null) {
                    OkRequestHelper.this.httpCallback.onData(OkRequestHelper.this.tag, 200 == response.code(), response.code(), OkRequestHelper.this.replaceJson(response.body().string()));
                }
            }
        };
        this.enqueue(builder, okCallback, client);
    }

    public String getCacheKey() {
        StringBuilder urlBuilder = new StringBuilder(this.getUrl());
        String urlStr = urlBuilder.toString();
        return MD5.getMD5(urlStr + this.getFormateParams());
    }

    public void downloadFile() {
        StringBuilder urlBuilder;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "\u4e0b\u8f7d\u6587\u4ef6";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "GetFileProgress url can't be null!"));
            }
            return;
        }
        String params = this.getFormateParams();
        if (!TextUtils.isEmpty((CharSequence)params)) {
            if (!urlBuilder.toString().contains("?")) {
                urlBuilder.append("?");
            }
            if (!urlBuilder.toString().endsWith("?") && !urlBuilder.toString().endsWith("&")) {
                urlBuilder.append("&");
            }
            urlBuilder.append(params);
        }
        String urlStr = urlBuilder.toString();
        if (TextUtils.isEmpty((CharSequence)this.destPath)) {
            if (this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "GetFileProgress: destPath can't be null!"));
            }
            return;
        }
        final File destFile = new File(this.destPath);
        if (!destFile.getParentFile().exists()) {
            boolean ret = destFile.getParentFile().mkdirs();
            if (!ret && this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PERMISSION_DENIED, "GetFileProgress: destPath permission denied!"));
            }
            return;
        }
        if (destFile.exists()) {
            if (this.overWrite) {
                destFile.delete();
            } else {
                if (this.downloadCallback != null) {
                    this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "GetFileProgress: file already exist!"));
                }
                return;
            }
        }
        Request.Builder builder = new Request.Builder().url(urlStr);
        OkHttpClient.Builder builder1 = client.newBuilder();
        builder1.interceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new OKProgressHelper.ProgressResponseBody(OkRequestHelper.this.tag, originalResponse.body(), OkRequestHelper.this.downloadCallback)).build();
            }
        });
        Callback okCallback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.downloadCallback != null) {
                    OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                block12: {
                    if (response.isSuccessful()) {
                        byte[] buffer = new byte[8192];
                        try {
                            boolean result = destFile.createNewFile();
                            if (!result) {
                                if (OkRequestHelper.this.downloadCallback != null) {
                                    OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(StatusCode.ERROR_PERMISSION_DENIED, "GetFileProgress destPath permission denied!"));
                                }
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (OkRequestHelper.this.downloadCallback != null) {
                                OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(StatusCode.ERROR_PERMISSION_DENIED, "GetFileProgress destPath permission denied!"));
                            }
                            return;
                        }
                        try {
                            BufferedInputStream reader = new BufferedInputStream(response.body().byteStream());
                            BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(destFile));
                            int n = 0;
                            while ((n = reader.read(buffer, 0, buffer.length)) != -1) {
                                writer.write(buffer, 0, n);
                            }
                            writer.flush();
                            if (OkRequestHelper.this.downloadCallback != null) {
                                OkRequestHelper.this.downloadCallback.onSucess(OkRequestHelper.this.tag, destFile);
                            }
                            break block12;
                        }
                        catch (Exception e) {
                            if (OkRequestHelper.this.downloadCallback != null) {
                                OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                            }
                            break block12;
                        }
                    }
                    if (OkRequestHelper.this.downloadCallback != null) {
                        OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(response.code(), response.body().string()));
                    }
                }
            }
        };
        Request request = builder.tag((Object)this).build();
        this.call = builder1.build().newCall(request);
        this.call.enqueue(okCallback);
    }

    public void downloadFileRange() {
        StringBuilder urlBuilder;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "\u4e0b\u8f7d\u6587\u4ef6";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "downloadFileRange url can't be null!"));
            }
            return;
        }
        String params = this.getFormateParams();
        if (!TextUtils.isEmpty((CharSequence)params)) {
            if (!urlBuilder.toString().contains("?")) {
                urlBuilder.append("?");
            }
            if (!urlBuilder.toString().endsWith("?") && !urlBuilder.toString().endsWith("&")) {
                urlBuilder.append("&");
            }
            urlBuilder.append(params);
        }
        String urlStr = urlBuilder.toString();
        if (TextUtils.isEmpty((CharSequence)this.destPath)) {
            if (this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "downloadFileRange: destPath can't be null!"));
            }
            return;
        }
        final File destFile = new File(this.destPath);
        if (!destFile.getParentFile().exists()) {
            boolean ret = destFile.getParentFile().mkdirs();
            if (!ret && this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PERMISSION_DENIED, "downloadFileRange: destPath permission denied!"));
            }
            return;
        }
        Request.Builder builder = new Request.Builder().url(urlStr);
        if (destFile.exists()) {
            if (this.overWrite) {
                destFile.delete();
            } else if (destFile.length() > 0L) {
                builder.addHeader("Range", "bytes=" + destFile.length() + "-");
            }
        }
        Callback okCallback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.downloadCallback != null) {
                    OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                block14: {
                    if (response.isSuccessful()) {
                        byte[] buffer = new byte[8192];
                        try {
                            boolean result;
                            if (!destFile.exists() && !(result = destFile.createNewFile())) {
                                if (OkRequestHelper.this.downloadCallback != null) {
                                    OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(StatusCode.ERROR_PERMISSION_DENIED, "downloadFileRange destPath permission denied!"));
                                }
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (OkRequestHelper.this.downloadCallback != null) {
                                OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(StatusCode.ERROR_PERMISSION_DENIED, "downloadFileRange destPath permission denied!"));
                            }
                            return;
                        }
                        try {
                            BufferedInputStream reader = new BufferedInputStream(response.body().byteStream());
                            RandomAccessFile oSavedFile = new RandomAccessFile(destFile, "rw");
                            if (response.code() == 206) {
                                oSavedFile.seek(destFile.length());
                            }
                            int n = 0;
                            long fullLength = response.body().contentLength() + oSavedFile.length();
                            while ((n = reader.read(buffer, 0, buffer.length)) != -1) {
                                oSavedFile.write(buffer, 0, n);
                                if (OkRequestHelper.this.downloadCallback == null) continue;
                                OkRequestHelper.this.downloadCallback.onProgress(OkRequestHelper.this.tag, oSavedFile.length(), fullLength);
                            }
                            oSavedFile.close();
                            if (OkRequestHelper.this.downloadCallback != null) {
                                OkRequestHelper.this.downloadCallback.onSucess(OkRequestHelper.this.tag, destFile);
                            }
                            break block14;
                        }
                        catch (Exception e) {
                            if (OkRequestHelper.this.downloadCallback != null) {
                                OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                            }
                            break block14;
                        }
                    }
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    if (OkRequestHelper.this.downloadCallback != null) {
                        OkRequestHelper.this.downloadCallback.onFail(OkRequestHelper.this.tag, new HttpException(response.code(), response.body().string()));
                    }
                }
            }
        };
        this.enqueue(builder, okCallback, client);
    }

    public void setFiles(Map<String, Pair<String, String>> files) {
        if (files != null) {
            this.filesMap.putAll(files);
        }
    }

    public void setFiles(List<Pair<String, String>> files) {
        if (files != null) {
            this.filesList.addAll(files);
        }
    }

    public void setFiles(String[] files) {
        if (files != null) {
            this.files.addAll(Arrays.asList(files));
        }
    }

    public void uploadFiles() {
        StringBuilder urlBuilder;
        this.needLog = true;
        if (TextUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = "\u4e0a\u4f20\u6587\u4ef6";
        }
        if ((urlBuilder = new StringBuilder(this.getUrl())).length() == 0) {
            if (this.uploadCallback != null) {
                this.uploadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "uploadFileProgress url can't be null!"));
            }
            return;
        }
        String urlStr = urlBuilder.toString();
        if (this.files == null) {
            if (this.downloadCallback != null) {
                this.downloadCallback.onFail(this.tag, new HttpException(StatusCode.ERROR_PARAM, "uploadFileProgress files can't be null!"));
            }
            return;
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        if (this.params != null) {
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\""}), RequestBody.create(null, (String)entry.getValue()));
            }
        }
        String fileStr = "";
        for (String string : this.files) {
            builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + string + "\"; filename=\"" + string + "\""}), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)new File(string)));
            fileStr = fileStr + string;
        }
        for (Pair<String, String> pair : this.filesList) {
            builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + (String)pair.first + "\"; filename=\"" + (String)pair.second + "\""}), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)new File((String)pair.second)));
            fileStr = fileStr + (String)pair.first;
        }
        for (Map.Entry<String, Pair<String, String>> entry : this.filesMap.entrySet()) {
            builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\"; filename=\"" + (String)entry.getValue().first + "\""}), RequestBody.create((MediaType)MediaType.parse((String)((String)entry.getValue().second)), (File)new File((String)entry.getValue().first)));
            fileStr = fileStr + (String)entry.getValue().first;
        }
        Request.Builder builder2 = new Request.Builder().url(urlStr);
        for (Map.Entry<String, String> entry : this.defaultHeader.entrySet()) {
            builder2.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            builder2.addHeader(entry.getKey(), entry.getValue());
        }
        builder2.post(OkRequestHelper.buildRequestBody(this.tag, (RequestBody)builder.build(), this.uploadCallback));
        Callback callback = new Callback(){

            public void onFailure(Call call, IOException e) {
                if (OkRequestHelper.this.uploadCallback != null) {
                    OkRequestHelper.this.uploadCallback.onFail(OkRequestHelper.this.tag, new HttpException(OkRequestHelper.this.parseStatusCode(e), e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (OkRequestHelper.this.uploadCallback != null) {
                    OkRequestHelper.this.uploadCallback.onData(OkRequestHelper.this.tag, 200 == response.code(), response.code(), OkRequestHelper.this.replaceJson(response.body().string()));
                }
            }
        };
        this.enqueue(builder2, callback, uploadClient);
    }

    private String replaceJson(String data) {
        String json = data;
        if (json != null && json.endsWith(";")) {
            json = json.substring(0, json.length() - 1);
        }
        if (json != null && data.startsWith("null")) {
            json = json.replaceFirst("null", "");
        }
        if (json != null && data.startsWith("callback")) {
            json = json.replaceFirst("callback", "");
        }
        if (json != null && data.startsWith("jsonp")) {
            json = json.replaceFirst("jsonp", "");
        }
        if (json != null && json.startsWith("(") && json.endsWith(")")) {
            json = json.replaceFirst("\\(", "");
            json = json.substring(0, json.length() - 1);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Request.Builder reqBuilder, Callback callback, OkHttpClient client) {
        Request request = reqBuilder.tag((Object)this).build();
        this.call = client.newCall(request);
        List<Pair<Call, Callback>> list = networkRequests;
        synchronized (list) {
            networkRequests.add(0, (Pair<Call, Callback>)new Pair((Object)this.call, (Object)callback));
        }
        OkRequestHelper.dispatchNetworkRequest();
    }

    @VisibleForTesting
    public static OkHttpClient clientProvider() {
        return client;
    }

    public static void setDnsFilter(Map<String, String> filter) {
        dnsFilter.putAll(filter);
    }

    private static void resetConfig() {
        trustAllManager = new TrustAllManager();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cookieJar((CookieJar)CookieStore.getInstance());
        builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        builder.connectTimeout((long)TimeOutUnit, TimeUnit.SECONDS);
        builder.readTimeout((long)TimeOutUnit, TimeUnit.SECONDS);
        builder.writeTimeout((long)TimeOutUnit, TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        builder.cache(cache);
        builder.dns(new Dns(){

            public List<InetAddress> lookup(String hostname) throws UnknownHostException {
                Log.e((String)"lookup", (String)("hostname:" + hostname));
                if (dnsFilter.containsKey(hostname) && !TextUtils.isEmpty((CharSequence)((CharSequence)dnsFilter.get(hostname)))) {
                    ArrayList<InetAddress> ret = new ArrayList<InetAddress>();
                    ret.add(InetAddress.getByName((String)dnsFilter.get(hostname)));
                    return ret;
                }
                return Arrays.asList(InetAddress.getAllByName(hostname));
            }
        });
        builder.addInterceptor(OkAnalysHelper.analysisIntercepter());
        builder.addInterceptor(interceptor);
        builder.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                if (!response.isSuccessful() && 304 != response.code()) {
                    OkRequestHelper.uploadBuglyResponseError(new HttpException("http response code:" + response.code()), response.request().url().toString());
                }
                return response;
            }
        });
        builder.networkInterceptors().add(cacheIntecepter);
        client = builder.build();
        if (uploadClient == null) {
            uploadClient = client.newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.MINUTES).writeTimeout(60L, TimeUnit.MINUTES).build();
        }
    }

    private static Request buildIpHostRequest(Request source) {
        String host = source.url().host();
        if (TextUtils.isEmpty((CharSequence)host)) {
            Log.e((String)TAG, (String)("buildIpHostRequest: parse host failed." + source.url().host()));
            return source;
        }
        String ip = "";
        try {
            ip = DnsUtil.get().query(host);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ip == null || ip.length() == 0) {
            Log.e((String)TAG, (String)("buildIpHostRequest: query ip failed." + host));
            return source;
        }
        String url = source.url().url().toString().replace(host, ip);
        Request.Builder builder = new Request.Builder();
        builder.url(url).method(source.method(), source.body()).headers(source.headers()).tag(source.tag());
        builder.removeHeader("Host");
        builder.addHeader("Host", host);
        return builder.build();
    }

    private static void changeNetState(NetState newState) {
        if (newState != mNetState) {
            mNetState = newState;
            switch (mNetState) {
                case NET_NO: {
                    break;
                }
                case NET_2G: {
                    TimeOutUnit = 60;
                    OkRequestHelper.resetConfig();
                    break;
                }
                case NET_3G: {
                    TimeOutUnit = 40;
                    OkRequestHelper.resetConfig();
                    break;
                }
                case NET_4G: {
                    TimeOutUnit = 20;
                    OkRequestHelper.resetConfig();
                    break;
                }
                case NET_WIFI: {
                    TimeOutUnit = 20;
                    OkRequestHelper.resetConfig();
                    break;
                }
            }
        }
    }

    private StatusCode parseStatusCode(Exception e) {
        if (mNetState == NetState.NET_NO) {
            return StatusCode.ERROR_CONNECTION_NONE;
        }
        if (e != null) {
            this.uploadBuglyError(e);
        }
        if (e instanceof ConnectException) {
            return StatusCode.ERROR_CONNECTION;
        }
        if (e instanceof BindException) {
            return StatusCode.ERROR_BIND;
        }
        if (e instanceof SocketTimeoutException) {
            return StatusCode.ERROR_SOCKET_TIME_OUT;
        }
        return StatusCode.ERROR_OTHER;
    }

    private void uploadBuglyError(Throwable t) {
        CrashReport.setUserSceneTag((Context)mApplication, (int)31727);
        CrashReport.putUserData((Context)mApplication, (String)"imei", (String)IMEIUtil.getPhoneIMEI((Context)mApplication));
        CrashReport.putUserData((Context)mApplication, (String)"url", (String)this.getUrl());
        CrashReport.postCatchedException((Throwable)t);
    }

    private static void uploadBuglyResponseError(Throwable t, String url) {
        CrashReport.setUserSceneTag((Context)mApplication, (int)31727);
        CrashReport.putUserData((Context)mApplication, (String)"imei", (String)IMEIUtil.getPhoneIMEI((Context)mApplication));
        CrashReport.putUserData((Context)mApplication, (String)"url", (String)url);
        CrashReport.postCatchedException((Throwable)t);
    }

    public static void setRequestProcessor(RequestProcessor _requestProcessor) {
        requestProcessor = _requestProcessor;
    }

    private String formatParamsCommon() {
        StringBuilder sb = new StringBuilder();
        if (this.params != null) {
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
            }
        }
        return sb.toString();
    }

    private String getUrl() {
        StringBuilder stringBuilder = new StringBuilder(this.url);
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.host);
            stringBuilder.append(this.path);
        }
        return stringBuilder.toString();
    }

    private String getFormateParams() {
        StringBuilder sb = new StringBuilder("");
        if (this.params != null) {
            try {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    if (sb.length() > 0) {
                        sb.append("&");
                    }
                    sb.append(URLEncoder.encode(String.valueOf(entry.getKey()), CHARSET_NAME) + "=" + URLEncoder.encode(!TextUtils.isEmpty((CharSequence)entry.getValue()) ? entry.getValue() : "", CHARSET_NAME));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void printLog(String data) {
        if (this.needLog) {
            Log.e((String)"OkRequestHelper", (String)(this.getDesc() + ":------>" + data));
        }
    }

    private static RequestBody buildRequestBody(int tag, RequestBody requestBody, UploadCallback progressListener) {
        return new OKProgressHelper.ProgressRequestBody(tag, requestBody, progressListener);
    }

    static {
        client = null;
        uploadClient = null;
        networkRequests = new ArrayList<Pair<Call, Callback>>();
        requestProcessor = null;
        TimeOutUnit = 60;
        interceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                if (requestProcessor != null) {
                    request = requestProcessor.processRequest(request);
                    return chain.proceed(request);
                }
                Request request1 = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                Response response = chain.proceed(request1);
                if (response.isSuccessful()) {
                    Response response1;
                    String modifiedDate = response.header("Last-Modified");
                    String etag = response.header("ETag");
                    String controll = response.header("Cache-Control");
                    Request.Builder request2 = request.newBuilder();
                    if (!TextUtils.isEmpty((CharSequence)etag)) {
                        request2.addHeader("If-None-Match", etag);
                    }
                    if (!TextUtils.isEmpty((CharSequence)modifiedDate)) {
                        request2.addHeader("If-Modified-Since", modifiedDate);
                    }
                    if (!TextUtils.isEmpty((CharSequence)controll) && !TextUtils.equals((CharSequence)controll, (CharSequence)CacheControl.FORCE_CACHE.toString())) {
                        request2.addHeader("Cache-Control", controll);
                    }
                    if (304 != (response1 = chain.proceed(request2.build())).code()) {
                        response = response1;
                    } else {
                        Log.e((String)"dada", (String)"304");
                    }
                } else {
                    response = chain.proceed(request);
                }
                OkRequestHelper.dispatchNetworkRequest();
                return response;
            }
        };
        cacheIntecepter = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                long t1 = System.nanoTime();
                Logger.getLogger("dada").info(String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
                Response response = chain.proceed(chain.request());
                long t2 = System.nanoTime();
                Logger.getLogger("dada").info(String.format("Received response for %s  code:%s in %.1fms%n%s", response.request().url(), response.code(), (double)(t2 - t1) / 1000000.0, response.headers()));
                if (response.isSuccessful()) {
                    if (response.body().contentLength() > 102400L) {
                        return response;
                    }
                    if (TextUtils.isEmpty((CharSequence)response.header("Cache-Control"))) {
                        response = response.newBuilder().header("Cache-Control", CacheControl.FORCE_CACHE.toString()).removeHeader("Pragma").build();
                    }
                }
                return response;
            }
        };
        REWRITE_CACHE_CONTROL_INTERCEPTOR = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                if (!(originalRequest.tag() instanceof OkRequestHelper) || originalRequest.tag() == null || ((OkRequestHelper)originalRequest.tag()).saveCache) {
                    // empty if block
                }
                Response originalResponse = chain.proceed(chain.request());
                if (!(originalRequest.tag() instanceof OkRequestHelper) || originalRequest.tag() == null || ((OkRequestHelper)originalRequest.tag()).saveCache) {
                    // empty if block
                }
                return originalResponse;
            }
        };
        LoggingInterceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                if (mNetState == NetState.NET_NO) {
                    throw new ConnectException("ENETUNREACH");
                }
                Request request = chain.request();
                long t1 = System.nanoTime();
                if (request.tag() instanceof OkRequestHelper && request.tag() != null) {
                    OkRequestHelper okRequestHelper = (OkRequestHelper)request.tag();
                }
                Response response = null;
                try {
                    response = chain.proceed(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
                long t2 = System.nanoTime();
                return response;
            }
        };
        mNetState = NetState.NET_4G;
        FORM_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded;charset=UTF-8");
        cache = null;
        dnsFilter = new HashMap<String, String>();
    }

    public static class ConnectionChangeReceiver
    extends BroadcastReceiver {
        @TargetApi(value=3)
        public void onReceive(Context context, Intent intent) {
        }
    }

    public static enum NetState {
        NET_NO,
        NET_2G,
        NET_3G,
        NET_4G,
        NET_WIFI,
        NET_UNKNOWN;

    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

