/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.http;

import com.yoogor.abc.network.http.AnalysisState;
import com.yoogor.abc.network.http.OkRequestHelper;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class OkAnalysHelper {
    public static Interceptor analysisIntercepter() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                if (request.tag() instanceof OkRequestHelper) {
                    AnalysisState analysisState = ((OkRequestHelper)request.tag()).analysisState;
                    AnysisRequestBody requestBody = null;
                    if (request.body() != null) {
                        requestBody = new AnysisRequestBody(request.body(), analysisState);
                    }
                    request = request.newBuilder().method(request.method(), requestBody).build();
                    analysisState.startTimeMillis = System.currentTimeMillis();
                    Response response = chain.proceed(request);
                    AnysisResponseBody responseBody = new AnysisResponseBody(response.body(), analysisState);
                    response = response.newBuilder().body((ResponseBody)responseBody).build();
                    return response;
                }
                return chain.proceed(request);
            }
        };
    }

    public static class AnysisRequestBody
    extends RequestBody {
        private RequestBody requestBody;
        private AnalysisState analysisState;

        public AnysisRequestBody(RequestBody requestBody, AnalysisState analysisState) {
            this.requestBody = requestBody;
            this.analysisState = analysisState;
        }

        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.analysisState.requestBeginTimeMillis = System.currentTimeMillis();
            this.requestBody.writeTo(sink);
            this.analysisState.requestEndTimeMillis = System.currentTimeMillis();
        }

        public long contentLength() throws IOException {
            return this.requestBody.contentLength();
        }
    }

    private static class AnysisResponseBody
    extends ResponseBody {
        ResponseBody responseBody;
        AnalysisState analysisState;
        private BufferedSource bufferedSource;

        public AnysisResponseBody(ResponseBody responseBody, AnalysisState analysisState) {
            this.responseBody = responseBody;
            this.analysisState = analysisState;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    this.totalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    try {
                        if (this.totalBytesRead == 0L) {
                            AnysisResponseBody.this.analysisState.responseBeginTimeMillis = System.currentTimeMillis();
                        }
                        this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                        if (bytesRead == -1L) {
                            AnysisResponseBody.this.analysisState.responseEndTimeMillis = System.currentTimeMillis();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return bytesRead;
                }
            };
        }
    }
}

