/*
 * Decompiled with CFR 0.152.
 */
package com.yoogor.abc.network.http;

import com.yoogor.abc.network.http.interf.DownloadCallback;
import com.yoogor.abc.network.http.interf.StatusCode;
import com.yoogor.abc.network.http.interf.UploadCallback;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class OKProgressHelper {

    public static interface ProgressCallback {
        public void onProgress(long var1, long var3, boolean var5);

        public void onResponse(int var1, StatusCode var2, String var3);
    }

    public static class ProgressRequestBody
    extends RequestBody {
        private final RequestBody requestBody;
        private final UploadCallback uploadCallback;
        private final int tag;
        private BufferedSink bufferedSink;

        public ProgressRequestBody(int tag, RequestBody requestBody, UploadCallback progressListener) {
            this.tag = tag;
            this.requestBody = requestBody;
            this.uploadCallback = progressListener;
        }

        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try {
                if (this.bufferedSink == null) {
                    this.bufferedSink = Okio.buffer((Sink)this.sink((Sink)sink));
                }
                this.requestBody.writeTo(this.bufferedSink);
                this.bufferedSink.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public long contentLength() throws IOException {
            return this.requestBody.contentLength();
        }

        private Sink sink(Sink sink) {
            return new ForwardingSink(sink){
                long bytesWritten;
                long contentLength;
                {
                    this.bytesWritten = 0L;
                    this.contentLength = 0L;
                }

                public void write(Buffer source, long byteCount) throws IOException {
                    try {
                        super.write(source, byteCount);
                        if (this.contentLength == 0L) {
                            this.contentLength = ProgressRequestBody.this.requestBody.contentLength();
                        }
                        this.bytesWritten += byteCount;
                        if (ProgressRequestBody.this.uploadCallback != null) {
                            ProgressRequestBody.this.uploadCallback.onProgress(ProgressRequestBody.this.tag, this.bytesWritten, this.contentLength);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
    }

    public static class ProgressResponseBody
    extends ResponseBody {
        private final ResponseBody responseBody;
        private final DownloadCallback downloadCallback;
        private final int tag;
        private BufferedSource bufferedSource;

        public ProgressResponseBody(int tag, ResponseBody responseBody, DownloadCallback progressListener) {
            this.tag = tag;
            this.responseBody = responseBody;
            this.downloadCallback = progressListener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    this.totalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    if (ProgressResponseBody.this.downloadCallback != null) {
                        ProgressResponseBody.this.downloadCallback.onProgress(ProgressResponseBody.this.tag, this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength());
                    }
                    return bytesRead;
                }
            };
        }
    }
}

