/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.yonghui.zxing.DecodeFormatManager;
import com.yonghui.zxing.util.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public final class CodeUtils {
    public static final int DEFAULT_REQ_WIDTH = 450;
    public static final int DEFAULT_REQ_HEIGHT = 800;

    private CodeUtils() {
        throw new AssertionError();
    }

    public static Bitmap createQRCode(String content, int heightPix) {
        return CodeUtils.createQRCode(content, heightPix, null);
    }

    public static Bitmap createQRCode(String content, int heightPix, int codeColor) {
        return CodeUtils.createQRCode(content, heightPix, null, codeColor);
    }

    public static Bitmap createQRCode(String content, int heightPix, Bitmap logo) {
        return CodeUtils.createQRCode(content, heightPix, logo, -16777216);
    }

    public static Bitmap createQRCode(String content, int heightPix, Bitmap logo, int codeColor) {
        return CodeUtils.createQRCode(content, heightPix, logo, 0.2f, codeColor);
    }

    public static Bitmap createQRCode(String content, int heightPix, Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 1);
        return CodeUtils.createQRCode(content, heightPix, logo, ratio, hints);
    }

    public static Bitmap createQRCode(String content, int heightPix, Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio, int codeColor) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 1);
        return CodeUtils.createQRCode(content, heightPix, logo, ratio, hints, codeColor);
    }

    public static Bitmap createQRCode(String content, int heightPix, Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio, Map<EncodeHintType, ?> hints) {
        return CodeUtils.createQRCode(content, heightPix, logo, ratio, hints, -16777216);
    }

    public static Bitmap createQRCode(String content, int heightPix, Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio, Map<EncodeHintType, ?> hints, int codeColor) {
        try {
            BitMatrix bitMatrix = new QRCodeWriter().encode(content, BarcodeFormat.QR_CODE, heightPix, heightPix, hints);
            int[] pixels = new int[heightPix * heightPix];
            for (int y = 0; y < heightPix; ++y) {
                for (int x = 0; x < heightPix; ++x) {
                    pixels[y * heightPix + x] = bitMatrix.get(x, y) ? codeColor : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)heightPix, (int)heightPix, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, heightPix, 0, 0, heightPix, heightPix);
            if (logo != null) {
                bitmap = CodeUtils.addLogo(bitmap, logo, ratio);
            }
            return bitmap;
        }
        catch (WriterException e) {
            LogUtils.w(e.getMessage());
            return null;
        }
    }

    private static Bitmap addLogo(Bitmap src, Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio) {
        if (src == null) {
            return null;
        }
        if (logo == null) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        if (srcWidth == 0 || srcHeight == 0) {
            return null;
        }
        if (logoWidth == 0 || logoHeight == 0) {
            return src;
        }
        float scaleFactor = (float)srcWidth * ratio / (float)logoWidth;
        Bitmap bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            canvas.scale(scaleFactor, scaleFactor, (float)(srcWidth / 2), (float)(srcHeight / 2));
            canvas.drawBitmap(logo, (float)((srcWidth - logoWidth) / 2), (float)((srcHeight - logoHeight) / 2), null);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            bitmap = null;
            LogUtils.w(e.getMessage());
        }
        return bitmap;
    }

    public static String parseQRCode(String bitmapPath) {
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        return CodeUtils.parseQRCode(bitmapPath, hints);
    }

    public static String parseQRCode(String bitmapPath, Map<DecodeHintType, ?> hints) {
        Result result = CodeUtils.parseQRCodeResult(bitmapPath, hints);
        if (result != null) {
            return result.getText();
        }
        return null;
    }

    public static Result parseQRCodeResult(String bitmapPath, Map<DecodeHintType, ?> hints) {
        return CodeUtils.parseQRCodeResult(bitmapPath, 450, 800, hints);
    }

    public static Result parseQRCodeResult(String bitmapPath, int reqWidth, int reqHeight, Map<DecodeHintType, ?> hints) {
        Result result;
        block13: {
            result = null;
            try {
                boolean isReDecode;
                BinaryBitmap bitmap;
                QRCodeReader reader = new QRCodeReader();
                RGBLuminanceSource source = CodeUtils.getRGBLuminanceSource(CodeUtils.compressBitmap(bitmapPath, reqWidth, reqHeight));
                if (source == null) break block13;
                try {
                    bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                    result = reader.decode(bitmap, hints);
                    isReDecode = false;
                }
                catch (Exception e) {
                    isReDecode = true;
                }
                if (isReDecode) {
                    try {
                        bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source.invert()));
                        result = reader.decode(bitmap, hints);
                        isReDecode = false;
                    }
                    catch (Exception e) {
                        isReDecode = true;
                    }
                }
                if (isReDecode) {
                    try {
                        bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
                        result = reader.decode(bitmap, hints);
                        isReDecode = false;
                    }
                    catch (Exception e) {
                        isReDecode = true;
                    }
                }
                if (isReDecode && source.isRotateSupported()) {
                    try {
                        bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source.rotateCounterClockwise()));
                        result = reader.decode(bitmap, hints);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                reader.reset();
            }
            catch (Exception e) {
                LogUtils.w(e.getMessage());
            }
        }
        return result;
    }

    public static String parseCode(String bitmapPath) {
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        Vector<BarcodeFormat> decodeFormats = new Vector<BarcodeFormat>();
        decodeFormats.addAll(DecodeFormatManager.ONE_D_FORMATS);
        decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
        decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
        decodeFormats.addAll(DecodeFormatManager.AZTEC_FORMATS);
        decodeFormats.addAll(DecodeFormatManager.PDF417_FORMATS);
        hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        return CodeUtils.parseCode(bitmapPath, hints);
    }

    public static String parseCode(String bitmapPath, Map<DecodeHintType, Object> hints) {
        Result result = CodeUtils.parseCodeResult(bitmapPath, hints);
        if (result != null) {
            return result.getText();
        }
        return null;
    }

    public static Result parseCodeResult(String bitmapPath, Map<DecodeHintType, Object> hints) {
        return CodeUtils.parseCodeResult(bitmapPath, 450, 800, hints);
    }

    public static Result parseCodeResult(String bitmapPath, int reqWidth, int reqHeight, Map<DecodeHintType, Object> hints) {
        Result result;
        block13: {
            result = null;
            try {
                boolean isReDecode;
                BinaryBitmap bitmap;
                MultiFormatReader reader = new MultiFormatReader();
                reader.setHints(hints);
                RGBLuminanceSource source = CodeUtils.getRGBLuminanceSource(CodeUtils.compressBitmap(bitmapPath, reqWidth, reqHeight));
                if (source == null) break block13;
                try {
                    bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                    result = reader.decodeWithState(bitmap);
                    isReDecode = false;
                }
                catch (Exception e) {
                    isReDecode = true;
                }
                if (isReDecode) {
                    try {
                        bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source.invert()));
                        result = reader.decodeWithState(bitmap);
                        isReDecode = false;
                    }
                    catch (Exception e) {
                        isReDecode = true;
                    }
                }
                if (isReDecode) {
                    try {
                        bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
                        result = reader.decodeWithState(bitmap);
                        isReDecode = false;
                    }
                    catch (Exception e) {
                        isReDecode = true;
                    }
                }
                if (isReDecode && source.isRotateSupported()) {
                    try {
                        bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source.rotateCounterClockwise()));
                        result = reader.decodeWithState(bitmap);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                reader.reset();
            }
            catch (Exception e) {
                LogUtils.w(e.getMessage());
            }
        }
        return result;
    }

    private static Bitmap compressBitmap(String path, int reqWidth, int reqHeight) {
        int size;
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
        float width = newOpts.outWidth;
        float height = newOpts.outHeight;
        int wSize = 1;
        if (width > (float)reqWidth) {
            wSize = (int)(width / (float)reqWidth);
        }
        int hSize = 1;
        if (height > (float)reqHeight) {
            hSize = (int)(height / (float)reqHeight);
        }
        if ((size = Math.max(wSize, hSize)) <= 0) {
            size = 1;
        }
        newOpts.inSampleSize = size;
        newOpts.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
    }

    private static RGBLuminanceSource getRGBLuminanceSource(@NonNull Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        return new RGBLuminanceSource(width, height, pixels);
    }

    public static Bitmap createBarCode(String content, int desiredWidth, int desiredHeight) {
        return CodeUtils.createBarCode(content, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null);
    }

    public static Bitmap createBarCode(String content, BarcodeFormat format, int desiredWidth, int desiredHeight) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, null);
    }

    public static Bitmap createBarCode(String content, int desiredWidth, int desiredHeight, boolean isShowText) {
        return CodeUtils.createBarCode(content, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null, isShowText, 40, -16777216);
    }

    public static Bitmap createBarCode(String content, int desiredWidth, int desiredHeight, boolean isShowText, @ColorInt int codeColor) {
        return CodeUtils.createBarCode(content, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null, isShowText, 40, codeColor);
    }

    public static Bitmap createBarCode(String content, BarcodeFormat format, int desiredWidth, int desiredHeight, Map<EncodeHintType, ?> hints) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, hints, false, 40, -16777216);
    }

    public static Bitmap createBarCode(String content, BarcodeFormat format, int desiredWidth, int desiredHeight, Map<EncodeHintType, ?> hints, boolean isShowText) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, hints, isShowText, 40, -16777216);
    }

    public static Bitmap createBarCode(String content, BarcodeFormat format, int desiredWidth, int desiredHeight, boolean isShowText, @ColorInt int codeColor) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, null, isShowText, 40, codeColor);
    }

    public static Bitmap createBarCode(String content, BarcodeFormat format, int desiredWidth, int desiredHeight, Map<EncodeHintType, ?> hints, boolean isShowText, @ColorInt int codeColor) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, hints, isShowText, 40, codeColor);
    }

    public static Bitmap createBarCode(String content, BarcodeFormat format, int desiredWidth, int desiredHeight, Map<EncodeHintType, ?> hints, boolean isShowText, int textSize, @ColorInt int codeColor) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        int WHITE = -1;
        int BLACK = codeColor;
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            BitMatrix result = writer.encode(content, format, desiredWidth, desiredHeight, hints);
            int width = result.getWidth();
            int height = result.getHeight();
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                int offset = y * width;
                for (int x = 0; x < width; ++x) {
                    pixels[offset + x] = result.get(x, y) ? BLACK : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            if (isShowText) {
                return CodeUtils.addCode(bitmap, content, textSize, codeColor, textSize / 2);
            }
            return bitmap;
        }
        catch (WriterException e) {
            LogUtils.w(e.getMessage());
            return null;
        }
    }

    private static Bitmap addCode(Bitmap src, String code, int textSize, @ColorInt int textColor, int offset) {
        if (src == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        if (srcWidth <= 0 || srcHeight <= 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)srcWidth, (int)(srcHeight + textSize + offset * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            TextPaint paint = new TextPaint();
            paint.setTextSize((float)textSize);
            paint.setColor(textColor);
            paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(code, (float)(srcWidth / 2), (float)(srcHeight + textSize / 2 + offset), (Paint)paint);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            bitmap = null;
            LogUtils.w(e.getMessage());
        }
        return bitmap;
    }
}

